/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.testng.BTestNg;
import com.tridium.testng.CustomTestNG;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.test.BISystemTest;
import org.testng.Assert;
import org.testng.IResultMap;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.JUnitReportReporter;
import org.testng.reporters.VerboseReporter;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.jq.Main;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;

public class TestRunnerNg {
    private CustomTestNG testng = null;
    HashSet<ClassLoader> loaders = null;
    private String testJar = null;
    private String xmlPathInJar = null;
    private int verbosity = 0;
    private String groups = null;
    private String excludegroups = null;
    private String reportDirectory = null;
    private int failed = 0;
    private int passed = 0;
    private int skipped = 0;

    public void run(Type type) {
        this.init();
        this.testng.setTestClasses(new Class[]{type.getTypeClass()});
        this.loaders.add(type.getTypeClass().getClassLoader());
        this.addTestNGClassLoaders();
        this.testng.run();
        this.end();
    }

    public void run(Type type, Method method) {
        this.init();
        XmlClass xmlClass = new XmlClass(type.getTypeClass());
        List<XmlInclude> list = xmlClass.getIncludedMethods();
        for (XmlInclude object2 : list) {
            System.out.println(object2.getName());
        }
        List list2 = Lists.newArrayList();
        list2.add(new XmlInclude(method.getName()));
        xmlClass.setIncludedMethods(list2);
        List list3 = Lists.newArrayList();
        list3.add(type.getTypeClass());
        this.loaders.add(type.getTypeClass().getClassLoader());
        this.addTestNGClassLoaders();
        this.testng.setTestClasses(list3.toArray(new Class[0]));
        this.testng.run();
        this.end();
    }

    public void run() {
        this.init();
        List list = Lists.newArrayList();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BTestNg.TYPE.getTypeInfo());
        for (int i = 0; i < typeInfoArray.length; ++i) {
            try {
                if (!typeInfoArray[i].is(BISystemTest.TYPE)) {
                    list.add(typeInfoArray[i].getTypeSpec().getResolvedType().getTypeClass());
                }
                this.loaders.add(typeInfoArray[i].getTypeSpec().getResolvedType().getTypeClass().getClassLoader());
                continue;
            }
            catch (TypeException typeException) {
                System.out.println("ERROR Can not resolve type: " + typeInfoArray[i]);
                System.out.println("      Reason: " + typeException.getCause());
                if (!(typeException.getCause() instanceof OutOfMemoryError)) continue;
                System.gc();
            }
        }
        this.addTestNGClassLoaders();
        this.testng.setTestClasses(list.toArray(new Class[0]));
        this.testng.run();
        this.end();
    }

    public void run(ModuleInfo moduleInfo) {
        this.init();
        if (moduleInfo instanceof NModuleInfo && !((NModuleInfo)moduleInfo).isAutoload()) {
            try {
                ((NRegistry)Sys.getRegistry()).loadModule(moduleInfo.getModuleName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((NRegistry)Sys.getRegistry()).syncModules();
            moduleInfo = Sys.getRegistry().getModule(moduleInfo.getModuleName());
        }
        List list = Lists.newArrayList();
        TypeInfo[] typeInfoArray = moduleInfo.getTypes();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo = typeInfoArray[i];
            if (typeInfo.isAbstract() || !typeInfo.is(BTestNg.TYPE) || typeInfo.is(BISystemTest.TYPE)) continue;
            list.add(typeInfo.getTypeSpec().getResolvedType().getTypeClass());
            this.loaders.add(typeInfo.getTypeSpec().getResolvedType().getTypeClass().getClassLoader());
        }
        this.addTestNGClassLoaders();
        this.testng.setTestClasses(list.toArray(new Class[0]));
        this.testng.run();
        this.end();
    }

    public void init() {
        if (this.testng == null) {
            this.testng = new CustomTestNG(false);
        }
        this.loaders = new HashSet();
        TestListener testListener = new TestListener();
        this.testng.addListener(testListener);
        if (this.reportDirectory != null) {
            File file = new File(this.reportDirectory);
            if (!file.exists() && !file.mkdirs()) {
                System.out.println("  ERROR - Unable to create output directory for reports");
            }
            this.testng.setOutputDirectory(this.reportDirectory);
        } else {
            File file = new File(Nre.bajaHome, "reports" + File.separator + "testng");
            if (!file.exists() && !file.mkdirs()) {
                System.out.println("  ERROR - Unable to create output directory for reports");
            }
            String string = file.getAbsolutePath();
            this.testng.setOutputDirectory(string);
        }
        this.testng.addListener(new Main());
        this.testng.addListener(new JUnitReportReporter());
        this.testng.addListener(new XMLReporter());
        this.testng.addListener(new EmailableReporter());
        if (this.verbosity > 4) {
            this.testng.addListener(new VerboseReporter("[TestNG] "));
        }
        if (this.verbosity != 0) {
            this.testng.setVerbose(this.verbosity);
        }
        if (this.groups != null && this.groups.length() > 0) {
            this.testng.setGroups(this.groups);
        }
        if (this.excludegroups != null && this.excludegroups.length() > 0) {
            this.testng.setExcludedGroups(this.excludegroups);
        }
    }

    public void end() {
        int n;
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        Thread[] threadArray = new Thread[threadGroup2.activeCount()];
        while (threadGroup2.enumerate(threadArray, true) == threadArray.length) {
            threadArray = new Thread[threadArray.length * 2];
        }
        for (n = 0; n < threadArray.length; ++n) {
            if (threadArray[n] == null || threadArray[n] == Thread.currentThread() || threadArray[n].isDaemon()) continue;
            System.err.println("[INFO] found running user threads, sleeping to allow potential cleanup");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
            break;
        }
        threadArray = new Thread[threadGroup2.activeCount()];
        while (threadGroup2.enumerate(threadArray, true) == threadArray.length) {
            threadArray = new Thread[threadArray.length * 2];
        }
        for (n = 0; n < threadArray.length; ++n) {
            try {
                if (threadArray[n] == null || threadArray[n] == Thread.currentThread() || threadArray[n].isDaemon()) continue;
                System.err.println("[ERROR] forcing user thread " + threadArray[n].getName() + " to terminate.");
                threadArray[n].stop();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.testng = null;
        this.loaders = null;
    }

    private void addTestNGClassLoaders() {
        if (this.loaders == null) {
            return;
        }
        for (ClassLoader classLoader : this.loaders) {
            this.testng.addClassLoader(classLoader);
        }
    }

    private void loadTestProperties() {
        File file = new File(Nre.bajaHome, "lib" + File.separator + "testng.properties");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            for (String string : properties.keySet()) {
                if (System.getProperty(string) != null) continue;
                System.getProperties().setProperty(string, properties.getProperty(string).trim());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("WARNING: Cannot load " + file + ": File not found");
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot load " + file + ": " + throwable);
        }
    }

    public static void pass() {
        Assert.assertTrue(true);
    }

    public static void fail(String string) {
        Assert.fail(string);
    }

    public String getTestJar() {
        return this.testJar;
    }

    public void setTestJar(String string) {
        this.testJar = string;
    }

    public String getXmlPathInJar() {
        return this.xmlPathInJar;
    }

    public void setXmlPathInJar(String string) {
        this.xmlPathInJar = string;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String string) {
        this.groups = string;
    }

    public String getExcludeGroups() {
        return this.excludegroups;
    }

    public void setExcludeGroups(String string) {
        this.excludegroups = string;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String string) {
        this.reportDirectory = string;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public class TestListener
    extends TestListenerAdapter {
        public void onTestFailure(ITestResult iTestResult) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Failed: " + iTestResult.getName());
            }
        }

        public void onTestSkipped(ITestResult iTestResult) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Skipped: " + iTestResult.getName());
            }
        }

        public void onTestSuccess(ITestResult iTestResult) {
            if (TestRunnerNg.this.verbosity != 0) {
                System.out.println(" TestNG Test Ended: " + iTestResult.getName());
            }
        }

        public void onFinish(ITestContext iTestContext) {
            IResultMap iResultMap = iTestContext.getFailedTests();
            TestRunnerNg.this.failed = TestRunnerNg.this.failed + iResultMap.size();
            TestRunnerNg.this.passed = TestRunnerNg.this.passed + iTestContext.getPassedTests().size();
            TestRunnerNg.this.skipped = TestRunnerNg.this.skipped + iTestContext.getSkippedTests().size();
            Set<ITestResult> set = iResultMap.getAllResults();
            if (set.isEmpty()) {
                return;
            }
            System.out.println("\n*** TestNG Failure Summary ***");
            for (ITestResult iTestResult : set) {
                Throwable throwable;
                System.out.println(" TestNG Test Failed: " + iTestResult.getName());
                if (TestRunnerNg.this.verbosity == 0 || (throwable = iTestResult.getThrowable()) == null) continue;
                System.out.println(" TestNG Error Stack Trace: ");
                throwable.printStackTrace();
            }
        }
    }
}

