/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProGuestBook.visitor.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VykonKeyboardLayout {
    private static HashMap layouts = new HashMap();
    private static final BOrd defLayout = BOrd.make((String)"module://guestBook/com/vykon/guestBook/visitor/ui/keyboard.xml");
    protected static final Lexicon lex;
    private ArrayList rows;
    static /* synthetic */ Class class$com$vykon$vykonProGuestBook$visitor$ui$VykonKeyboardLayout;

    public static VykonKeyboardLayout make() throws Exception {
        String string = Sys.getLanguage();
        BOrd bOrd = null;
        bOrd = string.equals("en") ? defLayout : BOrd.make((String)("file:!lexicon/" + string + "/keyboard.xml"));
        return VykonKeyboardLayout.make(bOrd);
    }

    public static VykonKeyboardLayout make(BOrd bOrd) throws Exception {
        VykonKeyboardLayout vykonKeyboardLayout = (VykonKeyboardLayout)layouts.get(bOrd.toString(null));
        if (vykonKeyboardLayout == null) {
            vykonKeyboardLayout = new VykonKeyboardLayout();
            try {
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                InputStream inputStream = bIFile.getInputStream();
                vykonKeyboardLayout.parse(inputStream);
                layouts.put(bOrd.toString(null), vykonKeyboardLayout);
            }
            catch (Exception exception) {
                System.out.println("### Can't load keyboard for '" + bOrd.toString(null) + "', falling back to default.");
                BOrd bOrd2 = defLayout;
                BIFile bIFile = (BIFile)bOrd2.resolve().get();
                InputStream inputStream = bIFile.getInputStream();
                vykonKeyboardLayout.parse(inputStream);
                layouts.put(bOrd.toString(null), vykonKeyboardLayout);
            }
        }
        return vykonKeyboardLayout;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getKeyCount(int n) {
        return ((Key[])this.rows.get(n)).length;
    }

    public Key getKey(int n, int n2) {
        Key[] keyArray = (Key[])this.rows.get(n);
        return keyArray[n2];
    }

    public void parse(InputStream inputStream) throws Exception {
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        if (!xElem.name().equals("keyboard")) {
            throw new XException("Expecting <keyboard> not <" + xElem.name() + '>', xElem);
        }
        if (xElem.attrSize() != 0) {
            throw new XException("No attributes allowed on <keyboard>", xElem);
        }
        this.parseRows(xElem.elems());
    }

    private final void parseRows(XElem[] xElemArray) {
        this.rows = new ArrayList();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            if (!xElem.name().equals("row")) {
                throw new XException("Expecting <row> not <" + xElem.name() + '>', xElem);
            }
            if (xElem.attrSize() != 0) {
                throw new XException("No attributes allowed on <row>", xElem);
            }
            this.rows.add(this.parseRow(xElem.elems()));
            ++n;
        }
    }

    private final Key[] parseRow(XElem[] xElemArray) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (!xElem.name().equals("key")) {
                throw new XException("Expecting <key> not <" + xElem.name() + '>', xElem);
            }
            if (xElem.elems().length != 0) {
                throw new XException("No children allowed in <key>", xElem);
            }
            int n2 = 0;
            while (n2 < xElem.attrSize()) {
                String string6 = xElem.attrName(n2);
                String string7 = xElem.attrValue(n2);
                if (string6.equals("code")) {
                    string = string7;
                } else if (string6.equals("normal")) {
                    string2 = string7;
                } else if (string6.equals("shift")) {
                    string3 = string7;
                } else if (string6.equals("alt")) {
                    string4 = string7;
                } else if (string6.equals("label")) {
                    string5 = string7;
                } else {
                    throw new XException("Invalid attribute for <key>: '" + string6 + '\'', xElem);
                }
                ++n2;
            }
            if (string == null) {
                throw new XException("'code' attribute required for <key>", xElem);
            }
            if (string2 == null) {
                throw new XException("'normal' attribute required for <key>", xElem);
            }
            Key key = new Key();
            try {
                key.code = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XException("'code' value must be an integer: " + string, xElem);
            }
            if (string2.length() != 1) {
                throw new XException("'normal' value must be 1 char long: " + string2, xElem);
            }
            if (string3 != null && string3.length() != 1) {
                throw new XException("'shift' value must be 1 char long: " + string3, xElem);
            }
            if (string4 != null && string4.length() != 1) {
                throw new XException("'alt' value must be 1 char long: " + string4, xElem);
            }
            key.normal = string2.charAt(0);
            key.shift = string3 == null ? key.normal : string3.charAt(0);
            key.alt = string4 == null ? key.normal : string4.charAt(0);
            key.label = string5;
            arrayList.add(key);
            ++n;
        }
        return arrayList.toArray(new Key[arrayList.size()]);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$vykon$vykonProGuestBook$visitor$ui$VykonKeyboardLayout;
        if (clazz == null) {
            clazz = class$com$vykon$vykonProGuestBook$visitor$ui$VykonKeyboardLayout = VykonKeyboardLayout.class("[Lcom.vykon.vykonProGuestBook.visitor.ui.VykonKeyboardLayout;", false);
        }
        lex = Lexicon.make((Class)clazz);
    }

    public static class Key {
        public int code;
        public char normal;
        public char shift;
        public char alt;
        public String label;
    }
}

