/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProGuestBook;

import com.vykon.vykonProGuestBook.BGuestBookRecord;
import com.vykon.vykonProGuestBook.enums.BDepartmentsEnum;
import com.vykon.vykonProGuestBook.visitor.BVisitorExt;
import com.vykon.vykonProGuestBook.visitor.BVisitorInfo;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGuestBook
extends BComponent {
    public static final Property historyName = BGuestBook.newProperty((int)256, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property historyNameFormat = BGuestBook.newProperty((int)6, (BValue)BFormat.make((String)"%parent.name%"), null);
    public static final Property capacity = BGuestBook.newProperty((int)256, (BValue)BCapacity.makeByRecordCount((int)500), null);
    public static final Property visitors = BGuestBook.newProperty((int)0, (BValue)new BVisitorExt(), null);
    public static final Property visitingFacet = BGuestBook.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BDepartmentsEnum.TYPE)), null);
    public static final Property wizardImage = BGuestBook.newProperty((int)256, (BValue)BOrd.make((String)"module://vykonProGuestBook/images/VykonTransparent.gif"), null);
    public static final Property wizardTitle = BGuestBook.newProperty((int)256, (String)"Visitor Sign In Log", null);
    public static final Property wizardDescription = BGuestBook.newProperty((int)256, (String)"vykonPro Visitor Log", null);
    public static final Property useAutofillRepresenting = BGuestBook.newProperty((int)256, (boolean)false, null);
    public static final Property autofillRepresenting = BGuestBook.newProperty((int)256, (String)"none", null);
    public static final Property useAutofillVisiting = BGuestBook.newProperty((int)256, (boolean)false, null);
    public static final Property autofillVisiting = BGuestBook.newProperty((int)256, (String)"none", null);
    public static final Type TYPE;
    private static final BIcon icon;
    BHistoryService service;
    BHistoryConfig config;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$vykon$vykonProGuestBook$BGuestBook;

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat bFormat) {
        this.set(historyName, (BValue)bFormat, null);
    }

    public BFormat getHistoryNameFormat() {
        return (BFormat)this.get(historyNameFormat);
    }

    public void setHistoryNameFormat(BFormat bFormat) {
        this.set(historyNameFormat, (BValue)bFormat, null);
    }

    public BCapacity getCapacity() {
        return (BCapacity)this.get(capacity);
    }

    public void setCapacity(BCapacity bCapacity) {
        this.set(capacity, (BValue)bCapacity, null);
    }

    public BVisitorExt getVisitors() {
        return (BVisitorExt)this.get(visitors);
    }

    public void setVisitors(BVisitorExt bVisitorExt) {
        this.set(visitors, (BValue)bVisitorExt, null);
    }

    public BFacets getVisitingFacet() {
        return (BFacets)this.get(visitingFacet);
    }

    public void setVisitingFacet(BFacets bFacets) {
        this.set(visitingFacet, (BValue)bFacets, null);
    }

    public BOrd getWizardImage() {
        return (BOrd)this.get(wizardImage);
    }

    public void setWizardImage(BOrd bOrd) {
        this.set(wizardImage, (BValue)bOrd, null);
    }

    public String getWizardTitle() {
        return this.getString(wizardTitle);
    }

    public void setWizardTitle(String string) {
        this.setString(wizardTitle, string, null);
    }

    public String getWizardDescription() {
        return this.getString(wizardDescription);
    }

    public void setWizardDescription(String string) {
        this.setString(wizardDescription, string, null);
    }

    public boolean getUseAutofillRepresenting() {
        return this.getBoolean(useAutofillRepresenting);
    }

    public void setUseAutofillRepresenting(boolean bl) {
        this.setBoolean(useAutofillRepresenting, bl, null);
    }

    public String getAutofillRepresenting() {
        return this.getString(autofillRepresenting);
    }

    public void setAutofillRepresenting(String string) {
        this.setString(autofillRepresenting, string, null);
    }

    public boolean getUseAutofillVisiting() {
        return this.getBoolean(useAutofillVisiting);
    }

    public void setUseAutofillVisiting(boolean bl) {
        this.setBoolean(useAutofillVisiting, bl, null);
    }

    public String getAutofillVisiting() {
        return this.getString(autofillVisiting);
    }

    public void setAutofillVisiting(String string) {
        this.setString(autofillVisiting, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)capacity) || property.equals((Object)historyName)) {
            try {
                this.updateConfig();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addVisitor(BVisitorInfo bVisitorInfo) {
        try {
            this.service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return;
        }
        try {
            BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (bHistoryDatabase == null) {
                System.out.println("Local history database not available.");
                return;
            }
            BHistoryId bHistoryId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
            if (!bHistoryDatabase.exists(bHistoryId)) {
                this.createHistory();
            }
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            BAbsTime bAbsTime = bIHistory.getLastTimestamp();
            BAbsTime bAbsTime2 = bVisitorInfo.getTimeIn();
            if (bAbsTime2.isAfter(bAbsTime)) {
                BGuestBookRecord bGuestBookRecord = new BGuestBookRecord(bAbsTime2, BAbsTime.NULL, bVisitorInfo.getBadgeNumber(), bVisitorInfo.getLastName(), bVisitorInfo.getFirstName(), bVisitorInfo.getRepresenting(), bVisitorInfo.getVisiting());
                bIHistory.append((BIHistoryRecordSet)bGuestBookRecord);
            } else {
                System.out.println(bAbsTime2.encodeToString() + " is before " + bAbsTime.encodeToString() + " for " + bHistoryId + ", cannot append record");
            }
        }
        catch (Exception exception) {
            System.out.println("Error creating the history...");
            exception.printStackTrace();
        }
    }

    public void removeVisitor(BVisitorInfo bVisitorInfo) {
        try {
            BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (bHistoryDatabase == null) {
                System.out.println("Local history database not available.");
                return;
            }
            BHistoryId bHistoryId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            BAbsTime bAbsTime = bVisitorInfo.getTimeIn();
            BAbsTime bAbsTime2 = bVisitorInfo.getTimeOut();
            String string = bVisitorInfo.getBadgeNumber();
            String string2 = bVisitorInfo.getLastName();
            String string3 = bVisitorInfo.getFirstName();
            String string4 = bVisitorInfo.getRepresenting();
            String string5 = bVisitorInfo.getVisiting();
            BGuestBookRecord bGuestBookRecord = new BGuestBookRecord(bAbsTime, bAbsTime2, string, string2, string3, string4, string5);
            bIHistory.update((BHistoryRecord)bGuestBookRecord, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void createHistory() throws Exception {
        try {
            BHistoryConfig bHistoryConfig = this.createConfig();
            BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (bHistoryDatabase == null) {
                System.out.println("Local history database not available.");
                return;
            }
            bHistoryDatabase.createHistory(bHistoryConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final BHistoryConfig createConfig() throws Exception {
        BHistoryId bHistoryId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
        BTypeSpec bTypeSpec = BTypeSpec.make((String)"vykonProGuestBook", (String)"GuestBookRecord");
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, bTypeSpec);
        BOrdList bOrdList = BOrdList.make((BOrd)this.getSourceOrd());
        bHistoryConfig.setSource(bOrdList);
        BOrd bOrd = this.getHandleOrd();
        bHistoryConfig.setSourceHandle(bOrd);
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        bHistoryConfig.setCapacity(this.getCapacity());
        return bHistoryConfig;
    }

    private final void updateConfig() throws Exception {
        BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        if (bHistoryDatabase == null) {
            System.out.println("Local history database not available.");
            return;
        }
        BHistoryConfig bHistoryConfig = this.createConfig();
        bHistoryDatabase.reconfigureHistory(bHistoryConfig);
    }

    public String resolveHistoryName() {
        BFormat bFormat = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)bFormat.format((Object)this)));
    }

    public BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.service = null;
        this.config = null;
        this.ticket = null;
    }

    public BGuestBook() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonProGuestBook$BGuestBook;
        if (clazz == null) {
            clazz = class$com$vykon$vykonProGuestBook$BGuestBook = BGuestBook.class("[Lcom.vykon.vykonProGuestBook.BGuestBook;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"alphabetize.png");
    }
}

