/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.WinBMPFileFormat;

public final class WinICOFileFormat
extends FileFormat {
    final byte[] bitInvertData(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = (byte)(255 - byArray[n3 - n]);
            ++n3;
        }
        return byArray;
    }

    static final byte[] convertPad(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return byArray;
        }
        int n6 = (n * n3 + 7) / 8;
        int n7 = (n6 + (n4 - 1)) / n4 * n4;
        int n8 = (n6 + (n5 - 1)) / n5 * n5;
        byte[] byArray2 = new byte[n2 * n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n2) {
            System.arraycopy(byArray, n9, byArray2, n10, n8);
            n9 += n7;
            n10 += n8;
            ++n11;
        }
        return byArray2;
    }

    final int iconSize(ImageData imageData) {
        int n = (imageData.width * imageData.depth + 31) / 32 * 4;
        int n2 = (imageData.width + 31) / 32 * 4;
        int n3 = (n + n2) * imageData.height;
        int n4 = 0;
        if (imageData.palette.colors != null) {
            n4 = imageData.palette.colors.length * 4;
        }
        int n5 = n4;
        return 40 + n5 + n3;
    }

    final boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[4];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            boolean bl = false;
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 1 && byArray[3] == 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    final boolean isValidIcon(ImageData imageData) {
        switch (imageData.depth) {
            case 1: 
            case 4: 
            case 8: {
                if (imageData.palette.isDirect) {
                    return false;
                }
                int n = imageData.palette.colors.length;
                boolean bl = false;
                if (n == 2 || n == 16 || n == 32 || n == 256) {
                    bl = true;
                }
                return bl;
            }
            case 24: 
            case 32: {
                return imageData.palette.isDirect;
            }
        }
        return false;
    }

    final int loadFileHeader(LEDataInputStream lEDataInputStream) {
        int n;
        int[] nArray = new int[3];
        try {
            nArray[0] = lEDataInputStream.readShort();
            nArray[1] = lEDataInputStream.readShort();
            nArray[2] = lEDataInputStream.readShort();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 0 || nArray[1] != 1) {
            SWT.error(40);
        }
        if ((n = nArray[2]) <= 0) {
            SWT.error(40);
        }
        return n;
    }

    final int loadFileHeader(LEDataInputStream lEDataInputStream, boolean bl) {
        int n;
        int[] nArray = new int[3];
        try {
            if (bl) {
                nArray[0] = lEDataInputStream.readShort();
                nArray[1] = lEDataInputStream.readShort();
            } else {
                nArray[0] = 0;
                nArray[1] = 1;
            }
            nArray[2] = lEDataInputStream.readShort();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 0 || nArray[1] != 1) {
            SWT.error(40);
        }
        if ((n = nArray[2]) <= 0) {
            SWT.error(40);
        }
        return n;
    }

    final ImageData[] loadFromByteStream() {
        int n = this.loadFileHeader(this.inputStream);
        int[][] nArray = this.loadIconHeaders(n);
        ImageData[] imageDataArray = new ImageData[nArray.length];
        int n2 = 0;
        while (n2 < imageDataArray.length) {
            imageDataArray[n2] = this.loadIcon(nArray[n2]);
            ++n2;
        }
        return imageDataArray;
    }

    final ImageData loadIcon(int[] nArray) {
        byte[] byArray = this.loadInfoHeader(nArray);
        WinBMPFileFormat winBMPFileFormat = new WinBMPFileFormat();
        winBMPFileFormat.inputStream = this.inputStream;
        PaletteData paletteData = winBMPFileFormat.loadPalette(byArray);
        byte[] byArray2 = winBMPFileFormat.loadData(byArray);
        int n = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n2 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        byArray[14] = 1;
        byArray[15] = 0;
        byte[] byArray3 = winBMPFileFormat.loadData(byArray);
        byArray3 = WinICOFileFormat.convertPad(byArray3, n, n2, 1, 4, 2);
        this.bitInvertData(byArray3, 0, byArray3.length);
        return ImageData.internal_new(n, n2, n3, paletteData, 4, byArray2, 2, byArray3, null, -1, -1, 3, 0, 0, 0, 0);
    }

    final int[][] loadIconHeaders(int n) {
        int[][] nArray = new int[n][7];
        try {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2][0] = this.inputStream.read();
                nArray[n2][1] = this.inputStream.read();
                nArray[n2][2] = this.inputStream.readShort();
                nArray[n2][3] = this.inputStream.readShort();
                nArray[n2][4] = this.inputStream.readShort();
                nArray[n2][5] = this.inputStream.readInt();
                nArray[n2][6] = this.inputStream.readInt();
                ++n2;
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return nArray;
    }

    final byte[] loadInfoHeader(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (n3 == 0) {
            n3 = 256;
        }
        if (n3 != 2 && n3 != 8 && n3 != 16 && n3 != 32 && n3 != 256) {
            SWT.error(40);
        }
        if (this.inputStream.getPosition() < nArray[6]) {
            try {
                this.inputStream.skip(nArray[6] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
                return null;
            }
        }
        byte[] byArray = new byte[40];
        try {
            this.inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if ((byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8) != 1) {
            SWT.error(40);
        }
        int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n5 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n6 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        if (n2 == n5 && n6 == 1) {
            n2 /= 2;
        }
        if (n != n4 || n2 * 2 != n5 || n6 != 1 && n6 != 4 && n6 != 8 && n6 != 24 && n6 != 32) {
            SWT.error(40);
        }
        byArray[8] = (byte)(n2 & 0xFF);
        byArray[9] = (byte)(n2 >> 8 & 0xFF);
        byArray[10] = (byte)(n2 >> 16 & 0xFF);
        byArray[11] = (byte)(n2 >> 24 & 0xFF);
        return byArray;
    }

    final void unloadIcon(ImageData imageData) {
        int n = ((imageData.width * imageData.depth + 31) / 32 * 4 + (imageData.width + 31) / 32 * 4) * imageData.height;
        try {
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(imageData.width);
            this.outputStream.writeInt(imageData.height * 2);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
            this.outputStream.writeInt(0);
            this.outputStream.writeInt(n);
            this.outputStream.writeInt(0);
            this.outputStream.writeInt(0);
            int n2 = 0;
            if (imageData.palette.colors != null) {
                n2 = imageData.palette.colors.length;
            }
            this.outputStream.writeInt(n2);
            this.outputStream.writeInt(0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        byte[] byArray = WinBMPFileFormat.paletteToBytes(imageData.palette);
        try {
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.unloadShapeData(imageData);
        this.unloadMaskData(imageData);
    }

    final void unloadIconHeader(ImageData imageData) {
        int n = 16;
        int n2 = n + 6;
        int n3 = this.iconSize(imageData);
        try {
            this.outputStream.write(imageData.width);
            this.outputStream.write(imageData.height);
            int n4 = 0;
            if (imageData.palette.colors != null) {
                n4 = imageData.palette.colors.length;
            }
            this.outputStream.writeShort(n4);
            this.outputStream.writeShort(0);
            this.outputStream.writeShort(0);
            this.outputStream.writeInt(n3);
            this.outputStream.writeInt(n2);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    final void unloadIntoByteStream(ImageLoader imageLoader) {
        ImageData imageData = imageLoader.data[0];
        if (!this.isValidIcon(imageData)) {
            SWT.error(40);
        }
        try {
            this.outputStream.writeShort(0);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort(1);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.unloadIconHeader(imageData);
        this.unloadIcon(imageData);
    }

    final void unloadMaskData(ImageData imageData) {
        ImageData imageData2 = imageData.getTransparencyMask();
        int n = (imageData.width + 7) / 8;
        int n2 = imageData2.scanlinePad;
        int n3 = (n + n2 - 1) / n2 * n2;
        int n4 = (n + 3) / 4 * 4;
        byte[] byArray = new byte[n4];
        int n5 = (imageData.height - 1) * n3;
        byte[] byArray2 = imageData2.data;
        try {
            int n6 = 0;
            while (n6 < imageData.height) {
                System.arraycopy(byArray2, n5, byArray, 0, n);
                this.bitInvertData(byArray, 0, n);
                this.outputStream.write(byArray, 0, n4);
                n5 -= n3;
                ++n6;
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    final void unloadShapeData(ImageData imageData) {
        int n = (imageData.width * imageData.depth + 7) / 8;
        int n2 = imageData.scanlinePad;
        int n3 = (n + n2 - 1) / n2 * n2;
        int n4 = (n + 3) / 4 * 4;
        byte[] byArray = new byte[n4];
        int n5 = (imageData.height - 1) * n3;
        byte[] byArray2 = imageData.data;
        try {
            int n6 = 0;
            while (n6 < imageData.height) {
                System.arraycopy(byArray2, n5, byArray, 0, n);
                this.outputStream.write(byArray, 0, n4);
                n5 -= n3;
                ++n6;
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }
}

