/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIhdrChunk;

class PngPlteChunk
extends PngChunk {
    int paletteSize;

    int getChunkType() {
        return 1;
    }

    int getPaletteSize() {
        return this.paletteSize;
    }

    PaletteData getPaletteData() {
        RGB[] rGBArray = new RGB[this.paletteSize];
        int n = 0;
        while (n < rGBArray.length) {
            int n2 = 8 + n * 3;
            int n3 = this.reference[n2] & 0xFF;
            int n4 = this.reference[n2 + 1] & 0xFF;
            int n5 = this.reference[n2 + 2] & 0xFF;
            rGBArray[n] = new RGB(n3, n4, n5);
            ++n;
        }
        return new PaletteData(rGBArray);
    }

    void setPaletteData(PaletteData paletteData) {
        RGB[] rGBArray = paletteData.getRGBs();
        int n = 0;
        while (n < rGBArray.length) {
            int n2 = 8 + n * 3;
            this.reference[n2] = (byte)rGBArray[n].red;
            this.reference[n2 + 1] = (byte)rGBArray[n].green;
            this.reference[n2 + 2] = (byte)rGBArray[n].blue;
            ++n;
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        if (!pngFileReadState.readIHDR || pngFileReadState.readPLTE || pngFileReadState.readTRNS || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readPLTE = true;
        }
        super.validate(pngFileReadState, pngIhdrChunk);
        if (this.getLength() % 3 != 0) {
            SWT.error(40);
        }
        if (1 << pngIhdrChunk.getBitDepth() < this.paletteSize) {
            SWT.error(40);
        }
        if (256 < this.paletteSize) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tPalette size:");
        stringBuffer.append(this.paletteSize);
    }

    PngPlteChunk(PaletteData paletteData) {
        super(paletteData.getRGBs().length * 3);
        this.paletteSize = this.length / 3;
        this.setType(TYPE_PLTE);
        this.setPaletteData(paletteData);
        this.setCRC(this.computeCRC());
    }

    PngPlteChunk(byte[] byArray) {
        super(byArray);
        this.paletteSize = this.length / 3;
    }
}

