/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngDeflater;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class PngEncoder {
    static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final byte[] TAG_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TAG_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TAG_TRNS = new byte[]{116, 82, 78, 83};
    static final byte[] TAG_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TAG_IEND = new byte[]{73, 69, 78, 68};
    ByteArrayOutputStream bytes;
    PngChunk chunk;
    ImageLoader loader;
    ImageData data;
    int transparencyType;
    int width;
    int height;
    int bitDepth;
    int colorType;
    int compressionMethod;
    int filterMethod;
    int interlaceMethod;

    final void writeShort(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        byte[] byArray = new byte[]{by, by2};
        byteArrayOutputStream.write(byArray, 0, 2);
    }

    final void writeInt(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byte by = (byte)(n >> 24 & 0xFF);
        byte by2 = (byte)(n >> 16 & 0xFF);
        byte by3 = (byte)(n >> 8 & 0xFF);
        byte by4 = (byte)(n & 0xFF);
        byte[] byArray = new byte[]{by, by2, by3, by4};
        byteArrayOutputStream.write(byArray, 0, 4);
    }

    final void writeChunk(byte[] byArray, byte[] byArray2) {
        int n = 0;
        if (byArray2 != null) {
            n = byArray2.length;
        }
        int n2 = n;
        this.chunk = new PngChunk(n2);
        this.writeInt(this.bytes, n2);
        this.bytes.write(byArray, 0, 4);
        this.chunk.setType(byArray);
        if (n2 != 0) {
            this.bytes.write(byArray2, 0, n2);
            this.chunk.setData(byArray2);
        } else {
            this.chunk.setCRC(this.chunk.computeCRC());
        }
        this.writeInt(this.bytes, this.chunk.getCRC());
    }

    final void writeSignature() {
        this.bytes.write(SIGNATURE, 0, 8);
    }

    final void writeHeader() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(13);
        this.writeInt(byteArrayOutputStream, this.width);
        this.writeInt(byteArrayOutputStream, this.height);
        byteArrayOutputStream.write(this.bitDepth);
        byteArrayOutputStream.write(this.colorType);
        byteArrayOutputStream.write(this.compressionMethod);
        byteArrayOutputStream.write(this.filterMethod);
        byteArrayOutputStream.write(this.interlaceMethod);
        this.writeChunk(TAG_IHDR, byteArrayOutputStream.toByteArray());
    }

    final void writePalette() {
        RGB[] rGBArray = this.data.palette.getRGBs();
        if (rGBArray.length > 256) {
            SWT.error(40);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(rGBArray.length);
        int n = 0;
        while (n < rGBArray.length) {
            byteArrayOutputStream.write((byte)rGBArray[n].red);
            byteArrayOutputStream.write((byte)rGBArray[n].green);
            byteArrayOutputStream.write((byte)rGBArray[n].blue);
            ++n;
        }
        this.writeChunk(TAG_PLTE, byteArrayOutputStream.toByteArray());
    }

    final void writeTransparency() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (this.transparencyType) {
            case 1: {
                byte[] byArray = new byte[this.data.palette.getRGBs().length];
                int n = 0;
                while (n < this.height) {
                    int n2 = 0;
                    while (n2 < this.width) {
                        int n3 = this.data.getPixel(n2, n);
                        int n4 = this.data.getAlpha(n2, n);
                        byArray[n3] = (byte)n4;
                        ++n2;
                    }
                    ++n;
                }
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                break;
            }
            case 4: {
                int n;
                int n5 = this.data.transparentPixel;
                if (this.colorType == 2) {
                    int n6 = this.data.palette.redMask;
                    n = this.data.palette.redShift;
                    int n7 = this.data.palette.greenMask;
                    int n8 = this.data.palette.greenShift;
                    int n9 = this.data.palette.blueShift;
                    int n10 = this.data.palette.blueMask;
                    int n11 = n5 & n6;
                    n11 = n < 0 ? n11 >>> -n : n11 << n;
                    int n12 = n5 & n7;
                    n12 = n8 < 0 ? n12 >>> -n8 : n12 << n8;
                    int n13 = n5 & n10;
                    n13 = n9 < 0 ? n13 >>> -n9 : n13 << n9;
                    this.writeShort(byteArrayOutputStream, n11);
                    this.writeShort(byteArrayOutputStream, n12);
                    this.writeShort(byteArrayOutputStream, n13);
                }
                if (this.colorType != 3) break;
                byte[] byArray = new byte[n5 + 1];
                n = 0;
                while (n < n5) {
                    byArray[n] = -1;
                    ++n;
                }
                byArray[n5] = 0;
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                break;
            }
        }
        this.writeChunk(TAG_TRNS, byteArrayOutputStream.toByteArray());
    }

    final void writeImageData() throws IOException {
        Object[] objectArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        OutputStream outputStream = Compatibility.newDeflaterOutputStream(byteArrayOutputStream);
        if (outputStream == null) {
            outputStream = byteArrayOutputStream;
        }
        if (this.colorType == 3) {
            objectArray = new byte[this.width];
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                outputStream.write(n2);
                this.data.getPixels(0, n, this.width, (byte[])objectArray, 0);
                int n3 = 0;
                while (n3 < objectArray.length) {
                    outputStream.write(objectArray[n3]);
                    ++n3;
                }
                ++n;
            }
        } else {
            objectArray = new int[this.width];
            byte[] byArray = null;
            if (this.colorType == 6) {
                byArray = new byte[this.width];
            }
            int n = this.data.palette.redMask;
            int n4 = this.data.palette.redShift;
            int n5 = this.data.palette.greenMask;
            int n6 = this.data.palette.greenShift;
            int n7 = this.data.palette.blueShift;
            int n8 = this.data.palette.blueMask;
            int n9 = 0;
            while (n9 < this.height) {
                int n10 = 0;
                outputStream.write(n10);
                this.data.getPixels(0, n9, this.width, (int[])objectArray, 0);
                if (this.colorType == 6) {
                    this.data.getAlphas(0, n9, this.width, byArray, 0);
                }
                int n11 = 0;
                while (n11 < objectArray.length) {
                    byte by = objectArray[n11];
                    int n12 = by & n;
                    n12 = n4 < 0 ? n12 >>> -n4 : n12 << n4;
                    int n13 = by & n5;
                    n13 = n6 < 0 ? n13 >>> -n6 : n13 << n6;
                    int n14 = by & n8;
                    n14 = n7 < 0 ? n14 >>> -n7 : n14 << n7;
                    outputStream.write(n12);
                    outputStream.write(n13);
                    outputStream.write(n14);
                    if (this.colorType == 6) {
                        outputStream.write(byArray[n11]);
                    }
                    ++n11;
                }
                ++n9;
            }
        }
        outputStream.flush();
        outputStream.close();
        objectArray = byteArrayOutputStream.toByteArray();
        if (outputStream == byteArrayOutputStream) {
            PngDeflater pngDeflater = new PngDeflater();
            objectArray = pngDeflater.deflate((byte[])objectArray);
        }
        this.writeChunk(TAG_IDAT, (byte[])objectArray);
    }

    final void writeEnd() {
        this.writeChunk(TAG_IEND, null);
    }

    public final void encode(LEDataOutputStream lEDataOutputStream) {
        try {
            boolean bl;
            this.writeSignature();
            this.writeHeader();
            if (this.colorType == 3) {
                this.writePalette();
            }
            boolean bl2 = false;
            if (this.transparencyType == 1) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            boolean bl4 = false;
            if (this.transparencyType == 4) {
                bl4 = true;
            }
            boolean bl5 = bl4;
            boolean bl6 = false;
            if (this.colorType == 2 && bl5) {
                bl6 = true;
            }
            boolean bl7 = bl6;
            boolean bl8 = false;
            if (this.colorType == 3 && (bl3 || bl5)) {
                bl8 = bl = true;
            }
            if (bl7 || bl) {
                this.writeTransparency();
            }
            this.writeImageData();
            this.writeEnd();
            lEDataOutputStream.write(this.bytes.toByteArray());
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    private final /* synthetic */ void this() {
        this.bytes = new ByteArrayOutputStream(1024);
        this.compressionMethod = 0;
        this.filterMethod = 0;
        this.interlaceMethod = 0;
    }

    public PngEncoder(ImageLoader imageLoader) {
        this.this();
        this.loader = imageLoader;
        this.data = imageLoader.data[0];
        this.transparencyType = this.data.getTransparencyType();
        this.width = this.data.width;
        this.height = this.data.height;
        this.bitDepth = 8;
        this.colorType = 2;
        if (this.data.palette.isDirect) {
            if (this.transparencyType == 1) {
                this.colorType = 6;
            }
        } else {
            this.colorType = 3;
        }
        if (this.colorType != 2 && this.colorType != 3 && this.colorType != 6) {
            SWT.error(40);
        }
    }
}

