/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.PngLzBlockReader;

public class PngDecodingDataStream
extends InputStream {
    static final int PRIME = 65521;
    static final int MAX_BIT = 7;
    InputStream stream;
    byte currentByte;
    int nextBitIndex;
    PngLzBlockReader lzBlockReader;
    int adlerValue;

    void assertImageDataAtEnd() throws IOException {
        this.lzBlockReader.assertCompressedDataAtEnd();
    }

    public void close() throws IOException {
        this.assertImageDataAtEnd();
        this.checkAdler();
    }

    int getNextIdatBits(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 |= this.getNextIdatBit() << n3;
            ++n3;
        }
        return n2;
    }

    int getNextIdatBit() throws IOException {
        if (this.nextBitIndex > 7) {
            this.currentByte = this.getNextIdatByte();
            this.nextBitIndex = 0;
        }
        return (this.currentByte & 1 << this.nextBitIndex) >> this.nextBitIndex++;
    }

    byte getNextIdatByte() throws IOException {
        byte by = (byte)this.stream.read();
        this.nextBitIndex = 8;
        return by;
    }

    void updateAdler(byte by) {
        int n = this.adlerValue & (char)-1;
        int n2 = this.adlerValue >> 16 & (char)-1;
        int n3 = by & 0xFF;
        n = (n + n3) % 65521;
        n2 = (n + n2) % 65521;
        this.adlerValue = n2 << 16 | n;
    }

    public int read() throws IOException {
        byte by = this.lzBlockReader.getNextByte();
        this.updateAdler(by);
        return by & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3;
            }
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n2;
    }

    void error() {
        SWT.error(40);
    }

    private final void readCompressedDataHeader() throws IOException {
        int n;
        int n2;
        byte by;
        byte by2 = this.getNextIdatByte();
        int n3 = (by2 & 0xFF) << 8 | (by = this.getNextIdatByte()) & 0xFF;
        if (n3 % 31 != 0) {
            this.error();
        }
        if ((n2 = by2 & 0xF) != 8) {
            this.error();
        }
        if ((n = (by2 & 0xF0) >> 4) > 7) {
            this.error();
        }
        int n4 = 1 << n + 8;
        this.lzBlockReader.setWindowSize(n4);
        int n5 = by & 0x20;
        if (n5 != 0) {
            this.error();
        }
    }

    void checkAdler() throws IOException {
        int n = (this.getNextIdatByte() & 0xFF) << 24 | (this.getNextIdatByte() & 0xFF) << 16 | (this.getNextIdatByte() & 0xFF) << 8 | this.getNextIdatByte() & 0xFF;
        if (n != this.adlerValue) {
            this.error();
        }
    }

    PngDecodingDataStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.nextBitIndex = 8;
        this.adlerValue = 1;
        this.lzBlockReader = new PngLzBlockReader(this);
        this.readCompressedDataHeader();
        this.lzBlockReader.readNextBlockHeader();
    }
}

