/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIendChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

class PngChunk {
    static final int LENGTH_OFFSET = 0;
    static final int TYPE_OFFSET = 4;
    static final int DATA_OFFSET = 8;
    static final int TYPE_FIELD_LENGTH = 4;
    static final int LENGTH_FIELD_LENGTH = 4;
    static final int MIN_LENGTH = 12;
    static final int CHUNK_UNKNOWN = -1;
    static final int CHUNK_IHDR = 0;
    static final int CHUNK_PLTE = 1;
    static final int CHUNK_IDAT = 2;
    static final int CHUNK_IEND = 3;
    static final int CHUNK_tRNS = 5;
    static final byte[] TYPE_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TYPE_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TYPE_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TYPE_IEND = new byte[]{73, 69, 78, 68};
    static final byte[] TYPE_tRNS = new byte[]{116, 82, 78, 83};
    static final int[] CRC_TABLE = new int[256];
    byte[] reference;
    int length;

    byte[] getReference() {
        return this.reference;
    }

    void setReference(byte[] byArray) {
        this.reference = byArray;
    }

    int getInt16(int n) {
        int n2 = 0;
        n2 |= (this.reference[n] & 0xFF) << 8;
        return n2 |= this.reference[n + 1] & 0xFF;
    }

    void setInt16(int n, int n2) {
        this.reference[n] = (byte)(n2 >> 8 & 0xFF);
        this.reference[n + 1] = (byte)(n2 & 0xFF);
    }

    int getInt32(int n) {
        int n2 = 0;
        n2 |= (this.reference[n] & 0xFF) << 24;
        n2 |= (this.reference[n + 1] & 0xFF) << 16;
        n2 |= (this.reference[n + 2] & 0xFF) << 8;
        return n2 |= this.reference[n + 3] & 0xFF;
    }

    void setInt32(int n, int n2) {
        this.reference[n] = (byte)(n2 >> 24 & 0xFF);
        this.reference[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.reference[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.reference[n + 3] = (byte)(n2 & 0xFF);
    }

    int getLength() {
        return this.length;
    }

    void setLength(int n) {
        this.setInt32(0, n);
        this.length = n;
    }

    byte[] getTypeBytes() {
        byte[] byArray = new byte[4];
        System.arraycopy(this.reference, 4, byArray, 0, 4);
        return byArray;
    }

    void setType(byte[] byArray) {
        if (byArray.length != 4) {
            SWT.error(5);
        }
        System.arraycopy(byArray, 0, this.reference, 4, 4);
    }

    byte[] getData() {
        int n = this.getLength();
        if (this.reference.length < 12 + n) {
            SWT.error(6);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.reference, 8, byArray, 0, n);
        return byArray;
    }

    void setData(byte[] byArray) {
        this.setLength(byArray.length);
        System.arraycopy(byArray, 0, this.reference, 8, byArray.length);
        this.setCRC(this.computeCRC());
    }

    int getCRC() {
        int n = 8 + this.getLength();
        return this.getInt32(n);
    }

    void setCRC(int n) {
        int n2 = 8 + this.getLength();
        this.setInt32(n2, n);
    }

    int getSize() {
        return 12 + this.getLength();
    }

    boolean checkCRC() {
        int n = this.computeCRC();
        int n2 = this.getCRC();
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        return bl;
    }

    int computeCRC() {
        int n = -1;
        int n2 = 4;
        int n3 = 8 + this.getLength();
        int n4 = n2;
        while (n4 < n3) {
            int n5 = (n ^ this.reference[n4]) & 0xFF;
            n = CRC_TABLE[n5] ^ n >> 8 & 0xFFFFFF;
            ++n4;
        }
        return ~n;
    }

    boolean typeMatchesArray(byte[] byArray) {
        int n = 0;
        while (n < 4) {
            if (this.reference[4 + n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean isCritical() {
        char c = (char)this.getTypeBytes()[0];
        boolean bl = false;
        if ('A' <= c && c <= 'Z') {
            bl = true;
        }
        return bl;
    }

    int getChunkType() {
        if (this.typeMatchesArray(TYPE_IHDR)) {
            return 0;
        }
        if (this.typeMatchesArray(TYPE_PLTE)) {
            return 1;
        }
        if (this.typeMatchesArray(TYPE_IDAT)) {
            return 2;
        }
        if (this.typeMatchesArray(TYPE_IEND)) {
            return 3;
        }
        if (this.typeMatchesArray(TYPE_tRNS)) {
            return 5;
        }
        return -1;
    }

    static PngChunk readNextFromStream(LEDataInputStream lEDataInputStream) {
        try {
            int n = 8;
            byte[] byArray = new byte[n];
            int n2 = lEDataInputStream.read(byArray, 0, n);
            lEDataInputStream.unread(byArray);
            if (n2 != n) {
                return null;
            }
            PngChunk pngChunk = new PngChunk(byArray);
            int n3 = pngChunk.getSize();
            byte[] byArray2 = new byte[n3];
            n2 = lEDataInputStream.read(byArray2, 0, n3);
            if (n2 != n3) {
                return null;
            }
            switch (pngChunk.getChunkType()) {
                case 0: {
                    return new PngIhdrChunk(byArray2);
                }
                case 1: {
                    return new PngPlteChunk(byArray2);
                }
                case 2: {
                    return new PngIdatChunk(byArray2);
                }
                case 3: {
                    return new PngIendChunk(byArray2);
                }
                case 5: {
                    return new PngTrnsChunk(byArray2);
                }
            }
            return new PngChunk(byArray2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        byte[] byArray;
        char c;
        if (this.reference.length < 12) {
            SWT.error(40);
        }
        if ('A' > (c = (char)(byArray = this.getTypeBytes())[2]) || c > 'Z') {
            SWT.error(40);
        }
        int n = 0;
        while (n < 4) {
            c = (char)byArray[n];
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                SWT.error(40);
            }
            ++n;
        }
        if (!this.checkCRC()) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuffer stringBuffer) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\n\tLength: ");
        stringBuffer.append(this.getLength());
        stringBuffer.append("\n\tType: ");
        byte[] byArray = this.getTypeBytes();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append((char)byArray[n]);
            ++n;
        }
        this.contributeToString(stringBuffer);
        stringBuffer.append("\n\tCRC: ");
        stringBuffer.append(Integer.toHexString(this.getCRC()));
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    PngChunk(byte[] byArray) {
        this.setReference(byArray);
        if (byArray.length < 4) {
            SWT.error(40);
        }
        this.length = this.getInt32(0);
    }

    PngChunk(int n) {
        this(new byte[12 + n]);
        this.setLength(n);
    }

    static {
        int n = 0;
        while (n < 256) {
            PngChunk.CRC_TABLE[n] = n;
            int n2 = 0;
            while (n2 < 8) {
                PngChunk.CRC_TABLE[n] = (CRC_TABLE[n] & 1) == 0 ? CRC_TABLE[n] >> 1 & Integer.MAX_VALUE : 0xEDB88320 ^ CRC_TABLE[n] >> 1 & Integer.MAX_VALUE;
                ++n2;
            }
            ++n;
        }
    }
}

