/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGScanHeader
extends JPEGVariableSizeSegment {
    public int[][] componentParameters;

    public final int getApproxBitPositionHigh() {
        return this.reference[2 * this.getNumberOfImageComponents() + 7] >> 4;
    }

    public final int getApproxBitPositionLow() {
        return this.reference[2 * this.getNumberOfImageComponents() + 7] & 0xF;
    }

    public final int getEndOfSpectralSelection() {
        return this.reference[2 * this.getNumberOfImageComponents() + 6];
    }

    public final int getNumberOfImageComponents() {
        return this.reference[4];
    }

    public final int getStartOfSpectralSelection() {
        return this.reference[2 * this.getNumberOfImageComponents() + 5];
    }

    final void initializeComponentParameters() {
        int n = this.getNumberOfImageComponents();
        this.componentParameters = new int[0][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 5 + n2 * 2;
            int n4 = this.reference[n3] & 0xFF;
            int n5 = (this.reference[n3 + 1] & 0xFF) >> 4;
            int n6 = this.reference[n3 + 1] & 0xF;
            if (this.componentParameters.length <= n4) {
                int[][] nArrayArray = new int[n4 + 1][];
                System.arraycopy(this.componentParameters, 0, nArrayArray, 0, this.componentParameters.length);
                this.componentParameters = nArrayArray;
            }
            this.componentParameters[n4] = new int[]{n5, n6};
            ++n2;
        }
    }

    public final void initializeContents() {
        int n = this.getNumberOfImageComponents();
        int[][] nArray = this.componentParameters;
        if (n == 0 || n != nArray.length) {
            SWT.error(40);
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 2 + 5;
            int[] nArray2 = nArray[n2];
            this.reference[n3] = (byte)(n2 + 1);
            this.reference[n3 + 1] = (byte)(nArray2[0] * 16 + nArray2[1]);
            ++n2;
        }
    }

    public final void setEndOfSpectralSelection(int n) {
        this.reference[2 * this.getNumberOfImageComponents() + 6] = (byte)n;
    }

    public final void setNumberOfImageComponents(int n) {
        this.reference[4] = (byte)(n & 0xFF);
    }

    public final void setStartOfSpectralSelection(int n) {
        this.reference[2 * this.getNumberOfImageComponents() + 5] = (byte)n;
    }

    public final int signature() {
        return 65498;
    }

    public final boolean verifyProgressiveScan() {
        int n = this.getStartOfSpectralSelection();
        int n2 = this.getEndOfSpectralSelection();
        int n3 = this.getApproxBitPositionLow();
        int n4 = this.getApproxBitPositionHigh();
        int n5 = this.getNumberOfImageComponents();
        if ((n == 0 && n2 == 0 || n <= n2 && n2 <= 63) && n3 <= 13 && n4 <= 13 && (n4 == 0 || n4 == n3 + 1)) {
            boolean bl = false;
            if (n == 0 || n > 0 && n5 == 1) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final boolean isACProgressiveScan() {
        boolean bl = false;
        if (this.getStartOfSpectralSelection() != 0 && this.getEndOfSpectralSelection() != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDCProgressiveScan() {
        boolean bl = false;
        if (this.getStartOfSpectralSelection() == 0 && this.getEndOfSpectralSelection() == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isFirstScan() {
        boolean bl = false;
        if (this.getApproxBitPositionHigh() == 0) {
            bl = true;
        }
        return bl;
    }

    public JPEGScanHeader(byte[] byArray) {
        super(byArray);
    }

    public JPEGScanHeader(LEDataInputStream lEDataInputStream) {
        super(lEDataInputStream);
        this.initializeComponentParameters();
    }
}

