/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class Compatibility {
    public static double PI = Math.PI;
    static double toRadians = PI / 180.0;
    private static ResourceBundle msgs = null;

    public static final int cos(int n, int n2) {
        return (int)(Math.cos((double)n * toRadians) * (double)n2);
    }

    public static final int sin(int n, int n2) {
        return (int)(Math.sin((double)n * toRadians) * (double)n2);
    }

    public static final int ceil(int n, int n2) {
        return (int)Math.ceil((float)n / (float)n2);
    }

    public static final boolean fileExists(String string, String string2) {
        return new File(string, string2).exists();
    }

    public static final int floor(int n, int n2) {
        return (int)Math.floor((double)n / (double)n2);
    }

    public static final int round(int n, int n2) {
        return Math.round((float)n / (float)n2);
    }

    public static final int pow2(int n) {
        if (n >= 1 && n <= 30) {
            return 2 << n - 1;
        }
        if (n != 0) {
            throw new RuntimeException();
        }
        return 1;
    }

    public static final OutputStream newDeflaterOutputStream(OutputStream outputStream) throws IOException {
        return new DeflaterOutputStream(outputStream);
    }

    public static final InputStream newFileInputStream(String string) throws IOException {
        return new FileInputStream(string);
    }

    public static final OutputStream newFileOutputStream(String string) throws IOException {
        return new FileOutputStream(string);
    }

    public static final InputStream newInflaterInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new InflaterInputStream(inputStream));
    }

    public static final boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static final boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static final boolean isSpaceChar(char c) {
        return Character.isSpaceChar(c);
    }

    public static final boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    public static final void exec(String string) throws IOException {
        Runtime.getRuntime().exec(string);
    }

    public static final void exec(String[] stringArray) throws IOException {
        Runtime.getRuntime().exec(stringArray);
    }

    public static final String getMessage(String string) {
        String string2 = string;
        if (string == null) {
            throw new RuntimeException();
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                string2 = msgs.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public static final String getMessage(String string, Object[] objectArray) {
        String string2 = string;
        if (string == null || objectArray == null) {
            throw new RuntimeException();
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                MessageFormat messageFormat = new MessageFormat("");
                messageFormat.applyPattern(msgs.getString(string));
                string2 = messageFormat.format(objectArray);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public static final void interrupt() {
        Thread.currentThread().interrupt();
    }

    public static final boolean equalsIgnoreCase(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }
}

