/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.CloneableCompatibility;

public final class ImageData
implements CloneableCompatibility {
    static final byte[][] ANY_TO_EIGHT = new byte[9][];
    static final byte[] ONE_TO_ONE_MAPPING;
    static final int[][] DITHER_MATRIX;
    static final int BLIT_SRC = 1;
    static final int BLIT_ALPHA = 2;
    static final int BLIT_DITHER = 4;
    static final int ALPHA_OPAQUE = 255;
    static final int ALPHA_TRANSPARENT = 0;
    static final int ALPHA_CHANNEL_SEPARATE = -1;
    static final int ALPHA_CHANNEL_SOURCE = -2;
    static final int ALPHA_MASK_UNPACKED = -3;
    static final int ALPHA_MASK_PACKED = -4;
    static final int ALPHA_MASK_INDEX = -5;
    static final int ALPHA_MASK_RGB = -6;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;
    public int width;
    public int height;
    public int depth;
    public int scanlinePad;
    public int bytesPerLine;
    public byte[] data;
    public PaletteData palette;
    public int transparentPixel;
    public byte[] maskData;
    public int maskPad;
    public byte[] alphaData;
    public int alpha;
    public int type;
    public int x;
    public int y;
    public int disposalMethod;
    public int delayTime;

    final void setAllFields(int n, int n2, int n3, int n4, int n5, byte[] byArray, PaletteData paletteData, int n6, byte[] byArray2, int n7, byte[] byArray3, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.scanlinePad = n4;
        this.bytesPerLine = n5;
        this.data = byArray;
        this.palette = paletteData;
        this.transparentPixel = n6;
        this.maskData = byArray2;
        this.maskPad = n7;
        this.alphaData = byArray3;
        this.alpha = n8;
        this.type = n9;
        this.x = n10;
        this.y = n11;
        this.disposalMethod = n12;
        this.delayTime = n13;
    }

    public static final ImageData internal_new(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        return new ImageData(n, n2, n3, paletteData, n4, byArray, n5, byArray2, byArray3, n6, n7, n8, n9, n10, n11, n12);
    }

    final ImageData colorMaskImage(int n) {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int[] nArray = new int[this.width];
        int n2 = 0;
        while (n2 < this.height) {
            this.getPixels(0, n2, this.width, nArray, 0);
            int n3 = 0;
            while (n3 < this.width) {
                nArray[n3] = n != -1 && nArray[n3] == n ? 0 : 1;
                ++n3;
            }
            imageData.setPixels(0, n2, this.width, nArray, 0);
            ++n2;
        }
        return imageData;
    }

    static final byte[] checkData(byte[] byArray) {
        if (byArray == null) {
            SWT.error(4);
        }
        return byArray;
    }

    public final Object clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byte[] byArray2 = null;
        if (this.maskData != null) {
            byArray2 = new byte[this.maskData.length];
            System.arraycopy(this.maskData, 0, byArray2, 0, this.maskData.length);
        }
        byte[] byArray3 = null;
        if (this.alphaData != null) {
            byArray3 = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, byArray3, 0, this.alphaData.length);
        }
        return new ImageData(this.width, this.height, this.depth, this.palette, this.scanlinePad, byArray, this.maskPad, byArray2, byArray3, this.alpha, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
    }

    public final int getAlpha(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            return 255;
        }
        return this.alphaData[n2 * this.width + n] & 0xFF;
    }

    public final void getAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            int n5 = n4 + n3;
            int n6 = n4;
            while (n6 < n5) {
                byArray[n6] = -1;
                ++n6;
            }
            return;
        }
        System.arraycopy(this.alphaData, n2 * this.width + n, byArray, n4, n3);
    }

    public final int getPixel(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n3 = n2 * this.bytesPerLine + n * 4;
                return ((this.data[n3] & 0xFF) << 24) + ((this.data[n3 + 1] & 0xFF) << 16) + ((this.data[n3 + 2] & 0xFF) << 8) + (this.data[n3 + 3] & 0xFF);
            }
            case 24: {
                int n4 = n2 * this.bytesPerLine + n * 3;
                return ((this.data[n4] & 0xFF) << 16) + ((this.data[n4 + 1] & 0xFF) << 8) + (this.data[n4 + 2] & 0xFF);
            }
            case 16: {
                int n5 = n2 * this.bytesPerLine + n * 2;
                return ((this.data[n5 + 1] & 0xFF) << 8) + (this.data[n5] & 0xFF);
            }
            case 8: {
                int n6 = n2 * this.bytesPerLine + n;
                return this.data[n6] & 0xFF;
            }
            case 4: {
                int n7 = n2 * this.bytesPerLine + (n >> 1);
                int n8 = this.data[n7] & 0xFF;
                if ((n & 1) == 0) {
                    return n8 >> 4;
                }
                return n8 & 0xF;
            }
            case 2: {
                int n9 = n2 * this.bytesPerLine + (n >> 2);
                int n10 = this.data[n9] & 0xFF;
                int n11 = 3 - n % 4;
                int n12 = 3 << n11 * 2;
                return (n10 & n12) >> n11 * 2;
            }
            case 1: {
                int n13 = n2 * this.bytesPerLine + (n >> 3);
                int n14 = this.data[n13] & 0xFF;
                int n15 = 1 << 7 - (n & 7);
                if ((n14 & n15) == 0) {
                    return 0;
                }
                return 1;
            }
        }
        SWT.error(38);
        return 0;
    }

    public final void getPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = 0;
        int n6 = n3;
        int n7 = n4;
        int n8 = n;
        int n9 = n2;
        switch (this.depth) {
            case 8: {
                int n10 = n2 * this.bytesPerLine + n;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n7] = this.data[n10];
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n10;
                    }
                    ++n11;
                }
                return;
            }
            case 4: {
                int n12;
                int n13 = n2 * this.bytesPerLine + (n >> 1);
                if ((n & 1) == 1) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n7] = (byte)(n12 & 0xF);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n13;
                    }
                }
                while (n6 > 1) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n7] = (byte)(n12 >> 4);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    byArray[n7] = (byte)(n12 & 0xF);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n13;
                }
                if (n6 > 0) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n7] = (byte)(n12 >> 4);
                }
                return;
            }
            case 2: {
                int n14 = n2 * this.bytesPerLine + (n >> 2);
                int n15 = this.data[n14] & 0xFF;
                while (n6 > 0) {
                    int n16 = 3 - n8 % 4;
                    n5 = 3 << n16 * 2;
                    byArray[n7] = (byte)((n15 & n5) >> n16 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n14 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n15 = this.data[n14] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n16 != 0) continue;
                    n15 = this.data[++n14] & 0xFF;
                }
                return;
            }
            case 1: {
                int n17 = n2 * this.bytesPerLine + (n >> 3);
                int n18 = this.data[n17] & 0xFF;
                while (n6 > 0) {
                    n5 = 1 << 7 - (n8 & 7);
                    byArray[n7] = (n18 & n5) == 0 ? (byte)0 : 1;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n17 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n18 = this.data[n17] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n5 != 1) continue;
                    ++n17;
                    if (n6 <= 0) continue;
                    n18 = this.data[n17] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public final void getPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        switch (this.depth) {
            case 32: {
                int n9 = n2 * this.bytesPerLine + n * 4;
                n6 = n4;
                int n10 = 0;
                while (n10 < n3) {
                    nArray[n6] = (this.data[n9] & 0xFF) << 24 | (this.data[n9 + 1] & 0xFF) << 16 | (this.data[n9 + 2] & 0xFF) << 8 | this.data[n9 + 3] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n9 += 4;
                    }
                    ++n10;
                }
                return;
            }
            case 24: {
                int n11 = n2 * this.bytesPerLine + n * 3;
                int n12 = 0;
                while (n12 < n3) {
                    nArray[n6] = (this.data[n11] & 0xFF) << 16 | (this.data[n11 + 1] & 0xFF) << 8 | this.data[n11 + 2] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n11 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n11 += 3;
                    }
                    ++n12;
                }
                return;
            }
            case 16: {
                int n13 = n2 * this.bytesPerLine + n * 2;
                int n14 = 0;
                while (n14 < n3) {
                    nArray[n6] = ((this.data[n13 + 1] & 0xFF) << 8) + (this.data[n13] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n13 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n13 += 2;
                    }
                    ++n14;
                }
                return;
            }
            case 8: {
                int n15 = n2 * this.bytesPerLine + n;
                int n16 = 0;
                while (n16 < n3) {
                    nArray[n6] = this.data[n15] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n15 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        ++n15;
                    }
                    ++n16;
                }
                return;
            }
            case 4: {
                int n17;
                int n18 = n2 * this.bytesPerLine + (n >> 1);
                if ((n & 1) == 1) {
                    n17 = this.data[n18] & 0xFF;
                    nArray[n6] = n17 & 0xF;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n18 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        ++n18;
                    }
                }
                while (n5 > 1) {
                    n17 = this.data[n18] & 0xFF;
                    nArray[n6] = n17 >> 4;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n18 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    nArray[n6] = n17 & 0xF;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n18 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    ++n18;
                }
                if (n5 > 0) {
                    n17 = this.data[n18] & 0xFF;
                    nArray[n6] = n17 >> 4;
                }
                return;
            }
            case 2: {
                int n19 = n2 * this.bytesPerLine + (n >> 2);
                int n20 = this.data[n19] & 0xFF;
                while (n5 > 0) {
                    int n21 = 3 - n7 % 4;
                    int n22 = 3 << n21 * 2;
                    nArray[n6] = (byte)((n20 & n22) >> n21 * 2);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n19 = ++n8 * this.bytesPerLine;
                        if (n5 > 0) {
                            n20 = this.data[n19] & 0xFF;
                        }
                        n7 = 0;
                        continue;
                    }
                    if (n21 != 0) continue;
                    n20 = this.data[++n19] & 0xFF;
                }
                return;
            }
            case 1: {
                int n23 = n2 * this.bytesPerLine + (n >> 3);
                int n24 = this.data[n23] & 0xFF;
                while (n5 > 0) {
                    int n25 = 1 << 7 - (n7 & 7);
                    nArray[n6] = (n24 & n25) == 0 ? 0 : 1;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n23 = ++n8 * this.bytesPerLine;
                        if (n5 > 0) {
                            n24 = this.data[n23] & 0xFF;
                        }
                        n7 = 0;
                        continue;
                    }
                    if (n25 != 1) continue;
                    ++n23;
                    if (n5 <= 0) continue;
                    n24 = this.data[n23] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public final RGB[] getRGBs() {
        return this.palette.getRGBs();
    }

    public final ImageData getTransparencyMask() {
        if (this.getTransparencyType() == 2) {
            return new ImageData(this.width, this.height, 1, ImageData.bwPalette(), this.maskPad, this.maskData);
        }
        return this.colorMaskImage(this.transparentPixel);
    }

    public final int getTransparencyType() {
        if (this.maskData != null) {
            return 2;
        }
        if (this.transparentPixel != -1) {
            return 4;
        }
        if (this.alphaData != null) {
            return 1;
        }
        return 0;
    }

    final int getByteOrder() {
        int n = 0;
        if (this.depth != 16) {
            n = 1;
        }
        return n;
    }

    public final ImageData scaledTo(int n, int n2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        if (n < 0) {
            bl3 = true;
        }
        if (bl2 = bl3) {
            n = -n;
        }
        boolean bl4 = false;
        if (n2 < 0) {
            bl4 = true;
        }
        if (bl = bl4) {
            n2 = -n2;
        }
        ImageData imageData = new ImageData(n, n2, this.depth, this.palette, this.scanlinePad, null, 0, null, null, -1, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
        if (this.palette.isDirect) {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, 0, 0, 0, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, 0, 0, 0, bl2, bl);
        } else {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        }
        if (this.maskData != null) {
            imageData.maskPad = this.maskPad;
            int n3 = (imageData.width + 7) / 8;
            n3 = (n3 + (imageData.maskPad - 1)) / imageData.maskPad * imageData.maskPad;
            imageData.maskData = new byte[n3 * imageData.height];
            int n4 = (this.width + 7) / 8;
            n4 = (n4 + (this.maskPad - 1)) / this.maskPad * this.maskPad;
            ImageData.blit(1, this.maskData, 1, n4, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.maskData, 1, n3, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        } else if (this.alpha != -1) {
            imageData.alpha = this.alpha;
        } else if (this.alphaData != null) {
            imageData.alphaData = new byte[imageData.width * imageData.height];
            ImageData.blit(1, this.alphaData, 8, this.width, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.alphaData, 8, imageData.width, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        }
        return imageData;
    }

    public final void setAlpha(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0 || n3 < 0 || n3 > 255) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        this.alphaData[n2 * this.width + n] = (byte)n3;
    }

    public final void setAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        System.arraycopy(byArray, n4, this.alphaData, n2 * this.width + n, n3);
    }

    public final void setPixel(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n4 = n2 * this.bytesPerLine + n * 4;
                this.data[n4] = (byte)(n3 >> 24 & 0xFF);
                this.data[n4 + 1] = (byte)(n3 >> 16 & 0xFF);
                this.data[n4 + 2] = (byte)(n3 >> 8 & 0xFF);
                this.data[n4 + 3] = (byte)(n3 & 0xFF);
                return;
            }
            case 24: {
                int n5 = n2 * this.bytesPerLine + n * 3;
                this.data[n5] = (byte)(n3 >> 16 & 0xFF);
                this.data[n5 + 1] = (byte)(n3 >> 8 & 0xFF);
                this.data[n5 + 2] = (byte)(n3 & 0xFF);
                return;
            }
            case 16: {
                int n6 = n2 * this.bytesPerLine + n * 2;
                this.data[n6 + 1] = (byte)(n3 >> 8 & 0xFF);
                this.data[n6] = (byte)(n3 & 0xFF);
                return;
            }
            case 8: {
                int n7 = n2 * this.bytesPerLine + n;
                this.data[n7] = (byte)(n3 & 0xFF);
                return;
            }
            case 4: {
                int n8 = n2 * this.bytesPerLine + (n >> 1);
                this.data[n8] = (n & 1) == 0 ? (byte)(this.data[n8] & 0xF | (n3 & 0xF) << 4) : (byte)(this.data[n8] & 0xF0 | n3 & 0xF);
                return;
            }
            case 2: {
                int n9 = n2 * this.bytesPerLine + (n >> 2);
                byte by = this.data[n9];
                int n10 = 3 - n % 4;
                int n11 = 0xFF ^ 3 << n10 * 2;
                this.data[n9] = (byte)(this.data[n9] & n11 | n3 << n10 * 2);
                return;
            }
            case 1: {
                int n12 = n2 * this.bytesPerLine + (n >> 3);
                byte by = this.data[n12];
                int n13 = 1 << 7 - (n & 7);
                this.data[n12] = (n3 & 1) == 1 ? (byte)(by | n13) : (byte)(by & ~n13);
                return;
            }
        }
        SWT.error(38);
    }

    public final void setPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        switch (this.depth) {
            case 8: {
                int n9 = n2 * this.bytesPerLine + n;
                int n10 = 0;
                while (n10 < n3) {
                    this.data[n9] = (byte)(byArray[n6] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        ++n9;
                    }
                    ++n10;
                }
                return;
            }
            case 4: {
                int n11 = n2 * this.bytesPerLine + (n >> 1);
                boolean bl = false;
                if ((n & 1) == 0) {
                    bl = true;
                }
                boolean bl2 = bl;
                while (n5 > 0) {
                    int n12 = byArray[n6] & 0xF;
                    this.data[n11] = bl2 ? (byte)(this.data[n11] & 0xF | n12 << 4) : (byte)(this.data[n11] & 0xF0 | n12);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n11 = ++n8 * this.bytesPerLine;
                        bl2 = true;
                        n7 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n11;
                    }
                    bl2 ^= true;
                }
                return;
            }
            case 2: {
                byte[] byArray2 = new byte[]{-4, -13, -49, 63};
                int n13 = n2 * this.bytesPerLine + (n >> 2);
                int n14 = 3 - n % 4;
                while (n5 > 0) {
                    int n15 = byArray[n6] & 3;
                    this.data[n13] = (byte)(this.data[n13] & byArray2[n14] | n15 << n14 * 2);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n13 = ++n8 * this.bytesPerLine;
                        n14 = 0;
                        n7 = 0;
                        continue;
                    }
                    if (n14 == 0) {
                        ++n13;
                        n14 = 3;
                        continue;
                    }
                    --n14;
                }
                return;
            }
            case 1: {
                int n16 = n2 * this.bytesPerLine + (n >> 3);
                while (n5 > 0) {
                    int n17 = 1 << 7 - (n7 & 7);
                    this.data[n16] = (byArray[n6] & 1) == 1 ? (byte)(this.data[n16] & 0xFF | n17) : (byte)(this.data[n16] & 0xFF & ~n17);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n16 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    if (n17 != 1) continue;
                    ++n16;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public final void setPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        switch (this.depth) {
            case 32: {
                int n9 = n2 * this.bytesPerLine + n * 4;
                int n10 = 0;
                while (n10 < n3) {
                    int n11 = nArray[n6];
                    this.data[n9] = (byte)(n11 >> 24 & 0xFF);
                    this.data[n9 + 1] = (byte)(n11 >> 16 & 0xFF);
                    this.data[n9 + 2] = (byte)(n11 >> 8 & 0xFF);
                    this.data[n9 + 3] = (byte)(n11 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n9 += 4;
                    }
                    ++n10;
                }
                return;
            }
            case 24: {
                int n12 = n2 * this.bytesPerLine + n * 3;
                int n13 = 0;
                while (n13 < n3) {
                    int n14 = nArray[n6];
                    this.data[n12] = (byte)(n14 >> 16 & 0xFF);
                    this.data[n12 + 1] = (byte)(n14 >> 8 & 0xFF);
                    this.data[n12 + 2] = (byte)(n14 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n12 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n12 += 3;
                    }
                    ++n13;
                }
                return;
            }
            case 16: {
                int n15 = n2 * this.bytesPerLine + n * 2;
                int n16 = 0;
                while (n16 < n3) {
                    int n17 = nArray[n6];
                    this.data[n15] = (byte)(n17 & 0xFF);
                    this.data[n15 + 1] = (byte)(n17 >> 8 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n15 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        n15 += 2;
                    }
                    ++n16;
                }
                return;
            }
            case 8: {
                int n18 = n2 * this.bytesPerLine + n;
                int n19 = 0;
                while (n19 < n3) {
                    this.data[n18] = (byte)(nArray[n6] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n18 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        ++n18;
                    }
                    ++n19;
                }
                return;
            }
            case 4: {
                int n20 = n2 * this.bytesPerLine + (n >> 1);
                boolean bl = false;
                if ((n & 1) == 0) {
                    bl = true;
                }
                boolean bl2 = bl;
                while (n5 > 0) {
                    int n21 = nArray[n6] & 0xF;
                    this.data[n20] = bl2 ? (byte)(this.data[n20] & 0xF | n21 << 4) : (byte)(this.data[n20] & 0xF0 | n21);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n20 = ++n8 * this.bytesPerLine;
                        bl2 = true;
                        n7 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n20;
                    }
                    bl2 ^= true;
                }
                return;
            }
            case 2: {
                byte[] byArray = new byte[]{-4, -13, -49, 63};
                int n22 = n2 * this.bytesPerLine + (n >> 2);
                int n23 = 3 - n % 4;
                while (n5 > 0) {
                    int n24 = nArray[n6] & 3;
                    this.data[n22] = (byte)(this.data[n22] & byArray[n23] | n24 << n23 * 2);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n22 = ++n8 * this.bytesPerLine;
                        n23 = 3;
                        n7 = 0;
                        continue;
                    }
                    if (n23 == 0) {
                        ++n22;
                        n23 = 3;
                        continue;
                    }
                    --n23;
                }
                return;
            }
            case 1: {
                int n25 = n2 * this.bytesPerLine + (n >> 3);
                while (n5 > 0) {
                    int n26 = 1 << 7 - (n7 & 7);
                    this.data[n25] = (nArray[n6] & 1) == 1 ? (byte)(this.data[n25] & 0xFF | n26) : (byte)(this.data[n25] & 0xFF & ~n26);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n25 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    if (n26 != 1) continue;
                    ++n25;
                }
                return;
            }
        }
        SWT.error(38);
    }

    static final PaletteData bwPalette() {
        return new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
    }

    static final int getMSBOffset(int n) {
        int n2 = 31;
        while (n2 >= 0) {
            if ((n >> n2 & 1) != 0) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    static final int closestMatch(int n, byte by, byte by2, byte by3, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (n > 8) {
            int n5 = 32 - ImageData.getMSBOffset(n2);
            int n6 = 32 - ImageData.getMSBOffset(n3);
            int n7 = 32 - ImageData.getMSBOffset(n4);
            return by << 24 >>> n5 & n2 | by2 << 24 >>> n6 & n3 | by3 << 24 >>> n7 & n4;
        }
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        int n10 = byArray.length;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = (byArray[n11] & 0xFF) - (by & 0xFF);
            int n13 = (byArray2[n11] & 0xFF) - (by2 & 0xFF);
            int n14 = (byArray3[n11] & 0xFF) - (by3 & 0xFF);
            int n15 = n12 * n12 + n13 * n13 + n14 * n14;
            if (n15 < n8) {
                n9 = n11;
                if (n15 == 0) break;
                n8 = n15;
            }
            ++n11;
        }
        return n9;
    }

    static final ImageData convertMask(ImageData imageData) {
        if (imageData.depth == 1) {
            return imageData;
        }
        PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
        int n = 0;
        RGB[] rGBArray = imageData.getRGBs();
        if (rGBArray != null) {
            while (n < rGBArray.length) {
                if (rGBArray[n].equals(paletteData.colors[0])) break;
                ++n;
            }
        }
        int[] nArray = new int[imageData.width];
        int n2 = 0;
        while (n2 < imageData.height) {
            imageData.getPixels(0, n2, imageData.width, nArray, 0);
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = nArray[n3] == n ? 0 : 1;
                ++n3;
            }
            imageData2.setPixels(0, n2, imageData.width, nArray, 0);
            ++n2;
        }
        return imageData2;
    }

    static final byte[] convertPad(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return byArray;
        }
        int n6 = (n * n3 + 7) / 8;
        int n7 = (n6 + (n4 - 1)) / n4 * n4;
        int n8 = (n6 + (n5 - 1)) / n5 * n5;
        byte[] byArray2 = new byte[n2 * n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n2) {
            System.arraycopy(byArray, n9, byArray2, n10, n6);
            n9 += n7;
            n10 += n8;
            ++n11;
        }
        return byArray2;
    }

    static final void blit(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray2, int n13, int n14, int n15, byte[] byArray3, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, boolean bl, boolean bl2) {
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        if (n21 <= 0 || n22 <= 0 || n12 == 0) {
            return;
        }
        int n32 = n21 - 1;
        int n33 = 0;
        if (n32 != 0) {
            n33 = (int)((((long)n7 << 16) - 1L) / (long)n32);
        }
        int n34 = n33;
        int n35 = n22 - 1;
        int n36 = 0;
        if (n35 != 0) {
            n36 = (int)((((long)n8 << 16) - 1L) / (long)n35);
        }
        int n37 = n36;
        switch (n2) {
            case 8: {
                n31 = 1;
                n30 = 0;
                break;
            }
            case 16: {
                n31 = 2;
                int n38 = 0;
                if (n4 == 1) {
                    n38 = 1;
                }
                n30 = 2 - n38;
                break;
            }
            case 24: {
                n31 = 3;
                n30 = 3;
                break;
            }
            case 32: {
                n31 = 4;
                int n39 = 0;
                if (n4 == 1) {
                    n39 = 1;
                }
                n30 = 5 - n39;
                break;
            }
            default: {
                return;
            }
        }
        int n40 = n6 * n3 + n5 * n31;
        switch (n16) {
            case 8: {
                n29 = 1;
                n28 = 0;
                break;
            }
            case 16: {
                n29 = 2;
                int n41 = 0;
                if (n18 == 1) {
                    n41 = 1;
                }
                n28 = 2 - n41;
                break;
            }
            case 24: {
                n29 = 3;
                n28 = 3;
                break;
            }
            case 32: {
                n29 = 4;
                int n42 = 0;
                if (n18 == 1) {
                    n42 = 1;
                }
                n28 = 5 - n42;
                break;
            }
            default: {
                return;
            }
        }
        int n43 = (bl2 ? n20 + n35 : n20) * n17 + (bl ? n19 + n32 : n19) * n29;
        int n44 = bl ? -n29 : n29;
        int n45 = n27 = bl2 ? -n17 : n17;
        if ((n & 2) != 0) {
            switch (n12) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = n15 * n13 + n14;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = n15 * (n13 <<= 3) + n14;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = 0;
                    break;
                }
                default: {
                    n12 = (n12 << 16) / 255;
                }
                case -2: {
                    n26 = 0;
                    break;
                }
            }
        } else {
            n12 = 65536;
            n26 = 0;
        }
        int n46 = n43;
        int n47 = n40;
        if (n12 == 65536 && n30 == n28 && n9 == n23 && n10 == n24 && n11 == n25) {
            switch (n31) {
                case 1: {
                    int n48 = n22;
                    int n49 = n37;
                    while (n48 > 0) {
                        int n50 = n21;
                        int n51 = n34;
                        while (n50 > 0) {
                            byArray3[n46] = byArray[n47];
                            n47 += n51 >>> 16;
                            --n50;
                            n46 += n44;
                            n51 = (n51 & (char)-1) + n34;
                        }
                        --n48;
                        n47 = n40 += (n49 >>> 16) * n3;
                        n49 = (n49 & (char)-1) + n37;
                        n46 = n43 += n27;
                    }
                    break;
                }
                case 2: {
                    int n52 = n22;
                    int n53 = n37;
                    while (n52 > 0) {
                        int n54 = n21;
                        int n55 = n34;
                        while (n54 > 0) {
                            byArray3[n46] = byArray[n47];
                            byArray3[n46 + 1] = byArray[n47 + 1];
                            n47 += (n55 >>> 16) * 2;
                            --n54;
                            n46 += n44;
                            n55 = (n55 & (char)-1) + n34;
                        }
                        --n52;
                        n47 = n40 += (n53 >>> 16) * n3;
                        n53 = (n53 & (char)-1) + n37;
                        n46 = n43 += n27;
                    }
                    break;
                }
                case 3: {
                    int n56 = n22;
                    int n57 = n37;
                    while (n56 > 0) {
                        int n58 = n21;
                        int n59 = n34;
                        while (n58 > 0) {
                            byArray3[n46] = byArray[n47];
                            byArray3[n46 + 1] = byArray[n47 + 1];
                            byArray3[n46 + 2] = byArray[n47 + 2];
                            n47 += (n59 >>> 16) * 3;
                            --n58;
                            n46 += n44;
                            n59 = (n59 & (char)-1) + n34;
                        }
                        --n56;
                        n47 = n40 += (n57 >>> 16) * n3;
                        n57 = (n57 & (char)-1) + n37;
                        n46 = n43 += n27;
                    }
                    break;
                }
                case 4: {
                    int n60 = n22;
                    int n61 = n37;
                    while (n60 > 0) {
                        int n62 = n21;
                        int n63 = n34;
                        while (n62 > 0) {
                            byArray3[n46] = byArray[n47];
                            byArray3[n46 + 1] = byArray[n47 + 1];
                            byArray3[n46 + 2] = byArray[n47 + 2];
                            byArray3[n46 + 3] = byArray[n47 + 3];
                            n47 += (n63 >>> 16) * 4;
                            --n62;
                            n46 += n44;
                            n63 = (n63 & (char)-1) + n34;
                        }
                        --n60;
                        n47 = n40 += (n61 >>> 16) * n3;
                        n61 = (n61 & (char)-1) + n37;
                        n46 = n43 += n27;
                    }
                    break;
                }
            }
            return;
        }
        if (n12 == 65536 && n30 == 4 && n28 == 4 && n9 == 65280 && n10 == 0xFF0000 && n11 == -16777216 && n23 == 0xFF0000 && n24 == 65280 && n25 == 255) {
            int n64 = n22;
            int n65 = n37;
            while (n64 > 0) {
                int n66 = n21;
                int n67 = n34;
                while (n66 > 0) {
                    byArray3[n46] = byArray[n47 + 3];
                    byArray3[n46 + 1] = byArray[n47 + 2];
                    byArray3[n46 + 2] = byArray[n47 + 1];
                    byArray3[n46 + 3] = byArray[n47];
                    n47 += (n67 >>> 16) * 4;
                    --n66;
                    n46 += n44;
                    n67 = (n67 & (char)-1) + n34;
                }
                --n64;
                n47 = n40 += (n65 >>> 16) * n3;
                n65 = (n65 & (char)-1) + n37;
                n46 = n43 += n27;
            }
            return;
        }
        if (n12 == 65536 && n30 == 3 && n28 == 4 && n9 == 255 && n10 == 65280 && n11 == 0xFF0000 && n23 == 0xFF0000 && n24 == 65280 && n25 == 255) {
            int n68 = n22;
            int n69 = n37;
            while (n68 > 0) {
                int n70 = n21;
                int n71 = n34;
                while (n70 > 0) {
                    byArray3[n46] = 0;
                    byArray3[n46 + 1] = byArray[n47 + 2];
                    byArray3[n46 + 2] = byArray[n47 + 1];
                    byArray3[n46 + 3] = byArray[n47];
                    n47 += (n71 >>> 16) * 3;
                    --n70;
                    n46 += n44;
                    n71 = (n71 & (char)-1) + n34;
                }
                --n68;
                n47 = n40 += (n69 >>> 16) * n3;
                n69 = (n69 & (char)-1) + n37;
                n46 = n43 += n27;
            }
            return;
        }
        int n72 = ImageData.getChannelShift(n9);
        byte[] byArray4 = ANY_TO_EIGHT[ImageData.getChannelWidth(n9, n72)];
        int n73 = ImageData.getChannelShift(n10);
        byte[] byArray5 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n73)];
        int n74 = ImageData.getChannelShift(n11);
        byte[] byArray6 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n74)];
        int n75 = ImageData.getChannelShift(0);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n75)];
        int n76 = ImageData.getChannelShift(n23);
        int n77 = ImageData.getChannelWidth(n23, n76);
        byte[] byArray8 = ANY_TO_EIGHT[n77];
        int n78 = 8 - n77;
        int n79 = ImageData.getChannelShift(n24);
        int n80 = ImageData.getChannelWidth(n24, n79);
        byte[] byArray9 = ANY_TO_EIGHT[n80];
        int n81 = 8 - n80;
        int n82 = ImageData.getChannelShift(n25);
        int n83 = ImageData.getChannelWidth(n25, n82);
        byte[] byArray10 = ANY_TO_EIGHT[n83];
        int n84 = 8 - n83;
        int n85 = ImageData.getChannelShift(0);
        int n86 = ImageData.getChannelWidth(0, n85);
        byte[] byArray11 = ANY_TO_EIGHT[n86];
        int n87 = 8 - n86;
        int n88 = n26;
        int n89 = n12;
        int n90 = 0;
        int n91 = 0;
        int n92 = 0;
        int n93 = 0;
        int n94 = 0;
        int n95 = 0;
        int n96 = 0;
        int n97 = 0;
        int n98 = n22;
        int n99 = n37;
        while (n98 > 0) {
            int n100 = n21;
            int n101 = n34;
            while (n100 > 0) {
                block91: {
                    int n102;
                    block90: {
                        switch (n30) {
                            case 0: {
                                n102 = byArray[n47] & 0xFF;
                                n47 += n101 >>> 16;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                            case 1: {
                                n102 = (byArray[n47] & 0xFF) << 8 | byArray[n47 + 1] & 0xFF;
                                n47 += (n101 >>> 16) * 2;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                            case 2: {
                                n102 = (byArray[n47 + 1] & 0xFF) << 8 | byArray[n47] & 0xFF;
                                n47 += (n101 >>> 16) * 2;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                            case 3: {
                                n102 = ((byArray[n47] & 0xFF) << 8 | byArray[n47 + 1] & 0xFF) << 8 | byArray[n47 + 2] & 0xFF;
                                n47 += (n101 >>> 16) * 3;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                            case 4: {
                                n102 = (((byArray[n47] & 0xFF) << 8 | byArray[n47 + 1] & 0xFF) << 8 | byArray[n47 + 2] & 0xFF) << 8 | byArray[n47 + 3] & 0xFF;
                                n47 += (n101 >>> 16) * 4;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                            case 5: {
                                n102 = (((byArray[n47 + 3] & 0xFF) << 8 | byArray[n47 + 2] & 0xFF) << 8 | byArray[n47 + 1] & 0xFF) << 8 | byArray[n47] & 0xFF;
                                n47 += (n101 >>> 16) * 4;
                                n90 = byArray4[(n102 & n9) >>> n72] & 0xFF;
                                n91 = byArray5[(n102 & n10) >>> n73] & 0xFF;
                                n92 = byArray6[(n102 & n11) >>> n74] & 0xFF;
                                n93 = byArray7[0 >>> n75] & 0xFF;
                                break;
                            }
                        }
                        block33 : switch (n12) {
                            case -1: {
                                n89 = ((byArray2[n88] & 0xFF) << 16) / 255;
                                n88 += n101 >> 16;
                                break;
                            }
                            case -2: {
                                n89 = (n93 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n89 = byArray2[n88] != 0 ? 65536 : 0;
                                n88 += n101 >> 16;
                                break;
                            }
                            case -4: {
                                n89 = byArray2[n88 >> 3] << (n88 & 7) + 9 & 0x10000;
                                n88 += n101 >> 16;
                                break;
                            }
                            case -6: {
                                n89 = 65536;
                                n102 = 0;
                                while (n102 < byArray2.length) {
                                    if (n90 == byArray2[n102] && n91 == byArray2[n102 + 1] && n92 == byArray2[n102 + 2]) {
                                        n89 = 0;
                                        break block33;
                                    }
                                    n102 += 3;
                                }
                                break;
                            }
                        }
                        if (n89 == 65536) break block90;
                        if (n89 == 0) break block91;
                        switch (n28) {
                            case 0: {
                                n102 = byArray3[n46] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                            case 1: {
                                n102 = (byArray3[n46] & 0xFF) << 8 | byArray3[n46 + 1] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                            case 2: {
                                n102 = (byArray3[n46 + 1] & 0xFF) << 8 | byArray3[n46] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                            case 3: {
                                n102 = ((byArray3[n46] & 0xFF) << 8 | byArray3[n46 + 1] & 0xFF) << 8 | byArray3[n46 + 2] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                            case 4: {
                                n102 = (((byArray3[n46] & 0xFF) << 8 | byArray3[n46 + 1] & 0xFF) << 8 | byArray3[n46 + 2] & 0xFF) << 8 | byArray3[n46 + 3] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                            case 5: {
                                n102 = (((byArray3[n46 + 3] & 0xFF) << 8 | byArray3[n46 + 2] & 0xFF) << 8 | byArray3[n46 + 1] & 0xFF) << 8 | byArray3[n46] & 0xFF;
                                n94 = byArray8[(n102 & n23) >>> n76] & 0xFF;
                                n95 = byArray9[(n102 & n24) >>> n79] & 0xFF;
                                n96 = byArray10[(n102 & n25) >>> n82] & 0xFF;
                                n97 = byArray11[0 >>> n85] & 0xFF;
                                break;
                            }
                        }
                        n93 = n97 + ((n93 - n97) * n89 >> 16);
                        n90 = n94 + ((n90 - n94) * n89 >> 16);
                        n91 = n95 + ((n91 - n95) * n89 >> 16);
                        n92 = n96 + ((n92 - n96) * n89 >> 16);
                    }
                    n102 = n90 >>> n78 << n76 | n91 >>> n81 << n79 | n92 >>> n84 << n82 | n93 >>> n87 << n85;
                    switch (n28) {
                        case 0: {
                            byArray3[n46] = (byte)n102;
                            break;
                        }
                        case 1: {
                            byArray3[n46] = (byte)(n102 >>> 8);
                            byArray3[n46 + 1] = (byte)(n102 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray3[n46] = (byte)(n102 & 0xFF);
                            byArray3[n46 + 1] = (byte)(n102 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray3[n46] = (byte)(n102 >>> 16);
                            byArray3[n46 + 1] = (byte)(n102 >>> 8);
                            byArray3[n46 + 2] = (byte)(n102 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray3[n46] = (byte)(n102 >>> 24);
                            byArray3[n46 + 1] = (byte)(n102 >>> 16);
                            byArray3[n46 + 2] = (byte)(n102 >>> 8);
                            byArray3[n46 + 3] = (byte)(n102 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray3[n46] = (byte)(n102 & 0xFF);
                            byArray3[n46 + 1] = (byte)(n102 >>> 8);
                            byArray3[n46 + 2] = (byte)(n102 >>> 16);
                            byArray3[n46 + 3] = (byte)(n102 >>> 24);
                            break;
                        }
                    }
                }
                --n100;
                n46 += n44;
                n101 = (n101 & (char)-1) + n34;
            }
            --n98;
            n47 = n40 += (n99 >>> 16) * n3;
            n88 = n26 += (n99 >>> 16) * n13;
            n99 = (n99 & (char)-1) + n37;
            n46 = n43 += n27;
        }
    }

    /*
     * Unable to fully structure code
     */
    static final void blit(int var0, byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, byte[] var9_9, byte[] var10_10, byte[] var11_11, int var12_12, byte[] var13_13, int var14_14, int var15_15, int var16_16, byte[] var17_17, int var18_18, int var19_19, int var20_20, int var21_21, int var22_22, int var23_23, int var24_24, byte[] var25_25, byte[] var26_26, byte[] var27_27, boolean var28_28, boolean var29_29) {
        block140: {
            block142: {
                block141: {
                    if (var23_23 <= 0 || var24_24 <= 0 || var12_12 == 0) {
                        return;
                    }
                    var30_30 = var23_23 - 1;
                    v0 = 0;
                    if (var30_30 != 0) {
                        v0 = (int)((((long)var7_7 << 16) - 1L) / (long)var30_30);
                    }
                    var31_31 = v0;
                    var32_32 = var24_24 - 1;
                    v1 = 0;
                    if (var32_32 != 0) {
                        v1 = (int)((((long)var8_8 << 16) - 1L) / (long)var32_32);
                    }
                    var33_33 = v1;
                    switch (var2_2) {
                        case 8: {
                            var34_34 = 6;
                            break;
                        }
                        case 4: {
                            var3_3 <<= 1;
                            var34_34 = 7;
                            break;
                        }
                        case 2: {
                            var3_3 <<= 2;
                            var34_34 = 8;
                            break;
                        }
                        case 1: {
                            var3_3 <<= 3;
                            v2 = 0;
                            if (var4_4 == 1) {
                                v2 = 1;
                            }
                            var34_34 = 10 - v2;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var35_35 = var6_6 * var3_3 + var5_5;
                    switch (var18_18) {
                        case 8: {
                            var36_36 = 6;
                            break;
                        }
                        case 4: {
                            var19_19 <<= 1;
                            var36_36 = 7;
                            break;
                        }
                        case 2: {
                            var19_19 <<= 2;
                            var36_36 = 8;
                            break;
                        }
                        case 1: {
                            var19_19 <<= 3;
                            v3 = 0;
                            if (var20_20 == 1) {
                                v3 = 1;
                            }
                            var36_36 = 10 - v3;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var37_37 = (var29_29 != false ? var22_22 + var32_32 : var22_22) * var19_19 + (var28_28 != false ? var21_21 + var30_30 : var21_21);
                    var38_38 = var28_28 != false ? -1 : 1;
                    v4 = var39_39 = var29_29 != false ? -var19_19 : var19_19;
                    if ((var0 & 2) != 0) {
                        switch (var12_12) {
                            case -3: 
                            case -1: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * var14_14 + var15_15;
                                break;
                            }
                            case -4: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * (var14_14 <<= 3) + var15_15;
                                break;
                            }
                            case -6: 
                            case -5: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = 0;
                                break;
                            }
                            default: {
                                var12_12 = (var12_12 << 16) / 255;
                            }
                            case -2: {
                                var40_40 = 0;
                                break;
                            }
                        }
                    } else {
                        var12_12 = 65536;
                        var40_40 = 0;
                    }
                    v5 = false;
                    if ((var0 & 4) != 0) {
                        v5 = true;
                    }
                    var41_41 = v5;
                    var42_42 = var37_37;
                    var43_43 = var35_35;
                    var44_44 = var40_40;
                    var45_45 = 1 << var18_18;
                    if (var25_25 != null && var25_25.length < var45_45) {
                        var45_45 = var25_25.length;
                    }
                    var46_46 = null;
                    var47_47 = true;
                    switch (var12_12) {
                        case 65536: {
                            if (var34_34 == var36_36 && var9_9 == var25_25 && var10_10 == var26_26 && var11_11 == var27_27) {
                                var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                break;
                            }
                            if (var9_9 == null || var25_25 == null) {
                                if (var2_2 <= var18_18) {
                                    var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                    break;
                                }
                                var46_46 = new byte[1 << var2_2];
                                var48_48 = 255 << var18_18 >>> 8;
                                var49_49 = 0;
                                while (var49_49 < var46_46.length) {
                                    var46_46[var49_49] = (byte)(var49_49 & var48_48);
                                    ++var49_49;
                                }
                                break;
                            }
                        }
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            var48_48 = 1 << var2_2;
                            var46_46 = new byte[var48_48];
                            if (var9_9 != null && var9_9.length < var48_48) {
                                var48_48 = var9_9.length;
                            }
                            var49_49 = 0;
                            while (var49_49 < var48_48) {
                                var50_50 = var9_9[var49_49] & 255;
                                var51_51 = var10_10[var49_49] & 255;
                                var52_52 = var11_11[var49_49] & 255;
                                var53_53 = 0;
                                var54_54 = 0x7FFFFFFF;
                                var55_55 = 0;
                                while (var55_55 < var45_45) {
                                    var56_57 = (var25_25[var55_55] & 255) - var50_50;
                                    var57_59 = (var26_26[var55_55] & 255) - var51_51;
                                    var58_61 = (var27_27[var55_55] & 255) - var52_52;
                                    var59_62 = var56_57 * var56_57 + var57_59 * var57_59 + var58_61 * var58_61;
                                    if (var59_62 < var54_54) {
                                        var53_53 = var55_55;
                                        if (var59_62 == 0) break;
                                        var54_54 = var59_62;
                                    }
                                    ++var55_55;
                                }
                                var46_46[var49_49] = (byte)var53_53;
                                if (var54_54 != 0) {
                                    var47_47 = false;
                                }
                                ++var49_49;
                            }
                            break;
                        }
                    }
                    if (var46_46 == null || !var47_47 && var41_41) break block140;
                    if (var34_34 != var36_36 || var12_12 != 65536) break block141;
                    switch (var34_34) {
                        case 6: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var17_17[var42_42] = var46_46[var1_1[var43_43] & 255];
                                    var43_43 += var51_51 >>> 16;
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & (char)-1) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & (char)-1) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block142;
                        }
                        case 7: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = (var43_43 & 1) != 0 ? var46_46[var1_1[var43_43 >> 1] & 15] : var1_1[var43_43 >> 1] >>> 4 & 15;
                                    var43_43 += var51_51 >>> 16;
                                    var17_17[var42_42 >> 1] = (var42_42 & 1) != 0 ? (byte)(var17_17[var42_42 >> 1] & 240 | var52_52) : (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & (char)-1) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & (char)-1) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block142;
                        }
                        case 8: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 6 - (var42_42 & 3) * 2;
                                    var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & (char)-1) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & (char)-1) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block142;
                        }
                        case 9: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 7 - (var42_42 & 7);
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & (char)-1) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & (char)-1) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block142;
                        }
                        case 10: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = var42_42 & 7;
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & (char)-1) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & (char)-1) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block142;
                        }
                    }
                    break block142;
                }
                var48_48 = var24_24;
                var49_49 = var33_33;
                while (var48_48 > 0) {
                    var50_50 = var23_23;
                    var51_51 = var31_31;
                    while (var50_50 > 0) {
                        switch (var34_34) {
                            case 6: {
                                var52_52 = var1_1[var43_43] & 255;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 7: {
                                var52_52 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 8: {
                                var52_52 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 9: {
                                var52_52 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 10: {
                                var52_52 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        block36 : switch (var12_12) {
                            case -3: {
                                var53_53 = var13_13[var44_44];
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl310
                            }
                            case -4: {
                                var53_53 = var13_13[var44_44 >> 3] & 1 << (var44_44 & 7);
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl310
                            }
                            case -5: {
                                var53_53 = 0;
                                while (var53_53 < var13_13.length) {
                                    if (var52_52 == (var13_13[var53_53] & 255)) break;
                                }
                                if (var53_53 < var13_13.length) {
                                    break;
                                }
                                ** GOTO lbl310
                            }
                            case -6: {
                                var53_53 = var9_9[var52_52];
                                var54_54 = var10_10[var52_52];
                                var55_55 = var11_11[var52_52];
                                var56_57 = 0;
                                while (var56_57 < var13_13.length) {
                                    if (var53_53 == var13_13[var56_57] && var54_54 == var13_13[var56_57 + 1] && var55_55 == var13_13[var56_57 + 2]) break;
                                    var56_57 += 3;
                                }
                                if (var56_57 < var13_13.length) break;
                            }
lbl310:
                            // 5 sources

                            default: {
                                var52_52 = var46_46[var52_52] & 255;
                                switch (var36_36) {
                                    case 6: {
                                        var17_17[var42_42] = (byte)var52_52;
                                        break block36;
                                    }
                                    case 7: {
                                        if ((var42_42 & 1) != 0) {
                                            var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var52_52);
                                            break block36;
                                        }
                                        var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                        break block36;
                                    }
                                    case 8: {
                                        var53_53 = 6 - (var42_42 & 3) * 2;
                                        var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 9: {
                                        var53_53 = 7 - (var42_42 & 7);
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 10: {
                                        var53_53 = var42_42 & 7;
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                }
                            }
                        }
                        --var50_50;
                        var42_42 += var38_38;
                        var51_51 = (var51_51 & (char)-1) + var31_31;
                    }
                    --var48_48;
                    var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                    var49_49 = (var49_49 & (char)-1) + var33_33;
                    var42_42 = var37_37 += var39_39;
                }
            }
            return;
        }
        var48_48 = var12_12;
        var49_49 = 0;
        var50_50 = 0;
        var51_51 = 0;
        var52_52 = -1;
        var53_53 = -1;
        var54_54 = -1;
        if (var41_41) {
            var55_56 = new int[var23_23 + 2];
            var56_58 = new int[var23_23 + 2];
            var57_60 = new int[var23_23 + 2];
        } else {
            var55_56 = null;
            var56_58 = null;
            var57_60 = null;
        }
        var58_61 = var24_24;
        var59_62 = var33_33;
        while (var58_61 > 0) {
            var60_63 = 0;
            var61_64 = 0;
            var62_65 = 0;
            var63_66 = var23_23;
            var64_67 = var31_31;
            while (var63_66 > 0) {
                switch (var34_34) {
                    case 6: {
                        var49_49 = var1_1[var43_43] & 255;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 7: {
                        var49_49 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 8: {
                        var49_49 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 9: {
                        var49_49 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 10: {
                        var49_49 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                }
                var65_68 = var9_9[var49_49] & 255;
                var66_69 = var10_10[var49_49] & 255;
                var67_70 = var11_11[var49_49] & 255;
                block56 : switch (var12_12) {
                    case -1: {
                        var48_48 = ((var13_13[var44_44] & 255) << 16) / 255;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl422
                    }
                    case -3: {
                        var48_48 = var13_13[var44_44] != 0 ? 65536 : 0;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl422
                    }
                    case -4: {
                        var48_48 = var13_13[var44_44 >> 3] << (var44_44 & 7) + 9 & 65536;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl422
                    }
                    case -5: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var49_49 == (var13_13[var68_71] & 255)) break;
                        }
                        if (var68_71 < var13_13.length) {
                            break;
                        }
                        ** GOTO lbl422
                    }
                    case -6: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var65_68 == (var13_13[var68_71] & 255) && var66_69 == (var13_13[var68_71 + 1] & 255) && var67_70 == (var13_13[var68_71 + 2] & 255)) break;
                            var68_71 += 3;
                        }
                        if (var68_71 < var13_13.length) break;
                    }
lbl422:
                    // 6 sources

                    default: {
                        if (var48_48 != 65536) {
                            if (var48_48 == 0) break;
                            switch (var36_36) {
                                case 6: {
                                    var50_50 = var17_17[var42_42] & 255;
                                    break;
                                }
                                case 7: {
                                    if ((var42_42 & 1) != 0) {
                                        var50_50 = var17_17[var42_42 >> 1] & 15;
                                        break;
                                    }
                                    var50_50 = var17_17[var42_42 >> 1] >>> 4 & 15;
                                    break;
                                }
                                case 8: {
                                    var50_50 = var17_17[var42_42 >> 2] >>> 6 - (var42_42 & 3) * 2 & 3;
                                    break;
                                }
                                case 9: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> 7 - (var42_42 & 7) & 1;
                                    break;
                                }
                                case 10: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> (var42_42 & 7) & 1;
                                    break;
                                }
                            }
                            var68_71 = var25_25[var50_50] & 255;
                            var69_72 = var26_26[var50_50] & 255;
                            var70_73 = var27_27[var50_50] & 255;
                            var65_68 = var68_71 + ((var65_68 - var68_71) * var48_48 >> 16);
                            var66_69 = var69_72 + ((var66_69 - var69_72) * var48_48 >> 16);
                            var67_70 = var70_73 + ((var67_70 - var70_73) * var48_48 >> 16);
                        }
                        if (var41_41) {
                            if ((var65_68 += var55_56[var63_66] >> 4) < 0) {
                                var65_68 = 0;
                            } else if (var65_68 > 255) {
                                var65_68 = 255;
                            }
                            if ((var66_69 += var56_58[var63_66] >> 4) < 0) {
                                var66_69 = 0;
                            } else if (var66_69 > 255) {
                                var66_69 = 255;
                            }
                            if ((var67_70 += var57_60[var63_66] >> 4) < 0) {
                                var67_70 = 0;
                            } else if (var67_70 > 255) {
                                var67_70 = 255;
                            }
                            var55_56[var63_66] = var60_63;
                            var56_58[var63_66] = var61_64;
                            var57_60[var63_66] = var62_65;
                        }
                        if (var65_68 != var52_52 || var66_69 != var53_53 || var67_70 != var54_54) {
                            var68_71 = 0;
                            var73_76 = 0x7FFFFFFF;
                            while (var68_71 < var45_45) {
                                var69_72 = (var25_25[var68_71] & 255) - var65_68;
                                var70_73 = (var26_26[var68_71] & 255) - var66_69;
                                var71_74 = (var27_27[var68_71] & 255) - var67_70;
                                var72_75 = var69_72 * var69_72 + var70_73 * var70_73 + var71_74 * var71_74;
                                if (var72_75 < var73_76) {
                                    var51_51 = var68_71;
                                    if (var72_75 == 0) break;
                                    var73_76 = var72_75;
                                }
                                ++var68_71;
                            }
                            var52_52 = var65_68;
                            var53_53 = var66_69;
                            var54_54 = var67_70;
                        }
                        if (var41_41) {
                            var68_71 = var63_66 - 1;
                            v6 = var69_72 = var63_66 + 1;
                            var60_63 = var65_68 - (var25_25[var51_51] & 255);
                            var70_73 = var60_63 + var60_63 + var60_63;
                            var55_56[v6] = var55_56[v6] + var70_73;
                            v7 = var63_66;
                            var55_56[v7] = var55_56[v7] + (var70_73 += var60_63 + var60_63);
                            v8 = var68_71;
                            var55_56[v8] = var55_56[v8] + (var70_73 + var60_63 + var60_63);
                            v9 = var69_72;
                            var61_64 = var66_69 - (var26_26[var51_51] & 255);
                            var70_73 = var61_64 + var61_64 + var61_64;
                            var56_58[v9] = var56_58[v9] + var70_73;
                            v10 = var63_66;
                            var56_58[v10] = var56_58[v10] + (var70_73 += var61_64 + var61_64);
                            v11 = var68_71;
                            var56_58[v11] = var56_58[v11] + (var70_73 + var61_64 + var61_64);
                            v12 = var69_72;
                            var62_65 = var67_70 - (var27_27[var51_51] & 255);
                            var70_73 = var62_65 + var62_65 + var62_65;
                            var57_60[v12] = var57_60[v12] + var70_73;
                            v13 = var63_66;
                            var57_60[v13] = var57_60[v13] + (var70_73 += var62_65 + var62_65);
                            v14 = var68_71;
                            var57_60[v14] = var57_60[v14] + (var70_73 + var62_65 + var62_65);
                        }
                        switch (var36_36) {
                            case 6: {
                                var17_17[var42_42] = (byte)var51_51;
                                break block56;
                            }
                            case 7: {
                                if ((var42_42 & 1) != 0) {
                                    var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var51_51);
                                    break block56;
                                }
                                var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var51_51 << 4);
                                break block56;
                            }
                            case 8: {
                                var68_71 = 6 - (var42_42 & 3) * 2;
                                var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 9: {
                                var68_71 = 7 - (var42_42 & 7);
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 10: {
                                var68_71 = var42_42 & 7;
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                        }
                    }
                }
                --var63_66;
                var42_42 += var38_38;
                var64_67 = (var64_67 & (char)-1) + var31_31;
            }
            --var58_61;
            var43_43 = var35_35 += (var59_62 >>> 16) * var3_3;
            var44_44 = var40_40 += (var59_62 >>> 16) * var14_14;
            var59_62 = (var59_62 & (char)-1) + var33_33;
            var42_42 = var37_37 += var39_39;
        }
    }

    /*
     * Unable to fully structure code
     */
    static final void blit(int var0, byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, byte[] var9_9, byte[] var10_10, byte[] var11_11, int var12_12, byte[] var13_13, int var14_14, int var15_15, int var16_16, byte[] var17_17, int var18_18, int var19_19, int var20_20, int var21_21, int var22_22, int var23_23, int var24_24, int var25_25, int var26_26, int var27_27, boolean var28_28, boolean var29_29) {
        if (var23_23 <= 0 || var24_24 <= 0 || var12_12 == 0) {
            return;
        }
        if (var5_5 == 0 && var6_6 == 0 && var21_21 == 0 && var22_22 == 0 && var23_23 == var7_7 && var24_24 == var8_8) {
            if (var18_18 == 24 && var2_2 == 8 && (var0 & 2) == 0 && var25_25 == 0xFF0000 && var26_26 == 65280 && var27_27 == 255) {
                var30_30 = 0;
                var31_32 = 0;
                var32_35 = 0;
                var33_38 = var3_3 - var7_7;
                var34_41 = var19_19 - var23_23 * 3;
                while (var30_30 < var24_24) {
                    var35_44 = 0;
                    while (var35_44 < var23_23) {
                        var36_47 = var1_1[var31_32++] & 255;
                        var17_17[var32_35++] = var9_9[var36_47];
                        var17_17[var32_35++] = var10_10[var36_47];
                        var17_17[var32_35++] = var11_11[var36_47];
                        ++var35_44;
                    }
                    ++var30_30;
                    var31_32 += var33_38;
                    var32_35 += var34_41;
                }
                return;
            }
            if (var18_18 == 32 && var20_20 == 1 && var2_2 == 8 && (var0 & 2) == 0 && var25_25 == 0xFF0000 && var26_26 == 65280 && var27_27 == 255) {
                var30_31 = 0;
                var31_33 = 0;
                var32_36 = 0;
                var33_39 = var3_3 - var7_7;
                var34_42 = var19_19 - var23_23 * 4;
                while (var30_31 < var24_24) {
                    var35_45 = 0;
                    while (var35_45 < var23_23) {
                        var36_48 = var1_1[var31_33++] & 255;
                        v0 = ++var32_36;
                        var17_17[v0] = var9_9[var36_48];
                        v1 = ++var32_36;
                        var17_17[v1] = var10_10[var36_48];
                        v2 = ++var32_36;
                        ++var32_36;
                        var17_17[v2] = var11_11[var36_48];
                        ++var35_45;
                    }
                    ++var30_31;
                    var31_33 += var33_39;
                    var32_36 += var34_42;
                }
                return;
            }
        }
        var31_34 = var23_23 - 1;
        v3 = 0;
        if (var31_34 != 0) {
            v3 = (int)((((long)var7_7 << 16) - 1L) / (long)var31_34);
        }
        var32_37 = v3;
        var33_40 = var24_24 - 1;
        v4 = 0;
        if (var33_40 != 0) {
            v4 = (int)((((long)var8_8 << 16) - 1L) / (long)var33_40);
        }
        var34_43 = v4;
        switch (var2_2) {
            case 8: {
                var35_46 = 6;
                break;
            }
            case 4: {
                var3_3 <<= 1;
                var35_46 = 7;
                break;
            }
            case 2: {
                var3_3 <<= 2;
                var35_46 = 8;
                break;
            }
            case 1: {
                var3_3 <<= 3;
                v5 = 0;
                if (var4_4 == 1) {
                    v5 = 1;
                }
                var35_46 = 10 - v5;
                break;
            }
            default: {
                return;
            }
        }
        var36_49 = var6_6 * var3_3 + var5_5;
        switch (var18_18) {
            case 8: {
                var37_50 = 1;
                var38_51 = 0;
                break;
            }
            case 16: {
                var37_50 = 2;
                v6 = 0;
                if (var20_20 == 1) {
                    v6 = 1;
                }
                var38_51 = 2 - v6;
                break;
            }
            case 24: {
                var37_50 = 3;
                var38_51 = 3;
                break;
            }
            case 32: {
                var37_50 = 4;
                v7 = 0;
                if (var20_20 == 1) {
                    v7 = 1;
                }
                var38_51 = 5 - v7;
                break;
            }
            default: {
                return;
            }
        }
        var39_52 = (var29_29 != false ? var22_22 + var33_40 : var22_22) * var19_19 + (var28_28 != false ? var21_21 + var31_34 : var21_21) * var37_50;
        var40_53 = var28_28 != false ? -var37_50 : var37_50;
        v8 = var41_54 = var29_29 != false ? -var19_19 : var19_19;
        if ((var0 & 2) != 0) {
            switch (var12_12) {
                case -3: 
                case -1: {
                    if (var13_13 == null) {
                        var12_12 = 65536;
                    }
                    var42_55 = var16_16 * var14_14 + var15_15;
                    break;
                }
                case -4: {
                    if (var13_13 == null) {
                        var12_12 = 65536;
                    }
                    var42_55 = var16_16 * (var14_14 <<= 3) + var15_15;
                    break;
                }
                case -6: 
                case -5: {
                    if (var13_13 == null) {
                        var12_12 = 65536;
                    }
                    var42_55 = 0;
                    break;
                }
                default: {
                    var12_12 = (var12_12 << 16) / 255;
                }
                case -2: {
                    var42_55 = 0;
                    break;
                }
            }
        } else {
            var12_12 = 65536;
            var42_55 = 0;
        }
        var43_56 = ImageData.getChannelShift(var25_25);
        var44_57 = ImageData.getChannelWidth(var25_25, var43_56);
        var45_58 = ImageData.ANY_TO_EIGHT[var44_57];
        var46_59 = 8 - var44_57;
        var47_60 = ImageData.getChannelShift(var26_26);
        var48_61 = ImageData.getChannelWidth(var26_26, var47_60);
        var49_62 = ImageData.ANY_TO_EIGHT[var48_61];
        var50_63 = 8 - var48_61;
        var51_64 = ImageData.getChannelShift(var27_27);
        var52_65 = ImageData.getChannelWidth(var27_27, var51_64);
        var53_66 = ImageData.ANY_TO_EIGHT[var52_65];
        var54_67 = 8 - var52_65;
        var55_68 = ImageData.getChannelShift(0);
        var56_69 = ImageData.getChannelWidth(0, var55_68);
        var57_70 = ImageData.ANY_TO_EIGHT[var56_69];
        var58_71 = 8 - var56_69;
        var59_72 = var39_52;
        var60_73 = var36_49;
        var61_74 = var42_55;
        var62_75 = var12_12;
        var63_76 = 0;
        var64_77 = 0;
        var65_78 = 0;
        var66_79 = 0;
        var67_80 = 0;
        var68_81 = 0;
        var69_82 = 0;
        var70_83 = 0;
        var71_84 = 0;
        var72_85 = var24_24;
        var73_86 = var34_43;
        while (var72_85 > 0) {
            var74_87 = var23_23;
            var75_88 = var32_37;
            while (var74_87 > 0) {
                switch (var35_46) {
                    case 6: {
                        var67_80 = var1_1[var60_73] & 255;
                        var60_73 += var75_88 >>> 16;
                        break;
                    }
                    case 7: {
                        var67_80 = (var60_73 & 1) != 0 ? var1_1[var60_73 >> 1] & 15 : var1_1[var60_73 >> 1] >>> 4 & 15;
                        var60_73 += var75_88 >>> 16;
                        break;
                    }
                    case 8: {
                        var67_80 = var1_1[var60_73 >> 2] >>> 6 - (var60_73 & 3) * 2 & 3;
                        var60_73 += var75_88 >>> 16;
                        break;
                    }
                    case 9: {
                        var67_80 = var1_1[var60_73 >> 3] >>> 7 - (var60_73 & 7) & 1;
                        var60_73 += var75_88 >>> 16;
                        break;
                    }
                    case 10: {
                        var67_80 = var1_1[var60_73 >> 3] >>> (var60_73 & 7) & 1;
                        var60_73 += var75_88 >>> 16;
                        break;
                    }
                }
                var63_76 = var9_9[var67_80] & 255;
                var64_77 = var10_10[var67_80] & 255;
                var65_78 = var11_11[var67_80] & 255;
                block25 : switch (var12_12) {
                    case -1: {
                        var62_75 = ((var13_13[var61_74] & 255) << 16) / 255;
                        var61_74 += var75_88 >> 16;
                        ** GOTO lbl220
                    }
                    case -3: {
                        var62_75 = var13_13[var61_74] != 0 ? 65536 : 0;
                        var61_74 += var75_88 >> 16;
                        ** GOTO lbl220
                    }
                    case -4: {
                        var62_75 = var13_13[var61_74 >> 3] << (var61_74 & 7) + 9 & 65536;
                        var61_74 += var75_88 >> 16;
                        ** GOTO lbl220
                    }
                    case -5: {
                        var76_89 = 0;
                        while (var76_89 < var13_13.length) {
                            if (var67_80 == (var13_13[var76_89] & 255)) break;
                        }
                        if (var76_89 < var13_13.length) {
                            break;
                        }
                        ** GOTO lbl220
                    }
                    case -6: {
                        var76_89 = 0;
                        while (var76_89 < var13_13.length) {
                            if (var63_76 == (var13_13[var76_89] & 255) && var64_77 == (var13_13[var76_89 + 1] & 255) && var65_78 == (var13_13[var76_89 + 2] & 255)) break;
                            var76_89 += 3;
                        }
                        if (var76_89 < var13_13.length) break;
                    }
lbl220:
                    // 6 sources

                    default: {
                        if (var62_75 != 65536) {
                            if (var62_75 == 0) break;
                            switch (var38_51) {
                                case 0: {
                                    var76_89 = var17_17[var59_72] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                                case 1: {
                                    var76_89 = (var17_17[var59_72] & 255) << 8 | var17_17[var59_72 + 1] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                                case 2: {
                                    var76_89 = (var17_17[var59_72 + 1] & 255) << 8 | var17_17[var59_72] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                                case 3: {
                                    var76_89 = ((var17_17[var59_72] & 255) << 8 | var17_17[var59_72 + 1] & 255) << 8 | var17_17[var59_72 + 2] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                                case 4: {
                                    var76_89 = (((var17_17[var59_72] & 255) << 8 | var17_17[var59_72 + 1] & 255) << 8 | var17_17[var59_72 + 2] & 255) << 8 | var17_17[var59_72 + 3] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                                case 5: {
                                    var76_89 = (((var17_17[var59_72 + 3] & 255) << 8 | var17_17[var59_72 + 2] & 255) << 8 | var17_17[var59_72 + 1] & 255) << 8 | var17_17[var59_72] & 255;
                                    var68_81 = var45_58[(var76_89 & var25_25) >>> var43_56] & 255;
                                    var69_82 = var49_62[(var76_89 & var26_26) >>> var47_60] & 255;
                                    var70_83 = var53_66[(var76_89 & var27_27) >>> var51_64] & 255;
                                    var71_84 = var57_70[0 >>> var55_68] & 255;
                                    break;
                                }
                            }
                            var66_79 = var71_84 + ((var66_79 - var71_84) * var62_75 >> 16);
                            var63_76 = var68_81 + ((var63_76 - var68_81) * var62_75 >> 16);
                            var64_77 = var69_82 + ((var64_77 - var69_82) * var62_75 >> 16);
                            var65_78 = var70_83 + ((var65_78 - var70_83) * var62_75 >> 16);
                        }
                        var76_89 = var63_76 >>> var46_59 << var43_56 | var64_77 >>> var50_63 << var47_60 | var65_78 >>> var54_67 << var51_64 | var66_79 >>> var58_71 << var55_68;
                        switch (var38_51) {
                            case 0: {
                                var17_17[var59_72] = (byte)var76_89;
                                break block25;
                            }
                            case 1: {
                                var17_17[var59_72] = (byte)(var76_89 >>> 8);
                                var17_17[var59_72 + 1] = (byte)(var76_89 & 255);
                                break block25;
                            }
                            case 2: {
                                var17_17[var59_72] = (byte)(var76_89 & 255);
                                var17_17[var59_72 + 1] = (byte)(var76_89 >>> 8);
                                break block25;
                            }
                            case 3: {
                                var17_17[var59_72] = (byte)(var76_89 >>> 16);
                                var17_17[var59_72 + 1] = (byte)(var76_89 >>> 8);
                                var17_17[var59_72 + 2] = (byte)(var76_89 & 255);
                                break block25;
                            }
                            case 4: {
                                var17_17[var59_72] = (byte)(var76_89 >>> 24);
                                var17_17[var59_72 + 1] = (byte)(var76_89 >>> 16);
                                var17_17[var59_72 + 2] = (byte)(var76_89 >>> 8);
                                var17_17[var59_72 + 3] = (byte)(var76_89 & 255);
                                break block25;
                            }
                            case 5: {
                                var17_17[var59_72] = (byte)(var76_89 & 255);
                                var17_17[var59_72 + 1] = (byte)(var76_89 >>> 8);
                                var17_17[var59_72 + 2] = (byte)(var76_89 >>> 16);
                                var17_17[var59_72 + 3] = (byte)(var76_89 >>> 24);
                                break block25;
                            }
                        }
                    }
                }
                --var74_87;
                var59_72 += var40_53;
                var75_88 = (var75_88 & (char)-1) + var32_37;
            }
            --var72_85;
            var60_73 = var36_49 += (var73_86 >>> 16) * var3_3;
            var61_74 = var42_55 += (var73_86 >>> 16) * var14_14;
            var73_86 = (var73_86 & (char)-1) + var34_43;
            var59_72 = var39_52 += var41_54;
        }
    }

    static final void blit(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray2, int n13, int n14, int n15, byte[] byArray3, int n16, int n17, int n18, int n19, int n20, int n21, int n22, byte[] byArray4, byte[] byArray5, byte[] byArray6, boolean bl, boolean bl2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        if (n21 <= 0 || n22 <= 0 || n12 == 0) {
            return;
        }
        int n28 = n21 - 1;
        int n29 = 0;
        if (n28 != 0) {
            n29 = (int)((((long)n7 << 16) - 1L) / (long)n28);
        }
        int n30 = n29;
        int n31 = n22 - 1;
        int n32 = 0;
        if (n31 != 0) {
            n32 = (int)((((long)n8 << 16) - 1L) / (long)n31);
        }
        int n33 = n32;
        switch (n2) {
            case 8: {
                n27 = 1;
                n26 = 0;
                break;
            }
            case 16: {
                n27 = 2;
                int n34 = 0;
                if (n4 == 1) {
                    n34 = 1;
                }
                n26 = 2 - n34;
                break;
            }
            case 24: {
                n27 = 3;
                n26 = 3;
                break;
            }
            case 32: {
                n27 = 4;
                int n35 = 0;
                if (n4 == 1) {
                    n35 = 1;
                }
                n26 = 5 - n35;
                break;
            }
            default: {
                return;
            }
        }
        int n36 = n6 * n3 + n5 * n27;
        switch (n16) {
            case 8: {
                n25 = 6;
                break;
            }
            case 4: {
                n17 <<= 1;
                n25 = 7;
                break;
            }
            case 2: {
                n17 <<= 2;
                n25 = 8;
                break;
            }
            case 1: {
                n17 <<= 3;
                int n37 = 0;
                if (n18 == 1) {
                    n37 = 1;
                }
                n25 = 10 - n37;
                break;
            }
            default: {
                return;
            }
        }
        int n38 = (bl2 ? n20 + n31 : n20) * n17 + (bl ? n19 + n28 : n19);
        int n39 = bl ? -1 : 1;
        int n40 = n24 = bl2 ? -n17 : n17;
        if ((n & 2) != 0) {
            switch (n12) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = n15 * n13 + n14;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = n15 * (n13 <<= 3) + n14;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = 0;
                    break;
                }
                default: {
                    n12 = (n12 << 16) / 255;
                }
                case -2: {
                    n23 = 0;
                    break;
                }
            }
        } else {
            n12 = 65536;
            n23 = 0;
        }
        boolean bl3 = false;
        if ((n & 4) != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        int n41 = ImageData.getChannelShift(n9);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(n9, n41)];
        int n42 = ImageData.getChannelShift(n10);
        byte[] byArray8 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n42)];
        int n43 = ImageData.getChannelShift(n11);
        byte[] byArray9 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n43)];
        int n44 = ImageData.getChannelShift(0);
        byte[] byArray10 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n44)];
        int n45 = n38;
        int n46 = n36;
        int n47 = n23;
        int n48 = n12;
        int n49 = 0;
        int n50 = 0;
        int n51 = 0;
        int n52 = 0;
        int n53 = 0;
        int n54 = 0;
        int n55 = -1;
        int n56 = -1;
        int n57 = -1;
        int n58 = 1 << n16;
        if (byArray4 != null && byArray4.length < n58) {
            n58 = byArray4.length;
        }
        if (bl4) {
            nArray3 = new int[n21 + 2];
            nArray2 = new int[n21 + 2];
            nArray = new int[n21 + 2];
        } else {
            nArray3 = null;
            nArray2 = null;
            nArray = null;
        }
        int n59 = n22;
        int n60 = n33;
        while (n59 > 0) {
            int n61 = 0;
            int n62 = 0;
            int n63 = 0;
            int n64 = n21;
            int n65 = n30;
            while (n64 > 0) {
                block87: {
                    int n66;
                    int n67;
                    int n68;
                    block86: {
                        switch (n26) {
                            case 0: {
                                n68 = byArray[n46] & 0xFF;
                                n46 += n65 >>> 16;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                            case 1: {
                                n68 = (byArray[n46] & 0xFF) << 8 | byArray[n46 + 1] & 0xFF;
                                n46 += (n65 >>> 16) * 2;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                            case 2: {
                                n68 = (byArray[n46 + 1] & 0xFF) << 8 | byArray[n46] & 0xFF;
                                n46 += (n65 >>> 16) * 2;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                            case 3: {
                                n68 = ((byArray[n46] & 0xFF) << 8 | byArray[n46 + 1] & 0xFF) << 8 | byArray[n46 + 2] & 0xFF;
                                n46 += (n65 >>> 16) * 3;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                            case 4: {
                                n68 = (((byArray[n46] & 0xFF) << 8 | byArray[n46 + 1] & 0xFF) << 8 | byArray[n46 + 2] & 0xFF) << 8 | byArray[n46 + 3] & 0xFF;
                                n46 += (n65 >>> 16) * 4;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                            case 5: {
                                n68 = (((byArray[n46 + 3] & 0xFF) << 8 | byArray[n46 + 2] & 0xFF) << 8 | byArray[n46 + 1] & 0xFF) << 8 | byArray[n46] & 0xFF;
                                n46 += (n65 >>> 16) * 4;
                                n49 = byArray7[(n68 & n9) >>> n41] & 0xFF;
                                n50 = byArray8[(n68 & n10) >>> n42] & 0xFF;
                                n51 = byArray9[(n68 & n11) >>> n43] & 0xFF;
                                n52 = byArray10[0 >>> n44] & 0xFF;
                                break;
                            }
                        }
                        block27 : switch (n12) {
                            case -1: {
                                n48 = ((byArray2[n47] & 0xFF) << 16) / 255;
                                n47 += n65 >> 16;
                                break;
                            }
                            case -2: {
                                n48 = (n52 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n48 = byArray2[n47] != 0 ? 65536 : 0;
                                n47 += n65 >> 16;
                                break;
                            }
                            case -4: {
                                n48 = byArray2[n47 >> 3] << (n47 & 7) + 9 & 0x10000;
                                n47 += n65 >> 16;
                                break;
                            }
                            case -6: {
                                n48 = 65536;
                                n68 = 0;
                                while (n68 < byArray2.length) {
                                    if (n49 == byArray2[n68] && n50 == byArray2[n68 + 1] && n51 == byArray2[n68 + 2]) {
                                        n48 = 0;
                                        break block27;
                                    }
                                    n68 += 3;
                                }
                                break;
                            }
                        }
                        if (n48 == 65536) break block86;
                        if (n48 == 0) break block87;
                        switch (n25) {
                            case 6: {
                                n53 = byArray3[n45] & 0xFF;
                                break;
                            }
                            case 7: {
                                if ((n45 & 1) != 0) {
                                    n53 = byArray3[n45 >> 1] & 0xF;
                                    break;
                                }
                                n53 = byArray3[n45 >> 1] >>> 4 & 0xF;
                                break;
                            }
                            case 8: {
                                n53 = byArray3[n45 >> 2] >>> 6 - (n45 & 3) * 2 & 3;
                                break;
                            }
                            case 9: {
                                n53 = byArray3[n45 >> 3] >>> 7 - (n45 & 7) & 1;
                                break;
                            }
                            case 10: {
                                n53 = byArray3[n45 >> 3] >>> (n45 & 7) & 1;
                                break;
                            }
                        }
                        n68 = byArray4[n53] & 0xFF;
                        n67 = byArray5[n53] & 0xFF;
                        n66 = byArray6[n53] & 0xFF;
                        n49 = n68 + ((n49 - n68) * n48 >> 16);
                        n50 = n67 + ((n50 - n67) * n48 >> 16);
                        n51 = n66 + ((n51 - n66) * n48 >> 16);
                    }
                    if (bl4) {
                        if ((n49 += nArray3[n64] >> 4) < 0) {
                            n49 = 0;
                        } else if (n49 > 255) {
                            n49 = 255;
                        }
                        if ((n50 += nArray2[n64] >> 4) < 0) {
                            n50 = 0;
                        } else if (n50 > 255) {
                            n50 = 255;
                        }
                        if ((n51 += nArray[n64] >> 4) < 0) {
                            n51 = 0;
                        } else if (n51 > 255) {
                            n51 = 255;
                        }
                        nArray3[n64] = n61;
                        nArray2[n64] = n62;
                        nArray[n64] = n63;
                    }
                    if (n49 != n55 || n50 != n56 || n51 != n57) {
                        n68 = 0;
                        int n69 = Integer.MAX_VALUE;
                        while (n68 < n58) {
                            n67 = (byArray4[n68] & 0xFF) - n49;
                            n66 = (byArray5[n68] & 0xFF) - n50;
                            int n70 = (byArray6[n68] & 0xFF) - n51;
                            int n71 = n67 * n67 + n66 * n66 + n70 * n70;
                            if (n71 < n69) {
                                n54 = n68;
                                if (n71 == 0) break;
                                n69 = n71;
                            }
                            ++n68;
                        }
                        n55 = n49;
                        n56 = n50;
                        n57 = n51;
                    }
                    if (bl4) {
                        n68 = n64 - 1;
                        int n72 = n67 = n64 + 1;
                        n61 = n49 - (byArray4[n54] & 0xFF);
                        n66 = n61 + n61 + n61;
                        nArray3[n72] = nArray3[n72] + n66;
                        int n73 = n64;
                        nArray3[n73] = nArray3[n73] + (n66 += n61 + n61);
                        int n74 = n68;
                        nArray3[n74] = nArray3[n74] + (n66 + n61 + n61);
                        int n75 = n67;
                        n62 = n50 - (byArray5[n54] & 0xFF);
                        n66 = n62 + n62 + n62;
                        nArray2[n75] = nArray2[n75] + n66;
                        int n76 = n64;
                        nArray2[n76] = nArray2[n76] + (n66 += n62 + n62);
                        int n77 = n68;
                        nArray2[n77] = nArray2[n77] + (n66 + n62 + n62);
                        int n78 = n67;
                        n63 = n51 - (byArray6[n54] & 0xFF);
                        n66 = n63 + n63 + n63;
                        nArray[n78] = nArray[n78] + n66;
                        int n79 = n64;
                        nArray[n79] = nArray[n79] + (n66 += n63 + n63);
                        int n80 = n68;
                        nArray[n80] = nArray[n80] + (n66 + n63 + n63);
                    }
                    switch (n25) {
                        case 6: {
                            byArray3[n45] = (byte)n54;
                            break;
                        }
                        case 7: {
                            if ((n45 & 1) != 0) {
                                byArray3[n45 >> 1] = (byte)(byArray3[n45 >> 1] & 0xF0 | n54);
                                break;
                            }
                            byArray3[n45 >> 1] = (byte)(byArray3[n45 >> 1] & 0xF | n54 << 4);
                            break;
                        }
                        case 8: {
                            n68 = 6 - (n45 & 3) * 2;
                            byArray3[n45 >> 2] = (byte)(byArray3[n45 >> 2] & ~(3 << n68) | n54 << n68);
                            break;
                        }
                        case 9: {
                            n68 = 7 - (n45 & 7);
                            byArray3[n45 >> 3] = (byte)(byArray3[n45 >> 3] & ~(1 << n68) | n54 << n68);
                            break;
                        }
                        case 10: {
                            n68 = n45 & 7;
                            byArray3[n45 >> 3] = (byte)(byArray3[n45 >> 3] & ~(1 << n68) | n54 << n68);
                            break;
                        }
                    }
                }
                --n64;
                n45 += n39;
                n65 = (n65 & (char)-1) + n30;
            }
            --n59;
            n46 = n36 += (n60 >>> 16) * n3;
            n47 = n23 += (n60 >>> 16) * n13;
            n60 = (n60 & (char)-1) + n33;
            n45 = n38 += n24;
        }
    }

    static final int getChannelShift(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while ((n & 1) == 0 && n2 < 32) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    static final int getChannelWidth(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n >>>= n2;
        int n3 = n2;
        while ((n & 1) != 0 && n3 < 32) {
            n >>>= 1;
            ++n3;
        }
        return n3 - n2;
    }

    static final byte getChannelField(int n, int n2) {
        int n3 = ImageData.getChannelShift(n2);
        return ANY_TO_EIGHT[ImageData.getChannelWidth(n2, n3)][(n & n2) >>> n3];
    }

    static final ImageData createGradientBand(int n, int n2, boolean bl, RGB rGB, RGB rGB2, int n3, int n4, int n5) {
        byte[] byArray;
        int n6;
        int n7;
        int n8;
        PaletteData paletteData;
        if (n3 != 0 && n4 != 0 && n5 != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            n8 = 32;
            if (n3 >= 8 && n4 >= 8 && n5 >= 8) {
                int n9;
                if (bl) {
                    n7 = 1;
                    n6 = n2;
                    int n10 = 1;
                    if (n6 > 1) {
                        n10 = n6 - 1;
                    }
                    n9 = n10;
                } else {
                    n7 = n;
                    n6 = 1;
                    int n11 = 1;
                    if (n7 > 1) {
                        n11 = n7 - 1;
                    }
                    n9 = n11;
                }
                int n12 = n7 * 4;
                byArray = new byte[n6 * n12];
                ImageData.buildPreciseGradientChannel(rGB.blue, rGB2.blue, n9, n7, n6, bl, byArray, 0, n12);
                ImageData.buildPreciseGradientChannel(rGB.green, rGB2.green, n9, n7, n6, bl, byArray, 1, n12);
                ImageData.buildPreciseGradientChannel(rGB.red, rGB2.red, n9, n7, n6, bl, byArray, 2, n12);
            } else {
                int n13;
                if (bl) {
                    n7 = n < 8 ? n : 8;
                    n6 = n2;
                    int n14 = 1;
                    if (n6 > 1) {
                        n14 = n6 - 1;
                    }
                    n13 = n14;
                } else {
                    n7 = n;
                    n6 = n2 < 8 ? n2 : 8;
                    int n15 = 1;
                    if (n7 > 1) {
                        n15 = n7 - 1;
                    }
                    n13 = n15;
                }
                int n16 = n7 * 4;
                byArray = new byte[n6 * n16];
                ImageData.buildDitheredGradientChannel(rGB.blue, rGB2.blue, n13, n7, n6, bl, byArray, 0, n16, n5);
                ImageData.buildDitheredGradientChannel(rGB.green, rGB2.green, n13, n7, n6, bl, byArray, 1, n16, n4);
                ImageData.buildDitheredGradientChannel(rGB.red, rGB2.red, n13, n7, n6, bl, byArray, 2, n16, n3);
            }
        } else {
            int n17;
            paletteData = new PaletteData(new RGB[]{rGB, rGB2});
            n8 = 8;
            if (bl) {
                n7 = n < 8 ? n : 8;
                n6 = n2;
                int n18 = 1;
                if (n6 > 1) {
                    n18 = 0x1040000 / (n6 - 1) + 1;
                }
                n17 = n18;
            } else {
                n7 = n;
                n6 = n2 < 8 ? n2 : 8;
                int n19 = 1;
                if (n7 > 1) {
                    n19 = 0x1040000 / (n7 - 1) + 1;
                }
                n17 = n19;
            }
            int n20 = n7 + 3 & 0xFFFFFFFC;
            byArray = new byte[n6 * n20];
            if (bl) {
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                while (n21 < n6) {
                    int n24 = 0;
                    while (n24 < n7) {
                        int n25 = 0;
                        if (n22 + DITHER_MATRIX[n21 & 7][n24] < 0x1000000) {
                            n25 = 1;
                        }
                        byArray[n23 + n24] = 1 - n25;
                        ++n24;
                    }
                    ++n21;
                    n22 += n17;
                    n23 += n20;
                }
            } else {
                int n26 = 0;
                int n27 = 0;
                while (n26 < n7) {
                    int n28 = 0;
                    int n29 = n26;
                    while (n28 < n6) {
                        int n30 = 0;
                        if (n27 + DITHER_MATRIX[n28][n26 & 7] < 0x1000000) {
                            n30 = 1;
                        }
                        byArray[n29] = 1 - n30;
                        ++n28;
                        n29 += n20;
                    }
                    ++n26;
                    n27 += n17;
                }
            }
        }
        return new ImageData(n7, n6, n8, paletteData, 4, byArray);
    }

    static final void buildPreciseGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7) {
        int n8 = n << 16;
        int n9 = ((n2 << 16) - n8) / n3 + 1;
        if (bl) {
            int n10 = 0;
            while (n10 < n5) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n10;
                n6 += n7;
            }
        } else {
            int n11 = 0;
            while (n11 < n4) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n11;
                n6 += 4;
            }
        }
    }

    static final void buildDitheredGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7, int n8) {
        int n9 = 65280 >>> n8;
        int n10 = n << 16;
        int n11 = ((n2 << 16) - n10) / n3 + 1;
        if (bl) {
            int n12 = 0;
            while (n12 < n5) {
                int n13 = 0;
                int n14 = n6;
                while (n13 < n4) {
                    int n15 = DITHER_MATRIX[n12 & 7][n13] >>> n8;
                    int n16 = n10 + n15;
                    byArray[n14] = n16 > 0xFFFFFF ? -1 : (byte)(n16 >>> 16 & n9);
                    ++n13;
                    n14 += 4;
                }
                n10 += n11;
                ++n12;
                n6 += n7;
            }
        } else {
            int n17 = 0;
            while (n17 < n4) {
                int n18 = 0;
                int n19 = n6;
                while (n18 < n5) {
                    int n20 = DITHER_MATRIX[n18][n17 & 7] >>> n8;
                    int n21 = n10 + n20;
                    byArray[n19] = n21 > 0xFFFFFF ? -1 : (byte)(n21 >>> 16 & n9);
                    ++n18;
                    n19 += n7;
                }
                n10 += n11;
                ++n17;
                n6 += 4;
            }
        }
    }

    public ImageData(int n, int n2, int n3, PaletteData paletteData) {
        this(n, n2, n3, paletteData, 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray) {
        this(n, n2, n3, paletteData, n4, ImageData.checkData(byArray), 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(InputStream inputStream) {
        ImageData[] imageDataArray = ImageDataLoader.load(inputStream);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    public ImageData(String string) {
        ImageData[] imageDataArray = ImageDataLoader.load(string);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    ImageData() {
    }

    ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13;
        if (paletteData == null) {
            SWT.error(4);
        }
        if (n3 != 1 && n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
            SWT.error(5);
        }
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            SWT.error(7);
        }
        int n14 = ((n * n3 + 7) / 8 + (n4 - 1)) / n4 * n4;
        int n15 = n13 = n8 == 5 ? ((n + 7) / 8 + 3) / 4 * 4 : n14;
        if (byArray != null && byArray.length < n13 * n2) {
            SWT.error(5);
        }
        this.setAllFields(n, n2, n3, n4, n14, byArray != null ? byArray : new byte[n14 * n2], paletteData, n7, byArray2, n5, byArray3, n6, n8, n9, n10, n11, n12);
    }

    static {
        int n = 0;
        while (n < 9) {
            ImageData.ANY_TO_EIGHT[n] = new byte[1 << n];
            byte[] byArray = ImageData.ANY_TO_EIGHT[n];
            if (n != 0) {
                int n2 = 0;
                int n3 = 65536;
                while ((n3 >>= n) != 0) {
                    n2 |= n3;
                }
                n3 = 0;
                int n4 = 0;
                while (n3 < 65536) {
                    byArray[n4++] = (byte)(n3 >> 8);
                    n3 += n2;
                }
            }
            ++n;
        }
        ONE_TO_ONE_MAPPING = ANY_TO_EIGHT[8];
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000};
        nArrayArray[1] = new int[]{0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000};
        nArrayArray[2] = new int[]{0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000};
        nArrayArray[3] = new int[]{786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000};
        nArrayArray[4] = new int[]{0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000};
        nArrayArray[5] = new int[]{0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000};
        nArrayArray[6] = new int[]{0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000};
        int[] nArray = new int[8];
        nArray[1] = 0x800000;
        nArray[2] = 0x200000;
        nArray[3] = 0xA00000;
        nArray[4] = 524288;
        nArray[5] = 0x880000;
        nArray[6] = 0x280000;
        nArray[7] = 0xA80000;
        nArrayArray[7] = nArray;
        DITHER_MATRIX = nArrayArray;
    }
}

