/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class GraphicsUtil {
    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl) {
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        int[] nArray = null;
        int n = writableRaster.getNumBands();
        if (bl) {
            if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
                GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
            } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
                GraphicsUtil.mult_INT_PACK_Data(writableRaster);
            } else {
                float f = 0.003921569f;
                int n2 = writableRaster.getMinX();
                int n3 = n2 + writableRaster.getWidth();
                int n4 = writableRaster.getMinY();
                int n5 = n4 + writableRaster.getHeight();
                for (int i = n4; i < n5; ++i) {
                    for (int j = n2; j < n3; ++j) {
                        int n6 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                        if (n6 < 0 || n6 >= 255) continue;
                        float f2 = (float)n6 * f;
                        for (int k = 0; k < n - 1; ++k) {
                            nArray[k] = (int)((float)nArray[k] * f2 + 0.5f);
                        }
                        writableRaster.setPixel(j, i, nArray);
                    }
                }
            }
        } else if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n7 = writableRaster.getMinX();
            int n8 = n7 + writableRaster.getWidth();
            int n9 = writableRaster.getMinY();
            int n10 = n9 + writableRaster.getHeight();
            for (int i = n9; i < n10; ++i) {
                for (int j = n7; j < n8; ++j) {
                    int n11 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                    if (n11 <= 0 || n11 >= 255) continue;
                    float f = 255.0f / (float)n11;
                    for (int k = 0; k < n - 1; ++k) {
                        nArray[k] = (int)((float)nArray[k] * f + 0.5f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl);
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 <= 0) {
                    nArray[n4] = 0xFFFFFF;
                    continue;
                }
                if (n7 >= 255) continue;
                int n8 = 0xFF0000 / n7;
                nArray[n4] = n7 << 24 | ((n6 & 0xFF0000) >> 16) * n8 & 0xFF0000 | (((n6 & 0xFF00) >> 8) * n8 & 0xFF0000) >> 8 | ((n6 & 0xFF) * n8 & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 < 0 || n7 >= 255) continue;
                nArray[n4] = n7 << 24 | (n6 & 0xFF0000) * n7 >> 8 & 0xFF0000 | (n6 & 0xFF00) * n7 >> 8 & 0xFF00 | (n6 & 0xFF) * n7 >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n8;
            int n9 = n8 + n * n3;
            for (n8 = n4 + i * n2; n8 < n9; n8 += n3) {
                int n10;
                n5 = byArray[n8 + n6] & 0xFF;
                if (n5 == 0) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        byArray[n8 + nArray[n10]] = -1;
                    }
                    continue;
                }
                if (n5 >= 255) continue;
                int n11 = 0xFF0000 / n5;
                for (n10 = 0; n10 < n7; ++n10) {
                    int n12 = n8 + nArray[n10];
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) * n11 >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n8;
            int n9 = n8 + n * n3;
            for (n8 = n4 + i * n2; n8 < n9; n8 += n3) {
                n5 = byArray[n8 + n6] & 0xFF;
                if (n5 == 255) continue;
                for (int j = 0; j < n7; ++j) {
                    int n10 = n8 + nArray[j];
                    byArray[n10] = (byte)((byArray[n10] & 0xFF) * n5 >> 8);
                }
            }
        }
    }
}

