/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.Geom;
import javax.baja.gx.IPathGeom;

public final class PathGeom
extends Geom
implements IPathGeom {
    private IPathGeom.Segment[] segments;
    private int size;

    public final int getGeomCase() {
        return 5;
    }

    public final IPathGeom.Segment[] segments() {
        IPathGeom.Segment[] segmentArray = new IPathGeom.Segment[this.size];
        System.arraycopy(this.segments, 0, segmentArray, 0, this.size);
        return segmentArray;
    }

    public final IPathGeom.Segment segment(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.segments[n];
    }

    public final int size() {
        return this.size;
    }

    public final void closePath() {
        this.add(new IPathGeom.ClosePath());
    }

    public final void moveTo(boolean bl, double d, double d2) {
        this.add(new IPathGeom.MoveTo(bl, d, d2));
    }

    public final void lineTo(boolean bl, double d, double d2) {
        this.add(new IPathGeom.LineTo(bl, d, d2));
    }

    public final void hlineTo(boolean bl, double d) {
        this.add(new IPathGeom.HLineTo(bl, d));
    }

    public final void vlineTo(boolean bl, double d) {
        this.add(new IPathGeom.VLineTo(bl, d));
    }

    public final void curveTo(boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        this.add(new IPathGeom.CurveTo(bl, d, d2, d3, d4, d5, d6));
    }

    public final void smoothCurveTo(boolean bl, double d, double d2, double d3, double d4) {
        this.add(new IPathGeom.SmoothCurveTo(bl, d, d2, d3, d4));
    }

    public final void quadTo(boolean bl, double d, double d2, double d3, double d4) {
        this.add(new IPathGeom.QuadTo(bl, d, d2, d3, d4));
    }

    public final void smoothQuadTo(boolean bl, double d, double d2) {
        this.add(new IPathGeom.SmoothQuadTo(bl, d, d2));
    }

    public final void arcTo(boolean bl, double d, double d2, double d3, boolean bl2, boolean bl3, double d4, double d5) {
        this.add(new IPathGeom.ArcTo(bl, d, d2, d3, bl2, bl3, d4, d5));
    }

    public final void add(IPathGeom.Segment segment) {
        if (this.size >= this.segments.length) {
            int n = Math.max(this.size * 2, 4);
            IPathGeom.Segment[] segmentArray = new IPathGeom.Segment[n];
            System.arraycopy(this.segments, 0, segmentArray, 0, this.size);
            this.segments = segmentArray;
        }
        this.segments[this.size++] = segment;
        this.dirty();
    }

    public final void clear() {
        this.size = 0;
        this.dirty();
    }

    public final boolean equals(Object object) {
        if (object instanceof PathGeom) {
            PathGeom pathGeom = (PathGeom)object;
            if (this.size != pathGeom.size) {
                return false;
            }
            return PathGeom.equals(this.segments, pathGeom.segments, this.size);
        }
        return false;
    }

    public final String toString() {
        return PathGeom.toString(this.segments, this.size);
    }

    static final boolean equals(IPathGeom.Segment[] segmentArray, IPathGeom.Segment[] segmentArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (!segmentArray[n2].equals(segmentArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static final String toString(IPathGeom.Segment[] segmentArray, int n) {
        IPathGeom.Segment segment = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            IPathGeom.Segment segment2;
            char c2;
            if (n2 > 0) {
                stringBuffer.append(' ');
            }
            if (c != (c2 = (segment2 = segmentArray[n2]).getCommand())) {
                stringBuffer.append(c2);
                c = c2;
            }
            segment2.toString(stringBuffer);
            segment = segment2;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public PathGeom(IPathGeom iPathGeom) {
        this.segments = iPathGeom.segments();
        this.size = iPathGeom.size();
    }

    public PathGeom(IPathGeom.Segment[] segmentArray, int n) {
        this.segments = (IPathGeom.Segment[])segmentArray.clone();
        this.size = n;
    }

    public PathGeom() {
        this.segments = new IPathGeom.Segment[10];
        this.size = 0;
    }
}

