/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.IGeom;
import javax.baja.sys.BDouble;

public interface IPathGeom
extends IGeom {
    public Segment[] segments();

    public Segment segment(int var1);

    public int size();

    public static class ArcTo
    extends Segment {
        double rx;
        double ry;
        double xAxisRotation;
        double x;
        double y;
        boolean largeArcFlag;
        boolean sweepFlag;

        public char getCommand() {
            return this.absolute ? (char)'A' : 'a';
        }

        public double getRadiusX() {
            return this.rx;
        }

        public double getRadiusY() {
            return this.ry;
        }

        public double getXAxisRotation() {
            return this.xAxisRotation;
        }

        public boolean getLargeArcFlag() {
            return this.largeArcFlag;
        }

        public boolean getSweepFlag() {
            return this.sweepFlag;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            ArcTo arcTo = (ArcTo)segment;
            boolean bl = false;
            if (this.rx == arcTo.rx && this.ry == arcTo.ry && this.xAxisRotation == arcTo.xAxisRotation && this.largeArcFlag == arcTo.largeArcFlag && this.sweepFlag == arcTo.sweepFlag && this.x == arcTo.x && this.y == arcTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.rx)).append(',').append(BDouble.encode((double)this.ry)).append(' ').append(BDouble.encode((double)this.xAxisRotation)).append(' ').append(this.largeArcFlag + 48).append(',').append(this.sweepFlag + 48).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public ArcTo(boolean bl, double d, double d2, double d3, boolean bl2, boolean bl3, double d4, double d5) {
            super(bl);
            this.rx = d;
            this.ry = d2;
            this.xAxisRotation = d3;
            this.largeArcFlag = bl2;
            this.sweepFlag = bl3;
            this.x = d4;
            this.y = d5;
        }
    }

    public static class SmoothQuadTo
    extends Segment {
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'T' : 't';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            SmoothQuadTo smoothQuadTo = (SmoothQuadTo)segment;
            boolean bl = false;
            if (this.x == smoothQuadTo.x && this.y == smoothQuadTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public SmoothQuadTo(boolean bl, double d, double d2) {
            super(bl);
            this.x = d;
            this.y = d2;
        }
    }

    public static class QuadTo
    extends Segment {
        double x1;
        double y1;
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'Q' : 'q';
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            QuadTo quadTo = (QuadTo)segment;
            boolean bl = false;
            if (this.x1 == quadTo.x1 && this.y1 == quadTo.y1 && this.x == quadTo.x && this.y == quadTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x1)).append(',').append(BDouble.encode((double)this.y1)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public QuadTo(boolean bl, double d, double d2, double d3, double d4) {
            super(bl);
            this.x1 = d;
            this.y1 = d2;
            this.x = d3;
            this.y = d4;
        }
    }

    public static class SmoothCurveTo
    extends Segment {
        double x2;
        double y2;
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'S' : 's';
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            SmoothCurveTo smoothCurveTo = (SmoothCurveTo)segment;
            boolean bl = false;
            if (this.x2 == smoothCurveTo.x2 && this.y2 == smoothCurveTo.y2 && this.x == smoothCurveTo.x && this.y == smoothCurveTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x2)).append(',').append(BDouble.encode((double)this.y2)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public SmoothCurveTo(boolean bl, double d, double d2, double d3, double d4) {
            super(bl);
            this.x2 = d;
            this.y2 = d2;
            this.x = d3;
            this.y = d4;
        }
    }

    public static class CurveTo
    extends Segment {
        double x1;
        double y1;
        double x2;
        double y2;
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'C' : 'c';
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            CurveTo curveTo = (CurveTo)segment;
            boolean bl = false;
            if (this.x1 == curveTo.x1 && this.y1 == curveTo.y1 && this.x2 == curveTo.x2 && this.y2 == curveTo.y2 && this.x == curveTo.x && this.y == curveTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x1)).append(',').append(BDouble.encode((double)this.y1)).append(' ').append(BDouble.encode((double)this.x2)).append(',').append(BDouble.encode((double)this.y2)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public CurveTo(boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
            super(bl);
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
            this.x = d5;
            this.y = d6;
        }
    }

    public static class VLineTo
    extends Segment {
        double y;

        public char getCommand() {
            return this.absolute ? (char)'V' : 'v';
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            VLineTo vLineTo = (VLineTo)segment;
            boolean bl = false;
            if (this.y == vLineTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.y));
        }

        public VLineTo(boolean bl, double d) {
            super(bl);
            this.y = d;
        }
    }

    public static class HLineTo
    extends Segment {
        double x;

        public char getCommand() {
            return this.absolute ? (char)'H' : 'h';
        }

        public double getX() {
            return this.x;
        }

        boolean doEquals(Segment segment) {
            HLineTo hLineTo = (HLineTo)segment;
            boolean bl = false;
            if (this.x == hLineTo.x) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x));
        }

        public HLineTo(boolean bl, double d) {
            super(bl);
            this.x = d;
        }
    }

    public static class LineTo
    extends Segment {
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'L' : 'l';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            LineTo lineTo = (LineTo)segment;
            boolean bl = false;
            if (this.x == lineTo.x && this.y == lineTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }

        public LineTo(boolean bl, double d, double d2) {
            super(bl);
            this.x = d;
            this.y = d2;
        }
    }

    public static class MoveTo
    extends Segment {
        double x;
        double y;

        public char getCommand() {
            return this.absolute ? (char)'M' : 'm';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        boolean doEquals(Segment segment) {
            MoveTo moveTo = (MoveTo)segment;
            boolean bl = false;
            if (this.x == moveTo.x && this.y == moveTo.y) {
                bl = true;
            }
            return bl;
        }

        void toString(StringBuffer stringBuffer) {
            stringBuffer.append(BDouble.encode((double)this.x));
            stringBuffer.append(',');
            stringBuffer.append(BDouble.encode((double)this.y));
        }

        public MoveTo(boolean bl, double d, double d2) {
            super(bl);
            this.x = d;
            this.y = d2;
        }
    }

    public static class ClosePath
    extends Segment {
        public char getCommand() {
            return 'Z';
        }

        boolean doEquals(Segment segment) {
            return true;
        }

        void toString(StringBuffer stringBuffer) {
        }

        public ClosePath() {
            super(false);
        }
    }

    public static abstract class Segment {
        boolean absolute;

        public abstract char getCommand();

        public final boolean isAbsolute() {
            return this.absolute;
        }

        public final boolean isRelative() {
            return this.absolute ^ true;
        }

        public final boolean equals(Object object) {
            if (this.getClass() == object.getClass()) {
                Segment segment = (Segment)object;
                if (this.absolute != segment.absolute) {
                    return false;
                }
                return this.doEquals(segment);
            }
            return false;
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getCommand());
            this.toString(stringBuffer);
            return stringBuffer.toString();
        }

        abstract boolean doEquals(Segment var1);

        abstract void toString(StringBuffer var1);

        Segment(boolean bl) {
            this.absolute = bl;
        }
    }
}

