/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTransform
extends BSimple {
    public static final int TRANSLATE = 1;
    public static final int SCALE = 2;
    public static final int ROTATE = 3;
    public static final int SKEW_X = 4;
    public static final int SKEW_Y = 5;
    public static final BTransform DEFAULT = BTransform.make(new Transform[0]);
    public static final Type TYPE;
    Transform[] transforms;
    String string;
    BTransform inverse;
    Matrix matrix;
    Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BTransform;

    public static final BTransform make(Transform[] transformArray) {
        return new BTransform(transformArray);
    }

    public static final BTransform make(Transform transform) {
        return new BTransform(transform);
    }

    public static final BTransform makeTranslate(double d, double d2) {
        return BTransform.make(new Translate(d, d2));
    }

    public static final BTransform makeScale(double d, double d2) {
        return BTransform.make(new Scale(d, d2));
    }

    public static final BTransform makeRotate(double d) {
        return BTransform.make(new Rotate(d));
    }

    public static final BTransform makeSkewX(double d) {
        return BTransform.make(new SkewX(d));
    }

    public static final BTransform makeSkewY(double d) {
        return BTransform.make(new SkewY(d));
    }

    public static final BTransform make(String string) {
        Parser parser = new Parser(string);
        BTransform bTransform = parser.parseTransform();
        if (bTransform == null || !parser.isEnd()) {
            throw new IllegalArgumentException(string);
        }
        return bTransform;
    }

    final void calcMatrix() {
        if (this.transforms.length == 1) {
            this.matrix = this.transforms[0].toMatrix();
        } else {
            this.matrix = new Matrix();
            int n = 0;
            while (n < this.transforms.length) {
                this.matrix.multiply(this.transforms[n].toMatrix(), this.matrix);
                ++n;
            }
        }
    }

    public final int size() {
        return this.transforms.length;
    }

    public final Transform getTransform(int n) {
        return this.transforms[n];
    }

    public final Transform[] getTransforms() {
        return (Transform[])this.transforms.clone();
    }

    public final BTransform getInverse() {
        if (this.inverse == null) {
            Transform[] transformArray = new Transform[this.transforms.length];
            int n = 0;
            while (n < transformArray.length) {
                transformArray[n] = this.transforms[this.transforms.length - n - 1].getInverse();
                ++n;
            }
            this.inverse = BTransform.make(transformArray);
        }
        return this.inverse;
    }

    public final Point transform(IPoint iPoint, Point point) {
        if (point == null) {
            point = new Point();
        }
        return this.matrix.transform(iPoint, point);
    }

    public final int hashCode() {
        try {
            return this.encodeToString().hashCode();
        }
        catch (Throwable throwable) {
            return System.identityHashCode((Object)this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BTransform) {
            BTransform bTransform = (BTransform)((Object)object);
            if (this.transforms.length != bTransform.transforms.length) {
                return false;
            }
            int n = 0;
            while (n < this.transforms.length) {
                if (!this.transforms[n].equals(bTransform.transforms[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.transforms.length == 1) {
                this.string = this.transforms[0].toString();
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.transforms.length) {
                    if (n > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(this.transforms[n]);
                    ++n;
                }
                this.string = stringBuffer.toString();
            }
        }
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BTransform.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = object;
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BTransform(Transform[] transformArray) {
        this.transforms = (Transform[])transformArray.clone();
        this.calcMatrix();
    }

    private BTransform(Transform transform) {
        this.transforms = new Transform[]{transform};
        this.calcMatrix();
    }

    static {
        Class clazz = class$javax$baja$gx$BTransform;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BTransform = BTransform.class("[Ljavax.baja.gx.BTransform;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class Translate
    extends Transform {
        double x;
        double y;

        public int getTransformCase() {
            return 1;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        Transform getInverse() {
            return new Translate(-this.x, -this.y);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.e = this.x;
            matrix.f = this.y;
            return matrix;
        }

        public boolean equals(Object object) {
            if (object instanceof Translate) {
                Translate translate = (Translate)object;
                boolean bl = false;
                if (this.x == translate.x && this.y == translate.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("translate(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                stringBuffer.append(',').append(BDouble.encode((double)this.y));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public Translate(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    public static class Scale
    extends Transform {
        double x;
        double y;

        public int getTransformCase() {
            return 2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        Transform getInverse() {
            return new Scale(1.0 / this.x, 1.0 / this.y);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.a = this.x;
            matrix.d = this.y;
            return matrix;
        }

        public boolean equals(Object object) {
            if (object instanceof Scale) {
                Scale scale = (Scale)object;
                boolean bl = false;
                if (this.x == scale.x && this.y == scale.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("scale(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                stringBuffer.append(',').append(BDouble.encode((double)this.y));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public Scale(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    public static class Rotate
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 3;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new Rotate(-this.angle);
        }

        Matrix toMatrix() {
            double d = this.angle / 180.0 * Math.PI;
            Matrix matrix = new Matrix();
            matrix.a = Math.cos(d);
            matrix.b = Math.sin(d);
            matrix.c = -Math.sin(d);
            matrix.d = Math.cos(d);
            return matrix;
        }

        public boolean equals(Object object) {
            if (object instanceof Rotate) {
                Rotate rotate = (Rotate)object;
                boolean bl = false;
                if (this.angle == rotate.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rotate(").append(BDouble.encode((double)this.angle)).append(')');
            return stringBuffer.toString();
        }

        public Rotate(double d) {
            this.angle = d;
        }
    }

    public static class SkewX
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 4;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new SkewX(-this.angle);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.c = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object object) {
            if (object instanceof SkewX) {
                SkewX skewX = (SkewX)object;
                boolean bl = false;
                if (this.angle == skewX.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("skewX(").append(BDouble.encode((double)this.angle)).append(')');
            return stringBuffer.toString();
        }

        public SkewX(double d) {
            this.angle = d;
        }
    }

    public static class SkewY
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 5;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new SkewY(-this.angle);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.b = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object object) {
            if (object instanceof SkewY) {
                SkewY skewY = (SkewY)object;
                boolean bl = false;
                if (this.angle == skewY.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("skewY(").append(BDouble.encode((double)this.angle)).append(')');
            return stringBuffer.toString();
        }

        public SkewY(double d) {
            this.angle = d;
        }
    }

    public static abstract class Transform {
        public abstract int getTransformCase();

        abstract Transform getInverse();

        abstract Matrix toMatrix();
    }

    static class Matrix {
        double a = 1.0;
        double b;
        double c;
        double d = 1.0;
        double e;
        double f;

        public Point transform(IPoint iPoint, Point point) {
            double d = iPoint.x();
            double d2 = iPoint.y();
            point.x = this.a * d + this.c * d2 + this.e;
            point.y = this.b * d + this.d * d2 + this.f;
            return point;
        }

        public Matrix multiply(Matrix matrix, Matrix matrix2) {
            double d = this.a;
            double d2 = this.b;
            double d3 = this.c;
            double d4 = this.d;
            double d5 = this.e;
            double d6 = this.f;
            double d7 = matrix.a;
            double d8 = matrix.b;
            double d9 = matrix.c;
            double d10 = matrix.d;
            double d11 = matrix.e;
            double d12 = matrix.f;
            matrix2.a = d * d7 + d3 * d8;
            matrix2.c = d * d9 + d3 * d10;
            matrix2.e = d * d11 + d3 * d12 + d5;
            matrix2.b = d2 * d7 + d4 * d8;
            matrix2.d = d2 * d9 + d4 * d10;
            matrix2.f = d2 * d11 + d4 * d12 + d6;
            return matrix2;
        }

        Matrix() {
        }
    }
}

