/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPen
extends BSimple {
    public static final int CAP_BUTT = 101;
    public static final int CAP_SQUARE = 102;
    public static final int CAP_ROUND = 103;
    public static final int JOIN_MITER = 201;
    public static final int JOIN_ROUND = 202;
    public static final int JOIN_BEVEL = 203;
    private static double[] noDash = new double[0];
    public static final BPen DEFAULT = BPen.make(1.0);
    public static final Type TYPE;
    private double width;
    private int cap;
    private int join;
    private double[] dash;
    private String string;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BPen;

    public static final BPen make(double d) {
        return BPen.make(d, 101, 201, null);
    }

    public static final BPen make(double d, double[] dArray) {
        return BPen.make(d, 101, 201, dArray);
    }

    public static final BPen make(double d, int n, int n2, double[] dArray) {
        return new BPen(d, n, n2, dArray);
    }

    public static final BPen make(String string) {
        Parser parser = new Parser(string);
        BPen bPen = parser.parsePen();
        if (bPen == null || !parser.isEnd()) {
            throw new IllegalArgumentException(string);
        }
        return bPen;
    }

    public final double getWidth() {
        return this.width;
    }

    public final int getCap() {
        return this.cap;
    }

    public final int getJoin() {
        return this.join;
    }

    public final double[] getDash() {
        if (this.dash.length == 0) {
            return this.dash;
        }
        return (double[])this.dash.clone();
    }

    public final int hashCode() {
        int n = 0;
        if (this.dash != null) {
            n = this.dash.length;
        }
        int n2 = n;
        long l = 23L + (long)n2;
        int n3 = 0;
        while (n3 < n2) {
            l = l * 37L + Double.doubleToRawLongBits(this.dash[n3]);
            ++n3;
        }
        l = l * 37L + Double.doubleToRawLongBits(this.width);
        l = l * 37L + (long)this.cap;
        l = l * 37L + (long)this.join;
        return (int)(l >>> 32) ^ (int)l;
    }

    public final boolean equals(Object object) {
        if (object instanceof BPen) {
            BPen bPen = (BPen)((Object)object);
            if (this.dash.length != bPen.dash.length) {
                return false;
            }
            int n = 0;
            while (n < this.dash.length) {
                if (this.dash[n] != bPen.dash[n]) {
                    return false;
                }
                ++n;
            }
            boolean bl = false;
            if (this.width == bPen.width && this.cap == bPen.cap && this.join == bPen.join) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(BDouble.encode((double)this.width));
            if (this.cap != 101) {
                stringBuffer.append(' ').append(this.getCapString());
            }
            if (this.join != 201) {
                stringBuffer.append(' ').append(this.getJoinString());
            }
            if (this.dash.length > 0) {
                stringBuffer.append(" dash(");
                int n = 0;
                while (n < this.dash.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(BDouble.encode((double)this.dash[n]));
                    ++n;
                }
                stringBuffer.append(')');
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    final String getCapString() {
        switch (this.cap) {
            case 101: {
                return "capButt";
            }
            case 102: {
                return "capSquare";
            }
            case 103: {
                return "capRound";
            }
        }
        throw new IllegalStateException();
    }

    final String getJoinString() {
        switch (this.join) {
            case 201: {
                return "joinMiter";
            }
            case 202: {
                return "joinRound";
            }
            case 203: {
                return "joinBevel";
            }
        }
        throw new IllegalStateException();
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BPen.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = object;
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BPen(double d, int n, int n2, double[] dArray) {
        if (d < 0.0) {
            throw new IllegalArgumentException("width " + d);
        }
        if (n != 101 && n != 102 && n != 103) {
            throw new IllegalArgumentException("cap " + n);
        }
        if (n2 != 201 && n2 != 202 && n2 != 203) {
            throw new IllegalArgumentException("join " + n2);
        }
        if (dArray == null) {
            dArray = noDash;
        }
        this.width = d;
        this.cap = n;
        this.join = n2;
        this.dash = dArray;
    }

    static {
        Class clazz = class$javax$baja$gx$BPen;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BPen = BPen.class("[Ljavax.baja.gx.BPen;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

