/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BImage
extends BSimple {
    public static final BImage NULL;
    public static final BImage DEFAULT;
    public static final Type TYPE;
    private BOrdList ordList;
    private boolean loadLocal;
    private BOrdList absOrdList;
    private ImagePeer peer;
    private Object awtSupport;
    private BImage disabled;
    private BImage highlighted;
    static /* synthetic */ Class class$javax$baja$gx$BImage;

    public static final BImage make(BIcon bIcon) {
        if (bIcon == null) {
            return NULL;
        }
        BImage bImage = (BImage)((Object)bIcon.fw(203));
        if (bImage == null) {
            bImage = BImage.make(bIcon.getOrdList());
            bIcon.fw(204, (Object)bImage, null, null, null);
        }
        return bImage;
    }

    public static final BImage make(BOrdList bOrdList) {
        return new BImage(bOrdList);
    }

    public static final BImage make(BOrd bOrd) {
        return BImage.make(BOrdList.make((BOrd)bOrd));
    }

    public static final BImage make(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        if (string.equals("new")) {
            return new BImage(BOrdList.NULL);
        }
        return BImage.make(BOrdList.make((String)string));
    }

    public static final BImage make(byte[] byArray) {
        return GxEnv.get().makeImage(byArray);
    }

    public static final BImage make(double d, double d2) {
        return GxEnv.get().makeImage(d, d2);
    }

    public final BOrdList getOrdList() {
        return this.ordList;
    }

    public final BOrdList getAbsoluteOrdList() {
        return this.absOrdList;
    }

    public final void setBaseOrd(BOrd bOrd) {
        if (bOrd == null || this.loadLocal) {
            this.absOrdList = this.ordList;
        } else {
            BOrd[] bOrdArray = this.ordList.toArray();
            int n = 0;
            while (n < bOrdArray.length) {
                if (!bOrdArray[n].isNull()) {
                    bOrdArray[n] = BOrd.make((BOrd)bOrd, (BOrd)bOrdArray[n]).normalize();
                }
                ++n;
            }
            this.absOrdList = BOrdList.make((BOrd[])bOrdArray);
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public final boolean isLoaded() {
        return this.peer().isLoaded();
    }

    public final BImage sync() {
        this.peer().sync();
        return this;
    }

    public final boolean animate() {
        return this.peer().animate();
    }

    public final Graphics getGraphics() {
        return this.peer().getGraphics();
    }

    public final double getWidth() {
        return this.peer().getWidth();
    }

    public final double getHeight() {
        return this.peer().getHeight();
    }

    public final int[] getPixels() {
        return this.peer().getPixels();
    }

    public final void setPixels(int[] nArray) {
        this.peer().setPixels(nArray);
    }

    public final void dispose() {
        if (this.awtSupport instanceof ImagePeer) {
            ((ImagePeer)this.awtSupport).dispose();
        }
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public final BImage getDisabledImage() {
        if (this.disabled == null) {
            this.disabled = GxEnv.get().makeDisabled(this);
        }
        return this.disabled;
    }

    public final BImage getHighlightedImage() {
        if (this.highlighted == null) {
            this.highlighted = GxEnv.get().makeHighlighted(this);
        }
        return this.highlighted;
    }

    public final BImage transform(BTransform bTransform) {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        Point point = bTransform.transform(new Point(0.0, 0.0), null);
        Point point2 = bTransform.transform(new Point(d2, 0.0), null);
        Point point3 = bTransform.transform(new Point(d2, d3), null);
        Point point4 = bTransform.transform(new Point(0.0, d3), null);
        double d4 = Math.min(point.x, Math.min(point2.x, Math.min(point3.x, point4.x)));
        double d5 = Math.min(point.y, Math.min(point2.y, Math.min(point3.y, point4.y)));
        double d6 = Math.max(point.x, Math.max(point2.x, Math.max(point3.x, point4.x)));
        double d7 = Math.max(point.y, Math.max(point2.y, Math.max(point3.y, point4.y)));
        double d8 = -d4;
        double d9 = -d5;
        double d10 = d6 - d4;
        if (d10 < 1.0) {
            d10 = 1.0;
        }
        if ((d = d7 - d5) < 1.0) {
            d = 1.0;
        }
        BImage bImage = BImage.make(d10, d);
        Graphics graphics = bImage.getGraphics();
        graphics.translate(d8, d9);
        graphics.transform(bTransform);
        graphics.drawImage(this, 0.0, 0.0);
        return bImage;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.ordList.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BImage) {
            BImage bImage = (BImage)((Object)object);
            if (this.ordList.isNull() || bImage.ordList.isNull()) {
                return false;
            }
            return this.ordList.equals((Object)bImage.ordList);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        if (this.isNull()) {
            return "null";
        }
        return this.ordList.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BImage.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = object;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)object);
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final ImagePeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeImagePeer(this);
        }
        return this.peer;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BImage(BOrdList bOrdList) {
        this.ordList = bOrdList;
        this.absOrdList = bOrdList;
        this.loadLocal = bOrdList.toString().startsWith("module:");
    }

    static {
        DEFAULT = NULL = BImage.make(BOrdList.NULL);
        Class clazz = class$javax$baja$gx$BImage;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BImage = BImage.class("[Ljavax.baja.gx.BImage;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

