/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFont
extends BSimple {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    private static Hashtable cache = new Hashtable();
    public static final BFont DEFAULT = BFont.make("sans-serif", 12.0);
    public static final BFont NULL = new BFont("null", 0.0, 0, "null");
    public static final Type TYPE;
    private String name;
    private double size;
    private int style;
    private boolean antiAliased;
    private String string;
    private FontPeer peer;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BFont;

    public static final BFont make(String string, double d) {
        return BFont.make(string, d, 0);
    }

    public static final BFont make(String string, double d, int n) {
        if (string == null || (n & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("bold ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("italic ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("underline ");
        }
        stringBuffer.append(BDouble.encode((double)d)).append("pt ");
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        BFont bFont = (BFont)((Object)cache.get(string2));
        if (bFont == null) {
            bFont = new BFont(string, d, n, string2);
            cache.put(string2, bFont);
        }
        return bFont;
    }

    public static final BFont make(String string) {
        Parser parser = new Parser(string);
        BFont bFont = parser.parseFont();
        if (bFont == null || !parser.isEnd()) {
            throw new IllegalArgumentException(string);
        }
        return bFont;
    }

    public static final BFont make(BFont bFont, int n) {
        return BFont.make(bFont.getName(), bFont.getSize(), n);
    }

    public static final BFont make(BFont bFont, double d) {
        return BFont.make(bFont.getName(), d, bFont.getStyle());
    }

    public final String getName() {
        return this.name;
    }

    public final double getSize() {
        return this.size;
    }

    public final int getStyle() {
        return this.style;
    }

    public final boolean isBold() {
        boolean bl = false;
        if ((this.style & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isItalic() {
        boolean bl = false;
        if ((this.style & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isUnderline() {
        boolean bl = false;
        if ((this.style & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAntiAliased() {
        return this.antiAliased;
    }

    public final double getLeading() {
        return this.peer().getLeading();
    }

    public final double getAscent() {
        return this.peer().getAscent();
    }

    public final double getDescent() {
        return this.peer().getDescent();
    }

    public final double getHeight() {
        return this.peer().getHeight();
    }

    public final double getMaxAscent() {
        return this.peer().getMaxAscent();
    }

    public final double getMaxDescent() {
        return this.peer().getMaxDescent();
    }

    public final double width(int n) {
        return this.peer().width(n);
    }

    public final double width(String string) {
        if (string == null) {
            return 0.0;
        }
        return this.peer().width(string);
    }

    public final double width(char[] cArray, int n, int n2) {
        return this.peer().width(cArray, n, n2);
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.string.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BFont) {
            return this.string.equals(((BFont)((Object)object)).string);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BFont.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = object;
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    final FontPeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeFontPeer(this);
        }
        return this.peer;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.antiAliased = true;
    }

    private BFont(String string, double d, int n, String string2) {
        this.this();
        this.name = string;
        this.size = d;
        this.style = n;
        this.string = string2;
        this.antiAliased = true;
    }

    static {
        cache.put("null", NULL);
        Class clazz = class$javax$baja$gx$BFont;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BFont = BFont.class("[Ljavax.baja.gx.BFont;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

