/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.IPoint;
import javax.baja.naming.BOrd;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBrush
extends BSimple {
    public static final int PAD = 1;
    public static final int REFLECT = 2;
    public static final int REPEAT = 3;
    public static final int TILE_FALSE = 0;
    public static final int TILE_TRUE = 1;
    public static final int TILE_X = 2;
    public static final int TILE_Y = 3;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final BBrush NULL = BBrush.makeSolid(BColor.NULL);
    public static final BBrush DEFAULT = BBrush.makeSolid(BColor.black);
    public static final Type TYPE;
    private Paint paint;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BBrush;

    public static final BBrush makeSolid(BColor bColor) {
        if (bColor.brush == null) {
            bColor.brush = new BBrush(new Solid(bColor));
        }
        return bColor.brush;
    }

    public static final BBrush makeInverse(BColor bColor) {
        return new BBrush(new Inverse(bColor));
    }

    public static final BBrush makeLinearGradient(Stop[] stopArray) {
        return BBrush.makeLinearGradient(stopArray, 1, 0.0);
    }

    public static final BBrush makeLinearGradient(Stop[] stopArray, int n, double d) {
        return new BBrush(new LinearGradient(stopArray, n, d));
    }

    public static final BBrush makeRadialGradient(Stop[] stopArray) {
        return BBrush.makeRadialGradient(stopArray, 1, BPoint.make(50.0, 50.0), 50.0);
    }

    public static final BBrush makeRadialGradient(Stop[] stopArray, int n, IPoint iPoint, double d) {
        return BBrush.makeRadialGradient(stopArray, n, iPoint, d, iPoint);
    }

    public static final BBrush makeRadialGradient(Stop[] stopArray, int n, IPoint iPoint, double d, IPoint iPoint2) {
        return new BBrush(new RadialGradient(stopArray, n, iPoint, d, iPoint2));
    }

    public static final BBrush makeImage(BImage bImage, int n, int n2, int n3) {
        return new BBrush(new Image(bImage, n, n2, n3));
    }

    public static final BBrush makeImage(BImage bImage) {
        return BBrush.makeImage(bImage, 0, 0, 0);
    }

    public static final BBrush make(String string) {
        Parser parser = new Parser(string);
        BBrush bBrush = parser.parseBrush();
        if (bBrush == null || !parser.isEnd()) {
            throw new IllegalArgumentException(string);
        }
        return bBrush;
    }

    public final Paint getPaint() {
        return this.paint;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        String string = this.paint != null ? this.paint.toString() : null;
        int n = 0;
        if (string != null) {
            n = string.hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object instanceof BBrush) {
            return this.paint.equals(((BBrush)((Object)object)).paint);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.paint.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BBrush.make(string);
    }

    public static final Stop stop(double d, BColor bColor) {
        return new Stop(d, bColor);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = object;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)object);
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void setBaseOrd(BOrd bOrd) {
        if (this.paint instanceof Image) {
            BImage bImage = ((Image)this.paint).getImage();
            bImage.setBaseOrd(bOrd);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBrush(Paint paint) {
        this.paint = paint;
    }

    static {
        Class clazz = class$javax$baja$gx$BBrush;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BBrush = BBrush.class("[Ljavax.baja.gx.BBrush;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class Solid
    extends Paint {
        final BColor color;

        public BColor getColor() {
            return this.color;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this.getClass() == object.getClass() && this.color.equals((Object)((Solid)object).color)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.color.encodeToString();
        }

        Solid(BColor bColor) {
            this.color = bColor;
        }
    }

    public static class Inverse
    extends Solid {
        public String toString() {
            return "inverse(" + this.color.encodeToString() + ')';
        }

        Inverse(BColor bColor) {
            super(bColor);
        }
    }

    public static class LinearGradient
    extends Gradient {
        final double angle;

        public double getAngle() {
            return this.angle;
        }

        boolean doEquals(Gradient gradient) {
            LinearGradient linearGradient = (LinearGradient)gradient;
            boolean bl = false;
            if (this.angle == linearGradient.angle) {
                bl = true;
            }
            return bl;
        }

        String getStringStart() {
            return "linearGradient";
        }

        void doString(StringBuffer stringBuffer) {
            if (this.angle != 0.0) {
                stringBuffer.append(" angle(").append(BDouble.encode((double)this.angle)).append(')');
            }
        }

        LinearGradient(Stop[] stopArray, int n, double d) {
            super(stopArray, n);
            this.angle = d;
        }
    }

    public static class RadialGradient
    extends Gradient {
        final BPoint center;
        final double radius;
        final BPoint focal;

        public BPoint getCenter() {
            return this.center;
        }

        public double getRadius() {
            return this.radius;
        }

        public BPoint getFocal() {
            return this.focal;
        }

        boolean doEquals(Gradient gradient) {
            RadialGradient radialGradient = (RadialGradient)gradient;
            boolean bl = false;
            if (this.center.equals(radialGradient.center) && this.radius == radialGradient.radius && this.focal.equals(radialGradient.focal)) {
                bl = true;
            }
            return bl;
        }

        String getStringStart() {
            return "radialGradient";
        }

        void doString(StringBuffer stringBuffer) {
            if (this.center.x != 50.0 || this.center.y != 50.0) {
                stringBuffer.append(" c(").append(BDouble.encode((double)this.center.x)).append("% ").append(BDouble.encode((double)this.center.y)).append("%)");
            }
            if (this.radius != 50.0) {
                stringBuffer.append(" r(").append(BDouble.encode((double)this.radius)).append("%)");
            }
            if (this.focal.x != this.center.x || this.focal.y != this.center.y) {
                stringBuffer.append(" f(").append(BDouble.encode((double)this.focal.x)).append("% ").append(BDouble.encode((double)this.focal.y)).append("%)");
            }
        }

        RadialGradient(Stop[] stopArray, int n, IPoint iPoint, double d, IPoint iPoint2) {
            super(stopArray, n);
            this.center = BPoint.make(iPoint);
            this.radius = d;
            this.focal = BPoint.make(iPoint2);
        }
    }

    public static class Image
    extends Paint {
        final BImage image;
        final int tile;
        final int halign;
        final int valign;
        String string;

        public BImage getImage() {
            return this.image;
        }

        public int getTile() {
            return this.tile;
        }

        public int getHalign() {
            return this.halign;
        }

        public int getValign() {
            return this.valign;
        }

        public boolean equals(Object object) {
            if (object instanceof Image) {
                Image image = (Image)object;
                boolean bl = false;
                if (this.image.equals((Object)image.image) && this.tile == image.tile && this.halign == image.halign && this.valign == image.valign) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            if (this.string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                String string = this.image.toString();
                stringBuffer.append("image( source(").append(string).append(") ");
                switch (this.tile) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        stringBuffer.append("tile(true) ");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("tile(x) ");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("tile(y) ");
                        break;
                    }
                }
                switch (this.halign) {
                    case 3: {
                        stringBuffer.append("halign(left) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        stringBuffer.append("halign(right) ");
                        break;
                    }
                }
                switch (this.valign) {
                    case 1: {
                        stringBuffer.append("valign(top) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        stringBuffer.append("valign(bottom) ");
                        break;
                    }
                }
                stringBuffer.append(")");
                this.string = stringBuffer.toString();
            }
            return this.string;
        }

        Image(BImage bImage, int n, int n2, int n3) {
            if (bImage == null) {
                throw new NullPointerException("image");
            }
            if (n != 1 && n != 0 && n != 2 && n != 3) {
                throw new IllegalArgumentException("tile");
            }
            if (n2 != 3 && n2 != 0 && n2 != 4) {
                throw new IllegalArgumentException("halign");
            }
            if (n3 != 1 && n3 != 0 && n3 != 2) {
                throw new IllegalArgumentException("valign");
            }
            this.image = bImage;
            this.tile = n;
            this.halign = n2;
            this.valign = n3;
        }
    }

    public static abstract class Paint {
        public abstract String toString();

        Paint() {
        }
    }

    public static final class Stop {
        final double offset;
        final BColor color;

        public final double getOffset() {
            return this.offset;
        }

        public final BColor getColor() {
            return this.color;
        }

        public final boolean equals(Object object) {
            if (object instanceof Stop) {
                Stop stop = (Stop)object;
                boolean bl = false;
                if (this.offset == stop.offset && this.color.equals((Object)stop.color)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public final String toString() {
            return "stop(" + BDouble.encode((double)this.offset) + "% " + (Object)((Object)this.color) + ')';
        }

        Stop(double d, BColor bColor) {
            if (bColor == null) {
                throw new NullPointerException();
            }
            this.offset = d;
            this.color = bColor;
        }
    }

    public static abstract class Gradient
    extends Paint {
        final Stop[] stops;
        final int spread;
        String string;

        public Stop[] getStops() {
            return (Stop[])this.stops.clone();
        }

        public int getSpread() {
            return this.spread;
        }

        public final boolean equals(Object object) {
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Gradient gradient = (Gradient)object;
            if (this.spread != gradient.spread) {
                return false;
            }
            if (this.stops.length != gradient.stops.length) {
                return false;
            }
            int n = 0;
            while (n < this.stops.length) {
                if (!this.stops[n].equals(gradient.stops[n])) {
                    return false;
                }
                ++n;
            }
            return this.doEquals(gradient);
        }

        abstract boolean doEquals(Gradient var1);

        public final String toString() {
            if (this.string == null) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append(this.getStringStart());
                stringBuffer.append('(');
                if (this.spread == 2) {
                    stringBuffer.append(" reflect");
                } else if (this.spread == 3) {
                    stringBuffer.append(" repeat");
                }
                this.doString(stringBuffer);
                int n = 0;
                while (n < this.stops.length) {
                    stringBuffer.append(' ').append(this.stops[n]);
                    ++n;
                }
                stringBuffer.append(" )");
                this.string = stringBuffer.toString();
            }
            return this.string;
        }

        abstract String getStringStart();

        abstract void doString(StringBuffer var1);

        Gradient(Stop[] stopArray, int n) {
            if (n != 1 && n != 2 && n != 3) {
                throw new IllegalArgumentException("spread");
            }
            this.stops = (Stop[])stopArray.clone();
            this.spread = n;
        }
    }
}

