/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import java.util.ArrayList;
import javax.baja.gx.RectGeom;

public class RectangleMap {
    private RectGeom bounds;
    private int bucketWidth;
    private int bucketHeight;
    private int xb;
    private int yb;
    private ArrayList[][] buckets;

    public void put(int n, int n2, int n3, int n4, Object object) {
        RectGeom rectGeom = new RectGeom(n, n2, n3, n4);
        int n5 = (int)rectGeom.x / this.bucketWidth;
        while ((double)n5 <= (rectGeom.x + rectGeom.width) / (double)this.bucketWidth) {
            int n6 = (int)rectGeom.y / this.bucketHeight;
            while ((double)n6 <= (rectGeom.y + rectGeom.height) / (double)this.bucketHeight) {
                if (n5 >= 0 && n5 < this.xb && n6 >= 0 && n6 < this.yb) {
                    ArrayList<Group> arrayList = this.buckets[n5][n6];
                    if (arrayList == null) {
                        this.buckets[n5][n6] = arrayList = new ArrayList<Group>();
                    }
                    arrayList.add(new Group(rectGeom, object));
                }
                ++n6;
            }
            ++n5;
        }
    }

    public Object[] get(int n, int n2) {
        if (!this.bounds.contains(n, n2)) {
            return null;
        }
        ArrayList arrayList = this.buckets[n / this.bucketWidth][n2 / this.bucketHeight];
        if (arrayList == null) {
            return null;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Group group = (Group)arrayList.get(n3);
            if (group.rect.contains(n, n2)) {
                arrayList2.add(group.obj);
            }
            ++n3;
        }
        return arrayList2.size() == 0 ? null : arrayList2.toArray(new Object[arrayList2.size()]);
    }

    public RectangleMap(int n, int n2, int n3, int n4, int n5, int n6) {
        this.bounds = new RectGeom(n, n2, n3, n4);
        this.bucketWidth = n5;
        this.bucketHeight = n6;
        this.xb = (int)this.bounds.width / n5 + 1;
        this.yb = (int)this.bounds.height / n6 + 1;
        this.buckets = new ArrayList[this.xb][this.yb];
    }

    private static class Group {
        private RectGeom rect;
        private Object obj;

        private Group(RectGeom rectGeom, Object object) {
            this.rect = rectGeom;
            this.obj = object;
        }
    }
}

