/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;

public abstract class GeomUtil {
    public static final double NEAR = 3.0;

    public static int nearest(Point point, Point[] pointArray, boolean bl) {
        double d;
        double d2 = GeomUtil.dist(point, pointArray[0], pointArray[1]);
        int n = 0;
        int n2 = 1;
        while (n2 < pointArray.length - 1) {
            double d3 = GeomUtil.dist(point, pointArray[n2], pointArray[n2 + 1]);
            if (d3 < d2) {
                d2 = d3;
                n = n2;
            }
            ++n2;
        }
        if (bl && (d = GeomUtil.dist(point, pointArray[pointArray.length - 1], pointArray[0])) < d2) {
            d2 = d;
            n = pointArray.length - 1;
        }
        return n;
    }

    public static double dist(Point point, Point[] pointArray) {
        double d = GeomUtil.dist(point, pointArray[0], pointArray[1]);
        int n = 1;
        while (n < pointArray.length - 1) {
            d = Math.min(d, GeomUtil.dist(point, pointArray[n], pointArray[n + 1]));
            ++n;
        }
        return d;
    }

    public static double dist(Point point, Point point2, Point point3) {
        double d;
        if (point2.equals(point3)) {
            d = GeomUtil.dist(point, point2);
        } else if (point2.y == point3.y) {
            double d2 = Math.min(point2.x, point3.x);
            double d3 = Math.max(point2.x, point3.x);
            d = point.x < d2 || point.x > d3 ? Math.min(GeomUtil.dist(point, point2), GeomUtil.dist(point, point3)) : Math.abs(point.y - point2.y);
        } else if (point2.x == point3.x) {
            double d4 = Math.min(point2.y, point3.y);
            double d5 = Math.max(point2.y, point3.y);
            d = point.y < d4 || point.y > d5 ? Math.min(GeomUtil.dist(point, point2), GeomUtil.dist(point, point3)) : Math.abs(point.x - point2.x);
        } else {
            Point point4 = GeomUtil.getFoot(point, point2, point3);
            double d6 = Math.min(point2.x, point3.x);
            double d7 = Math.max(point2.x, point3.x);
            d = point4.x >= d6 && point4.x <= d7 ? GeomUtil.dist(point, point4) : Math.min(GeomUtil.dist(point, point2), GeomUtil.dist(point, point3));
        }
        return d;
    }

    public static double dist(Point point, Point point2) {
        return Math.sqrt(Math.pow(point.x - point2.x, 2) + Math.pow(point.y - point2.y, 2));
    }

    public static RectGeom makeRectangle(double d, double d2, double d3, double d4) {
        double d5 = Math.min(d, d3);
        double d6 = Math.min(d2, d4);
        double d7 = Math.max(d, d3);
        double d8 = Math.max(d2, d4);
        return new RectGeom(d5, d6, d7 - d5, d8 - d6);
    }

    public static boolean contains(IRectGeom iRectGeom, IRectGeom iRectGeom2) {
        if (GeomUtil.isDegenerate(iRectGeom)) {
            return false;
        }
        if (GeomUtil.isDegenerate(iRectGeom2)) {
            boolean bl = false;
            if (iRectGeom.contains(iRectGeom2.x(), iRectGeom2.y()) && iRectGeom.contains(iRectGeom2.x() + iRectGeom2.width(), iRectGeom2.y() + iRectGeom2.height())) {
                bl = true;
            }
            return bl;
        }
        return iRectGeom.contains(iRectGeom2);
    }

    private static final boolean isDegenerate(IRectGeom iRectGeom) {
        boolean bl = false;
        if (iRectGeom.width() == 0.0 || iRectGeom.height() == 0.0) {
            bl = true;
        }
        return bl;
    }

    private static final Point getFoot(Point point, Point point2, Point point3) {
        if (point2.equals(point3)) {
            throw new IllegalArgumentException();
        }
        if (point2.y == point3.y) {
            return new Point(point.x, point2.y);
        }
        if (point2.x == point3.x) {
            return new Point(point2.x, point.y);
        }
        double d = (point2.y - point3.y) / (point2.x - point3.x);
        double d2 = point2.y - d * point2.x;
        double d3 = (d * point.y + point.x - d * d2) / (d * d + 1.0);
        double d4 = (d * d * point.y + d * point.x + d2) / (d * d + 1.0);
        return new Point(d3, d4);
    }
}

