/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import javax.baja.gx.BColor;

public class ColorUtil {
    public static double[] toHsb(BColor bColor) {
        double d = (float)bColor.getRed() / 255.0f;
        double d2 = (float)bColor.getGreen() / 255.0f;
        double d3 = (float)bColor.getBlue() / 255.0f;
        double d4 = Math.max(d, Math.max(d2, d3));
        double d5 = Math.min(d, Math.min(d2, d3));
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d4;
        d7 = d4 != 0.0 ? (d4 - d5) / d4 : 0.0;
        if (d7 == 0.0) {
            d6 = 0.0;
        } else {
            double d9 = d4 - d5;
            if (d == d4) {
                d6 = (d2 - d3) / d9;
            } else if (d2 == d4) {
                d6 = (double)2 + (d3 - d) / d9;
            } else if (d3 == d4) {
                d6 = (double)4 + (d - d2) / d9;
            }
            d6 *= 60.0;
            if (d6 < 0.0) {
                d6 += 360.0;
            }
        }
        return new double[]{d6, d7, d8};
    }

    public static BColor toRgb(double[] dArray) {
        int n;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d2 == 0.0) {
            d4 = d3;
            d5 = d3;
            d6 = d3;
        } else {
            if (d == 360.0) {
                d = 0.0;
            }
            n = (int)Math.floor(d /= 60.0);
            double d7 = d - (double)n;
            double d8 = d3 * (1.0 - d2);
            double d9 = d3 * (1.0 - d2 * d7);
            double d10 = d3 * (1.0 - d2 * (1.0 - d7));
            switch (n) {
                case 0: {
                    d4 = d3;
                    d5 = d10;
                    d6 = d8;
                    break;
                }
                case 1: {
                    d4 = d9;
                    d5 = d3;
                    d6 = d8;
                    break;
                }
                case 2: {
                    d4 = d8;
                    d5 = d3;
                    d6 = d10;
                    break;
                }
                case 3: {
                    d4 = d8;
                    d5 = d9;
                    d6 = d3;
                    break;
                }
                case 4: {
                    d4 = d10;
                    d5 = d8;
                    d6 = d3;
                    break;
                }
                case 5: {
                    d4 = d3;
                    d5 = d8;
                    d6 = d9;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid value: " + n);
                }
            }
        }
        n = (int)(d4 * 255.0);
        int n2 = (int)(d5 * 255.0);
        int n3 = (int)(d6 * 255.0);
        return BColor.make(n, n2, n3);
    }
}

