/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.parser;

import com.tridium.gx.parser.ParseException;
import com.tridium.gx.parser.Token;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;

public class Tokenizer {
    static final byte[] ctypes = new byte[128];
    static final int IDCHAR = 1;
    static final int IDSTART = 3;
    static final int NUMBER = 4;
    static final int HEX = 8;
    static final int SPACE = 16;
    private String buf;
    private int pos;
    private int len;
    private int cur;
    private int curType;
    private int peek;
    private int peekType;
    private boolean pathGeom;

    public Token next(Token token) {
        token.pos = this.pos - 1;
        while (true) {
            if (this.cur < 0) {
                return token.set(22);
            }
            if ((this.curType & 0x10) == 0) break;
            this.read();
        }
        boolean bl = false;
        if (this.cur == 45 && (this.peekType & 4) != 0) {
            this.read();
            bl = true;
        }
        if ((this.curType & 4) != 0) {
            return this.parseNumber(token, bl);
        }
        if ((this.curType & 3) != 0) {
            return this.parseId(token);
        }
        if (this.cur == 35) {
            return this.parseHash(token);
        }
        if (this.cur == 34 || this.cur == 39) {
            return this.parseString(token);
        }
        return this.parseSymbol(token);
    }

    Token parseId(Token token) {
        if (this.pathGeom) {
            token.set(21);
            token.pathcmd = this.cur;
            this.read();
            return token;
        }
        token.set(15);
        token.str = this.parseIdStr();
        if (this.cur == 40) {
            this.read();
            token.type = 18;
        }
        return token;
    }

    Token parseHash(Token token) {
        token.set(17);
        this.read();
        token.str = (this.curType & 1) != 0 ? this.parseIdStr() : "";
        return token;
    }

    String parseIdStr() {
        StringBuffer stringBuffer = new StringBuffer(32);
        do {
            stringBuffer.append(TextUtil.toLowerCase((char)((char)this.cur)));
            this.read();
        } while ((this.curType & 1) != 0);
        return stringBuffer.toString();
    }

    Token parseNumber(Token token, boolean bl) {
        token.set(19);
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append((char)this.cur);
        while (true) {
            this.read();
            if (this.cur != 46 && (this.curType & 4) == 0) {
                if (this.cur != 101 && this.cur != 69) break;
                stringBuffer.append((char)this.cur);
                this.parseExponent(stringBuffer);
                break;
            }
            stringBuffer.append((char)this.cur);
        }
        double d = BDouble.decode((String)stringBuffer.toString());
        if (bl) {
            d = -d;
        }
        token.num = d;
        if (this.pathGeom) {
            return token;
        }
        if (this.cur == 37) {
            this.read();
            token.type = 20;
            token.str = "%";
        } else if ((this.curType & 3) != 0) {
            token.type = 20;
            token.str = this.parseIdStr();
        }
        return token;
    }

    private final void parseExponent(StringBuffer stringBuffer) {
        if (this.peek == 43 || this.peek == 45) {
            this.read();
            stringBuffer.append((char)this.cur);
        }
        if ((this.peekType & 4) == 0) {
            this.error("exponent " + (char)this.cur);
        }
        this.read();
        while ((this.curType & 4) != 0) {
            stringBuffer.append((char)this.cur);
            this.read();
        }
    }

    Token parseString(Token token) {
        StringBuffer stringBuffer;
        block3: {
            token.set(16);
            int n = this.cur;
            if (n != 34 && n != 39) {
                throw this.error("string " + (char)n);
            }
            this.read();
            stringBuffer = new StringBuffer(32);
            while (true) {
                int n2 = this.cur;
                if (this.cur == n) break block3;
                if (this.cur == 92) {
                    this.unescape(stringBuffer);
                    continue;
                }
                stringBuffer.append((char)n2);
                this.read();
                if (this.cur == -1) break;
            }
            throw this.error("String literal not terminated");
        }
        this.read();
        token.str = stringBuffer.toString();
        return token;
    }

    void unescape(StringBuffer stringBuffer) {
        if (this.cur != 92) {
            throw this.error("IllegalState");
        }
        this.read();
        if (this.cur == 110) {
            this.read();
            stringBuffer.append('\n');
            return;
        }
        if (this.cur == 39) {
            this.read();
            stringBuffer.append('\'');
            return;
        }
        if (this.cur == 34) {
            this.read();
            stringBuffer.append('\"');
            return;
        }
        if ((this.curType & 8) == 0) {
            throw this.error("Invalid escape sequence");
        }
        int n = 0;
        while (true) {
            if (this.cur == 59) break;
            if ((this.curType & 8) == 0) {
                throw this.error("Unterminated escape sequence");
            }
            n = n << 4 | TextUtil.hexCharToInt((char)((char)this.cur));
            this.read();
        }
        this.read();
        stringBuffer.append((char)n);
    }

    Token parseSymbol(Token token) {
        int n = this.cur;
        this.read();
        switch (n) {
            case 46: {
                return token.set(1);
            }
            case 44: {
                return token.set(2);
            }
            case 59: {
                return token.set(3);
            }
            case 58: {
                return token.set(4);
            }
            case 40: {
                return token.set(7);
            }
            case 41: {
                return token.set(8);
            }
            case 123: {
                return token.set(5);
            }
            case 125: {
                return token.set(6);
            }
            case 91: {
                return token.set(9);
            }
            case 93: {
                return token.set(10);
            }
            case 47: {
                return token.set(11);
            }
            case 42: {
                return token.set(12);
            }
            case 43: {
                return token.set(13);
            }
            case 61: {
                return token.set(14);
            }
            case 35: {
                return token.set(17);
            }
        }
        token.set(0);
        token.str = String.valueOf((char)n);
        return token;
    }

    ParseException error(String string) {
        return new ParseException(string);
    }

    void initRead(String string, int n) {
        this.buf = string;
        this.pos = n;
        this.len = string.length();
        try {
            this.cur = string.charAt(this.pos++);
        }
        catch (Exception exception) {
            this.cur = -1;
        }
        this.curType = Tokenizer.ctype(this.cur);
        try {
            this.peek = string.charAt(this.pos++);
        }
        catch (Exception exception) {
            this.peek = -1;
        }
        this.peekType = Tokenizer.ctype(this.peek);
    }

    char charAt(int n) {
        return this.buf.charAt(n);
    }

    void read() {
        this.cur = this.peek;
        this.curType = this.peekType;
        this.peek = this.pos >= this.len ? -1 : (int)this.buf.charAt(this.pos++);
        this.peekType = Tokenizer.ctype(this.peek);
    }

    String eat(int n) {
        this.pos = this.buf.length();
        this.peek = -1;
        this.cur = -1;
        return this.buf.substring(n);
    }

    String eatToRParen(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.initRead(this.buf, n - 1);
        int n2 = 0;
        while (this.cur > 0) {
            if (this.cur == 40) {
                ++n2;
            }
            if (this.cur == 41) {
                if (n2 == 0) break;
                --n2;
            }
            stringBuffer.append((char)this.cur);
            this.read();
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Tokenizer tokenizer = new Tokenizer(stringArray[0], false);
        Token token = new Token();
        while (tokenizer.next((Token)token).type != 22) {
            System.out.println(token);
        }
    }

    static int ctype(int n) {
        if (n < 0) {
            return 0;
        }
        if (n < 128) {
            return ctypes[n];
        }
        return 1;
    }

    public Tokenizer(String string, boolean bl) {
        this.pathGeom = bl;
        this.initRead(string, 0);
    }

    static {
        int n = 97;
        while (n <= 122) {
            Tokenizer.ctypes[n] = 3;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            Tokenizer.ctypes[n] = 3;
            ++n;
        }
        n = 48;
        while (n <= 57) {
            Tokenizer.ctypes[n] = 13;
            ++n;
        }
        n = 97;
        while (n <= 102) {
            int n2 = n++;
            ctypes[n2] = (byte)(ctypes[n2] | 8);
        }
        n = 65;
        while (n <= 70) {
            int n3 = n++;
            ctypes[n3] = (byte)(ctypes[n3] | 8);
        }
        Tokenizer.ctypes[32] = 16;
        Tokenizer.ctypes[10] = 16;
        Tokenizer.ctypes[13] = 16;
        Tokenizer.ctypes[9] = 16;
        Tokenizer.ctypes[12] = 16;
    }
}

