/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.parser;

import com.tridium.gx.parser.ParseException;
import com.tridium.gx.parser.Token;
import com.tridium.gx.parser.Tokenizer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BEllipseGeom;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BLineGeom;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.BPoint;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.BTransform;
import javax.baja.gx.IPathGeom;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Parser {
    public Token cur;
    public Token peek;
    Tokenizer tokenizer;
    static /* synthetic */ Class class$javax$baja$gx$IPathGeom$Segment;
    static /* synthetic */ Class class$javax$baja$gx$BBrush$Stop;
    static /* synthetic */ Class class$javax$baja$gx$BTransform$Transform;
    static /* synthetic */ Class class$com$tridium$gx$parser$Token;

    public BLineGeom parseLine() {
        if (this.cur.id("null")) {
            this.consume();
            return BLineGeom.NULL;
        }
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        return BLineGeom.make(d, d2, d3, d4);
    }

    public BRectGeom parseRect() {
        if (this.cur.id("null")) {
            this.consume();
            return BRectGeom.NULL;
        }
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        return BRectGeom.make(d, d2, d3, d4);
    }

    public BEllipseGeom parseEllipse() {
        if (this.cur.id("null")) {
            this.consume();
            return BEllipseGeom.NULL;
        }
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        return BEllipseGeom.make(d, d2, d3, d4);
    }

    public BPolygonGeom parsePolygon() {
        if (this.cur.id("null")) {
            this.consume();
            return BPolygonGeom.NULL;
        }
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        int n = 0;
        while (!this.isEnd()) {
            if (n >= dArray.length) {
                dArray = Parser.grow(dArray);
                dArray2 = Parser.grow(dArray2);
            }
            dArray[n] = this.matchNum();
            this.ignoreComma();
            dArray2[n] = this.matchNum();
            this.ignoreComma();
            if (this.cur.type == 3) {
                this.consume();
            }
            ++n;
        }
        return BPolygonGeom.make(dArray, dArray2, n);
    }

    private static final double[] grow(double[] dArray) {
        double[] dArray2 = new double[dArray.length * 2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public BPathGeom parsePath() {
        Class clazz = class$javax$baja$gx$IPathGeom$Segment;
        if (clazz == null) {
            clazz = class$javax$baja$gx$IPathGeom$Segment = Parser.class("[Ljavax.baja.gx.IPathGeom$Segment;", false);
        }
        Array array = new Array(clazz);
        int n = 63;
        while (!this.isEnd()) {
            if (this.cur.type == 21) {
                n = this.cur.pathcmd;
                this.consume();
                if (n != 90 && n != 122) continue;
                array.add((Object)new IPathGeom.ClosePath());
                continue;
            }
            IPathGeom.Segment segment = null;
            switch (n) {
                case 77: {
                    segment = this.parseMoveTo(true);
                    break;
                }
                case 109: {
                    segment = this.parseMoveTo(false);
                    break;
                }
                case 76: {
                    segment = this.parseLineTo(true);
                    break;
                }
                case 108: {
                    segment = this.parseLineTo(false);
                    break;
                }
                case 72: {
                    segment = this.parseHLineTo(true);
                    break;
                }
                case 104: {
                    segment = this.parseHLineTo(false);
                    break;
                }
                case 86: {
                    segment = this.parseVLineTo(true);
                    break;
                }
                case 118: {
                    segment = this.parseVLineTo(false);
                    break;
                }
                case 67: {
                    segment = this.parseCurveTo(true);
                    break;
                }
                case 99: {
                    segment = this.parseCurveTo(false);
                    break;
                }
                case 83: {
                    segment = this.parseSmoothCurveTo(true);
                    break;
                }
                case 115: {
                    segment = this.parseSmoothCurveTo(false);
                    break;
                }
                case 81: {
                    segment = this.parseQuadTo(true);
                    break;
                }
                case 113: {
                    segment = this.parseQuadTo(false);
                    break;
                }
                case 84: {
                    segment = this.parseSmoothQuadTo(true);
                    break;
                }
                case 116: {
                    segment = this.parseSmoothQuadTo(false);
                    break;
                }
                case 65: {
                    segment = this.parseArcTo(true);
                    break;
                }
                case 97: {
                    segment = this.parseArcTo(false);
                    break;
                }
                default: {
                    throw new ParseException("Unknown comand " + (char)n);
                }
            }
            array.add((Object)segment);
        }
        return BPathGeom.make((IPathGeom.Segment[])array.trim());
    }

    IPathGeom.MoveTo parseMoveTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        return new IPathGeom.MoveTo(bl, d, d2);
    }

    IPathGeom.LineTo parseLineTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        return new IPathGeom.LineTo(bl, d, d2);
    }

    IPathGeom.HLineTo parseHLineTo(boolean bl) {
        double d = this.matchNum();
        return new IPathGeom.HLineTo(bl, d);
    }

    IPathGeom.VLineTo parseVLineTo(boolean bl) {
        double d = this.matchNum();
        return new IPathGeom.VLineTo(bl, d);
    }

    IPathGeom.CurveTo parseCurveTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        this.ignoreComma();
        double d5 = this.matchNum();
        this.ignoreComma();
        double d6 = this.matchNum();
        this.ignoreComma();
        return new IPathGeom.CurveTo(bl, d, d2, d3, d4, d5, d6);
    }

    IPathGeom.SmoothCurveTo parseSmoothCurveTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        this.ignoreComma();
        return new IPathGeom.SmoothCurveTo(bl, d, d2, d3, d4);
    }

    IPathGeom.QuadTo parseQuadTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        double d4 = this.matchNum();
        this.ignoreComma();
        return new IPathGeom.QuadTo(bl, d, d2, d3, d4);
    }

    IPathGeom.SmoothQuadTo parseSmoothQuadTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        return new IPathGeom.SmoothQuadTo(bl, d, d2);
    }

    IPathGeom.ArcTo parseArcTo(boolean bl) {
        double d = this.matchNum();
        this.ignoreComma();
        double d2 = this.matchNum();
        this.ignoreComma();
        double d3 = this.matchNum();
        this.ignoreComma();
        boolean bl2 = this.matchArcFlag();
        this.ignoreComma();
        boolean bl3 = this.matchArcFlag();
        this.ignoreComma();
        double d4 = this.matchNum();
        this.ignoreComma();
        double d5 = this.matchNum();
        this.ignoreComma();
        return new IPathGeom.ArcTo(bl, d, d2, d3, bl2, bl3, d4, d5);
    }

    boolean matchArcFlag() {
        double d = this.matchNum();
        if (d == 0.0) {
            return false;
        }
        if (d == 1.0) {
            return true;
        }
        throw new ParseException("Invalid arc flag " + d);
    }

    /*
     * Unable to fully structure code
     */
    public BColor parseColor() {
        block13: {
            var1_1 = this.cur;
            var2_2 = var1_1.str;
            if (var1_1.type != 17) ** GOTO lbl21
            if (var2_2.length() == 3) {
                var3_3 = TextUtil.hexCharToInt((char)var2_2.charAt(0));
                var4_8 = TextUtil.hexCharToInt((char)var2_2.charAt(1));
                var5_11 = TextUtil.hexCharToInt((char)var2_2.charAt(2));
                this.consume();
                return BColor.make(var3_3 << 20 | var3_3 << 16 | var4_8 << 12 | var4_8 << 8 | var5_11 << 4 | var5_11, false);
            }
            if (var2_2.length() == 6) {
                var3_4 = Integer.parseInt(var2_2, 16);
                this.consume();
                return BColor.make(var3_4, false);
            }
            if (var2_2.length() == 8) {
                var3_5 = (int)(0xFFFFFFFFL & Long.parseLong(var2_2, 16));
                this.consume();
                return BColor.make(var3_5, true);
            }
            try {
                break block13;
lbl21:
                // 1 sources

                if (var1_1.type == 15) {
                    var3_6 = BColor.getConstant(var1_1.str);
                    if (var3_6 != null) {
                        this.consume();
                    }
                    return var3_6;
                }
                if (var1_1.type == 18) {
                    var3_7 = var1_1.str;
                    if (var3_7.equals("rgb")) {
                        var4_9 = this.parseFunctionParams();
                        if (var4_9.length != 3) {
                            throw new Exception();
                        }
                        var5_12 = this.rgbnum(var4_9[0]);
                        var6_14 = this.rgbnum(var4_9[1]);
                        var7_16 = this.rgbnum(var4_9[2]);
                        return BColor.make(var5_12 << 16 | var6_14 << 8 | var7_16, false);
                    }
                    if (var3_7.equals("rgba")) {
                        var4_10 = this.parseFunctionParams();
                        if (var4_10.length != 4) {
                            throw new Exception();
                        }
                        var5_13 = this.rgbnum(var4_10[0]);
                        var6_15 = this.rgbnum(var4_10[1]);
                        var7_17 = this.rgbnum(var4_10[2]);
                        var8_18 = this.alpha(var4_10[3]);
                        return BColor.make(var8_18 << 24 | var5_13 << 16 | var6_15 << 8 | var7_17, true);
                    }
                }
            }
            catch (Exception v0) {}
        }
        return null;
    }

    public BColor matchColor() {
        BColor bColor = this.parseColor();
        if (bColor == null) {
            throw new ParseException("Expecting color");
        }
        return bColor;
    }

    public int rgbnum(Token token) {
        int n = 0;
        switch (token.type) {
            case 19: {
                n = (int)token.num;
                break;
            }
            case 20: {
                if (token.str.equals("%")) {
                    n = (int)(255.0 * token.num / 100.0);
                    break;
                }
            }
            default: {
                throw new RuntimeException(token.toString());
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    public int alpha(Token token) {
        if (token.type != 19) {
            throw new RuntimeException();
        }
        double d = token.num;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return (int)(255.0 * d);
    }

    public BFont parseFont() {
        if (this.cur.id("null")) {
            this.eat();
            return BFont.NULL;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (this.cur.id("bold")) {
                this.consume();
                n |= 1;
            } else if (this.cur.id("italic")) {
                this.consume();
                n |= 2;
            } else if (this.cur.id("underline")) {
                this.consume();
                n |= 4;
            }
            ++n2;
        }
        if (!this.cur.dimen("pt")) {
            throw this.error("Expecting {size}pt");
        }
        double d = this.cur.num;
        this.consume();
        String string = this.eat();
        return BFont.make(string, d, n);
    }

    public BBrush parseBrush() {
        BColor bColor = this.parseColor();
        if (bColor != null) {
            return BBrush.makeSolid(bColor);
        }
        if (this.cur.type == 18) {
            String string = this.cur.str;
            this.match(18);
            if (string.equals("lineargradient")) {
                return this.parseLinearGradient();
            }
            if (string.equals("radialgradient")) {
                return this.parseRadialGradient();
            }
            if (string.equals("image")) {
                return this.parseImage();
            }
            if (string.equals("inverse")) {
                return this.parseInverse();
            }
            throw new ParseException("Unknown brush " + string);
        }
        return null;
    }

    BBrush parseInverse() {
        BColor bColor = this.matchColor();
        this.match(8);
        return BBrush.makeInverse(bColor);
    }

    BBrush parseImage() {
        BImage bImage = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (this.cur.type != 8) {
            if (this.cur.function("source")) {
                this.match(18);
                if (this.cur.type == 16) {
                    bImage = BImage.make(this.cur.str);
                    this.consume();
                } else {
                    bImage = BImage.make(this.eatToRParen());
                }
                this.match(8);
                continue;
            }
            if (this.cur.function("tile")) {
                n = this.parseImageTile();
                continue;
            }
            if (this.cur.function("halign")) {
                n2 = this.parseImageHalign();
                continue;
            }
            if (this.cur.function("valign")) {
                n3 = this.parseImageValign();
                continue;
            }
            this.skipBrushArg();
        }
        this.consume();
        return BBrush.makeImage(bImage, n, n2, n3);
    }

    int parseImageTile() {
        int n = 0;
        this.match(18);
        String string = this.matchId();
        if (string.equals("true")) {
            n = 1;
        } else if (string.equals("x")) {
            n = 2;
        } else if (string.equals("y")) {
            n = 3;
        }
        this.match(8);
        return n;
    }

    int parseImageHalign() {
        int n = 0;
        this.match(18);
        String string = this.matchId();
        if (string.equals("left")) {
            n = 3;
        } else if (string.equals("right")) {
            n = 4;
        }
        this.match(8);
        return n;
    }

    int parseImageValign() {
        int n = 0;
        this.match(18);
        String string = this.matchId();
        if (string.equals("top")) {
            n = 1;
        } else if (string.equals("bottom")) {
            n = 2;
        }
        this.match(8);
        return n;
    }

    BBrush parseLinearGradient() {
        Class clazz = class$javax$baja$gx$BBrush$Stop;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BBrush$Stop = Parser.class("[Ljavax.baja.gx.BBrush$Stop;", false);
        }
        Array array = new Array(clazz);
        int n = 1;
        double d = 0.0;
        while (this.cur.type != 8) {
            if (this.cur.function("stop")) {
                array.add((Object)this.parseGradientStop());
                continue;
            }
            if (this.cur.function("angle")) {
                d = this.parseGradientAngle();
                continue;
            }
            if (this.cur.id("pad")) {
                n = 1;
                this.consume();
                continue;
            }
            if (this.cur.id("reflect")) {
                n = 2;
                this.consume();
                continue;
            }
            if (this.cur.id("repeat")) {
                n = 3;
                this.consume();
                continue;
            }
            this.skipBrushArg();
        }
        this.consume();
        return BBrush.makeLinearGradient((BBrush.Stop[])array.trim(), n, d);
    }

    BBrush parseRadialGradient() {
        Class clazz = class$javax$baja$gx$BBrush$Stop;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BBrush$Stop = Parser.class("[Ljavax.baja.gx.BBrush$Stop;", false);
        }
        Array array = new Array(clazz);
        int n = 1;
        BPoint bPoint = BPoint.make(50.0, 50.0);
        double d = 50.0;
        BPoint bPoint2 = null;
        while (this.cur.type != 8) {
            if (this.cur.function("stop")) {
                array.add((Object)this.parseGradientStop());
                continue;
            }
            if (this.cur.function("c")) {
                bPoint = this.parseGradientPoint();
                continue;
            }
            if (this.cur.function("r")) {
                d = this.parseGradientOffset();
                continue;
            }
            if (this.cur.function("f")) {
                bPoint2 = this.parseGradientPoint();
                continue;
            }
            if (this.cur.id("pad")) {
                n = 1;
                this.consume();
                continue;
            }
            if (this.cur.id("reflect")) {
                n = 2;
                this.consume();
                continue;
            }
            if (this.cur.id("repeat")) {
                n = 3;
                this.consume();
                continue;
            }
            this.skipBrushArg();
        }
        this.consume();
        if (bPoint2 == null) {
            bPoint2 = bPoint;
        }
        return BBrush.makeRadialGradient((BBrush.Stop[])array.trim(), n, bPoint, d, bPoint2);
    }

    BBrush.Stop parseGradientStop() {
        this.match(18);
        double d = this.matchDimen("%");
        this.ignoreComma();
        BColor bColor = this.matchColor();
        this.match(8);
        return BBrush.stop(d, bColor);
    }

    double parseGradientAngle() {
        this.match(18);
        double d = this.matchNum();
        this.match(8);
        return d;
    }

    double parseGradientOffset() {
        this.match(18);
        double d = this.matchDimen("%");
        this.match(8);
        return d;
    }

    BPoint parseGradientPoint() {
        this.match(18);
        double d = this.matchDimen("%");
        this.ignoreComma();
        double d2 = this.matchDimen("%");
        this.match(8);
        return BPoint.make(d, d2);
    }

    void skipBrushArg() {
        block3: {
            if (this.cur.type == 15) {
                this.consume();
                return;
            }
            if (this.cur.type == 18) {
                do {
                    this.consume();
                    if (this.cur.type == 22) break block3;
                } while (this.cur.type != 8);
                this.consume();
                return;
            }
        }
        throw new ParseException("Unexpected " + this.cur);
    }

    public BPen parsePen() {
        double d = 1.0;
        int n = 101;
        int n2 = 201;
        double[] dArray = null;
        while (!this.isEnd()) {
            String string;
            if (this.cur.type == 19) {
                d = this.cur.num;
                this.consume();
                continue;
            }
            if (this.cur.type == 15) {
                string = this.cur.str;
                if (string.equals("capbutt")) {
                    n = 101;
                } else if (string.equals("capsquare")) {
                    n = 102;
                } else if (string.equals("capround")) {
                    n = 103;
                } else if (string.equals("joinmiter")) {
                    n2 = 201;
                } else if (string.equals("joinround")) {
                    n2 = 202;
                } else if (string.equals("joinbevel")) {
                    n2 = 203;
                }
                this.consume();
                continue;
            }
            if (this.cur.type == 18) {
                string = this.cur.str;
                this.match(18);
                if (string.equals("dash")) {
                    dArray = this.parseDash();
                    continue;
                }
                throw new ParseException("Unexpected function " + string);
            }
            if (this.cur.type == 2) {
                this.consume();
                continue;
            }
            throw new ParseException("Unexpected " + this.cur);
        }
        return BPen.make(d, n, n2, dArray);
    }

    double[] parseDash() {
        double[] dArray = new double[100];
        int n = 0;
        while (this.cur.type != 8) {
            dArray[n++] = this.matchNum();
            this.ignoreComma();
        }
        this.consume();
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public BTransform parseTransform() {
        Class clazz = class$javax$baja$gx$BTransform$Transform;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BTransform$Transform = Parser.class("[Ljavax.baja.gx.BTransform$Transform;", false);
        }
        Array array = new Array(clazz);
        while (!this.isEnd()) {
            this.verify(18);
            String string = this.cur.str;
            this.consume();
            if (string.equals("translate")) {
                array.add((Object)this.parseTranslate());
                continue;
            }
            if (string.equals("scale")) {
                array.add((Object)this.parseScale());
                continue;
            }
            if (string.equals("rotate")) {
                array.add((Object)this.parseRotate());
                continue;
            }
            if (string.equals("skewx")) {
                array.add((Object)this.parseSkewX());
                continue;
            }
            if (string.equals("skewy")) {
                array.add((Object)this.parseSkewY());
                continue;
            }
            throw new ParseException("Unknown transform " + string);
        }
        return BTransform.make((BTransform.Transform[])array.trim());
    }

    BTransform.Translate parseTranslate() {
        double d = this.matchNum();
        double d2 = 0.0;
        this.ignoreComma();
        if (this.cur.type == 19) {
            d2 = this.matchNum();
        }
        this.match(8);
        return new BTransform.Translate(d, d2);
    }

    BTransform.Scale parseScale() {
        double d = this.matchNum();
        double d2 = 0.0;
        this.ignoreComma();
        if (this.cur.type == 19) {
            d2 = this.matchNum();
        }
        this.match(8);
        return new BTransform.Scale(d, d2);
    }

    BTransform.Rotate parseRotate() {
        double d = this.matchNum();
        this.match(8);
        return new BTransform.Rotate(d);
    }

    BTransform.SkewX parseSkewX() {
        double d = this.matchNum();
        this.match(8);
        return new BTransform.SkewX(d);
    }

    BTransform.SkewY parseSkewY() {
        double d = this.matchNum();
        this.match(8);
        return new BTransform.SkewY(d);
    }

    public BInsets parseInsets() {
        if (this.cur.type == 15 && this.cur.str.equals("null")) {
            this.consume();
            return BInsets.NULL;
        }
        double d = this.matchNum();
        if (this.cur.type == 19) {
            double d2 = this.matchNum();
            if (this.cur.type == 19) {
                double d3 = this.matchNum();
                if (this.cur.type == 19) {
                    double d4 = this.matchNum();
                    return BInsets.make(d, d2, d3, d4);
                }
                return BInsets.make(d, d2, d3, d2);
            }
            return BInsets.make(d, d2, d, d2);
        }
        return BInsets.make(d, d, d, d);
    }

    public Token[] parseFunctionParams() {
        this.match(18);
        if (this.cur.type == 7) {
            this.consume();
            return new Token[0];
        }
        Class clazz = class$com$tridium$gx$parser$Token;
        if (clazz == null) {
            clazz = class$com$tridium$gx$parser$Token = Parser.class("[Lcom.tridium.gx.parser.Token;", false);
        }
        Array array = new Array(clazz);
        while (true) {
            if (this.cur.type == 22) {
                throw this.error("Unmatched )");
            }
            array.add((Object)this.cur.copy());
            this.consume();
            if (this.cur.type == 8) break;
            if (this.cur.type != 2) {
                throw this.error("Expected , not " + this.cur);
            }
            this.consume();
        }
        this.consume();
        return (Token[])array.trim();
    }

    public boolean isEnd() {
        boolean bl = false;
        if (this.cur.type == 22) {
            bl = true;
        }
        return bl;
    }

    public String eat() {
        String string = this.tokenizer.eat(this.cur.pos);
        this.cur.set(22);
        this.peek.set(22);
        return string;
    }

    public String eatToRParen() {
        String string = this.tokenizer.eatToRParen(this.cur.pos);
        this.initConsume();
        return string;
    }

    void initConsume() {
        this.tokenizer.next(this.cur);
        this.tokenizer.next(this.peek);
    }

    public void consume() {
        this.cur.copy(this.peek);
        this.tokenizer.next(this.peek);
    }

    public void match(int n) {
        this.verify(n);
        this.consume();
    }

    public String matchId() {
        String string = this.cur.str;
        this.match(15);
        return string;
    }

    public double matchNum() {
        double d = this.cur.num;
        this.match(19);
        return d;
    }

    public double matchDimen(String string) {
        this.verify(20);
        if (!this.cur.str.equals(string)) {
            throw new ParseException("Expecting " + string + " dimension");
        }
        double d = this.cur.num;
        this.consume();
        return d;
    }

    public void ignoreComma() {
        if (this.cur.type == 2) {
            this.consume();
        }
    }

    public void verify(int n) {
        if (this.cur.type != n) {
            throw this.error("Expecting \"" + Token.TYPES[n] + '\"');
        }
    }

    public ParseException error(String string) {
        return new ParseException(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cur = new Token();
        this.peek = new Token();
    }

    public Parser(String string) {
        this(string, false);
    }

    public Parser(String string, boolean bl) {
        this.this();
        this.tokenizer = new Tokenizer(string, bl);
        this.initConsume();
    }
}

