/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.baja.sys.Sys;

public class MicroFontWriter {
    boolean verbose = false;
    boolean moreVerbose = false;
    Font[] defaultFonts = new Font[]{new Font("Arial", 0, 16), new Font("Arial", 1, 16), new Font("Arial", 2, 16), new Font("Arial", 3, 16), new Font("Courier New", 0, 12), new Font("Courier New", 1, 12), new Font("Courier New", 2, 12), new Font("Courier New", 3, 12), new Font("Tahoma", 0, 11), new Font("Tahoma", 1, 11), new Font("Tahoma", 2, 11), new Font("Tahoma", 3, 11)};
    Font[] asianFonts = new Font[]{new Font("Arial Unicode MS", 0, 12), new Font("NSimSun", 0, 12), new Font("MS Mincho", 0, 12), new Font("GulimChe", 0, 12), new Font("Gulim", 0, 12)};
    String[] asianPdfFontNames = new String[]{"STSong-Light", "STSong-Light", "KozMinPro-Regular", "HYGoThic-Medium", "HYGoThic-Medium"};

    public void run() {
        System.out.println("------------------------");
        System.out.println("  MicroFontWriter 3000  ");
        System.out.println("------------------------");
        this.generateFontFiles(this.defaultFonts, false);
        this.generateFontFiles(this.asianFonts, true);
    }

    private void generateFontFiles(Font[] fontArray, boolean bl) {
        for (int i = 0; i < fontArray.length; ++i) {
            try {
                System.out.println("[" + this.toStr(fontArray[i]) + "]");
                System.out.println(" family: " + fontArray[i].getFamily());
                FontInfo fontInfo = this.makeFontInfo(fontArray[i]);
                this.header(fontInfo, bl);
                this.glyphs(fontInfo, bl);
                this.pdf(fontInfo, bl);
                fontInfo.out.flush();
                fontInfo.out.close();
                continue;
            }
            catch (Exception exception) {
                System.out.println(" ### FAILED: " + this.toStr(fontArray[i]) + " ####");
                exception.printStackTrace();
            }
        }
    }

    private FontInfo makeFontInfo(Font font) throws Exception {
        FontInfo fontInfo = new FontInfo();
        fontInfo.name = this.toStr(font);
        fontInfo.font = font;
        fontInfo.fm = Toolkit.getDefaultToolkit().getFontMetrics(fontInfo.font);
        String string = "d:\\niagara\\r38\\util\\kits\\fonts\\src\\" + fontInfo.name + ".font";
        fontInfo.out = new OutStream(new GZIPOutputStream(new FileOutputStream(string)));
        return fontInfo;
    }

    private void header(FontInfo fontInfo, boolean bl) throws Exception {
        int n = 256;
        if (bl) {
            n = fontInfo.font.getNumGlyphs();
        }
        int n2 = 1;
        int n3 = fontInfo.fm.getLeading();
        int n4 = fontInfo.fm.getHeight();
        int n5 = fontInfo.fm.getAscent();
        int n6 = fontInfo.fm.getDescent();
        if (this.verbose) {
            System.out.println("  - glyphs:  " + n);
            System.out.println("  - ver:     " + n2);
            System.out.println("  - leading: " + n3);
            System.out.println("  - height:  " + n4);
            System.out.println("  - ascent:  " + n5);
            System.out.println("  - descent: " + n6);
        }
        fontInfo.out.u2(n);
        fontInfo.out.u1(n2);
        fontInfo.out.u1(n3);
        fontInfo.out.u1(n4);
        fontInfo.out.u1(n5);
        fontInfo.out.u1(n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glyphs(FontInfo fontInfo, boolean bl) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 2);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            char c = '\u0100';
            if (bl) {
                c = fontInfo.font.getNumGlyphs();
            }
            for (char c2 = '\u0000'; c2 < c; c2 = (char)(c2 + '\u0001')) {
                int[] nArray;
                int n;
                String string = "" + c2;
                int n2 = fontInfo.fm.stringWidth(string);
                int n3 = fontInfo.fm.getHeight();
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, 100, 100);
                graphics.setColor(Color.WHITE);
                graphics.setFont(fontInfo.font);
                graphics.drawString(string, 0, fontInfo.fm.getAscent());
                if (n2 < 0) {
                    n2 *= -1;
                }
                if ((n = (nArray = this.getPixels(bufferedImage, n2, n3)).length) > 65535) {
                    System.out.println("glyph buf len too big: " + n + "; w,h=" + n2 + "," + n3);
                    throw new RuntimeException("glyph buf len too big: " + n + "; w,h=" + n2 + "," + n3);
                }
                fontInfo.out.u2(n);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n4;
                        int n5 = n4 = nArray[i * n2 + j] == -16777216 ? 0 : 1;
                        if (this.moreVerbose) {
                            System.out.print(n4 == 1 ? "#" : ".");
                        }
                        fontInfo.out.u1(n4);
                    }
                    if (!this.moreVerbose) continue;
                    System.out.print("\n");
                }
                if (!this.moreVerbose) continue;
                System.out.print("\n");
            }
        }
        finally {
            graphics.dispose();
        }
    }

    private int[] getPixels(Image image, int n, int n2) throws Exception {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        pixelGrabber.grabPixels();
        return nArray;
    }

    private void pdf(FontInfo fontInfo, boolean bl) throws Exception {
        Font font = new Font(fontInfo.font.getName(), fontInfo.font.getStyle(), 72);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = font.getPSName();
        int n = fontMetrics.getLeading();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getDescent();
        if (this.verbose) {
            System.out.println("  - pdf.psName:  " + string);
            System.out.println("  - pdf.leading: " + n);
            System.out.println("  - pdf.height:  " + n2);
            System.out.println("  - pdf.ascent:  " + n3);
            System.out.println("  - pdf.descent: " + n4);
        }
        fontInfo.out.utf(string);
        fontInfo.out.u1(n);
        fontInfo.out.u1(n2);
        fontInfo.out.u1(n3);
        fontInfo.out.u1(n4);
        int n5 = 256;
        if (bl) {
            n5 = fontInfo.font.getNumGlyphs();
        }
        for (int i = 0; i < n5; ++i) {
            fontInfo.out.u1(fontMetrics.charWidth((char)i));
        }
    }

    private String toStr(Font font) {
        return this.getStyle(font) + font.getSize() + "pt " + font.getName();
    }

    private String getStyle(Font font) {
        int n = font.getStyle();
        if ((n & 3) == 3) {
            return "bold italic ";
        }
        if ((n & 2) == 2) {
            return "italic ";
        }
        if ((n & 1) == 1) {
            return "bold ";
        }
        return "";
    }

    public static void main(String[] stringArray) {
        Sys.getRegistry().getModules();
        MicroFontWriter microFontWriter = new MicroFontWriter();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-v")) {
                microFontWriter.verbose = true;
            }
            if (stringArray[0].equals("-vv")) {
                microFontWriter.verbose = true;
                microFontWriter.moreVerbose = true;
            }
        }
        microFontWriter.run();
    }

    class OutStream
    extends DataOutputStream {
        public OutStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void u1(int n) throws IOException {
            this.write(0xFF & n);
        }

        public void u2(int n) throws IOException {
            this.write(0xFF & n >> 8);
            this.write(0xFF & n);
        }

        public void utf(String string) throws IOException {
            this.writeUTF(string);
        }
    }

    class FontInfo {
        public String name;
        public Font font;
        public FontMetrics fm;
        public OutStream out;

        FontInfo() {
        }
    }
}

