/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.micro.MicroEnv;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MicroImagePeer
implements ImagePeer {
    double width;
    double height;
    int[] data;
    BImage image;

    public Graphics getGraphics() {
        return null;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean animate() {
        return false;
    }

    public void dispose() {
        this.data = null;
        this.height = 0.0;
        this.width = 0.0;
    }

    public boolean isLoaded() {
        boolean bl = false;
        if (this.data != null) {
            bl = true;
        }
        return bl;
    }

    public void sync() {
        if (this.image.getOrdList().isNull() || this.image.getOrdList().size() == 0) {
            return;
        }
        BOrd bOrd = this.image.getOrdList().get(0);
        try {
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            ImageLoader imageLoader = new ImageLoader();
            ImageData imageData = imageLoader.load(bIFile.getInputStream())[0];
            this.height = imageData.height;
            this.width = imageData.width;
            this.data = new int[(int)(this.width * this.height)];
            int[] nArray = new int[imageData.width];
            int n = 0;
            while (n < imageData.height) {
                imageData.getPixels(0, n, imageData.width, nArray, 0);
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = imageData.alpha != -1 ? imageData.alpha : (imageData.alphaData != null ? imageData.alphaData[n2 + n * imageData.width] : 255);
                    if (imageData.palette.isDirect) {
                        int n7 = nArray[n2];
                        n5 = n7 & imageData.palette.redMask;
                        n5 = imageData.palette.redShift < 0 ? n5 >>> -imageData.palette.redShift : n5 << imageData.palette.redShift;
                        n4 = n7 & imageData.palette.greenMask;
                        n4 = imageData.palette.greenShift < 0 ? n4 >>> -imageData.palette.greenShift : n4 << imageData.palette.greenShift;
                        n3 = n7 & imageData.palette.blueMask;
                        n3 = imageData.palette.blueShift < 0 ? n3 >>> -imageData.palette.blueShift : n3 << imageData.palette.blueShift;
                    } else {
                        RGB rGB = imageData.palette.getRGBs()[nArray[n2]];
                        n5 = rGB.red;
                        n4 = rGB.green;
                        n3 = rGB.blue;
                    }
                    this.data[n2 + n * imageData.width] = (n6 & 0xFF) << 24 | (n5 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n3 & 0xFF;
                    ++n2;
                }
                ++n;
            }
        }
        catch (UnresolvedException unresolvedException) {
            if (MicroEnv.log.isLoggable(2)) {
                MicroEnv.log.warning("MicroEnv: Cannot resolve image \"" + bOrd + '\"', (Throwable)unresolvedException);
            }
            unresolvedException.printStackTrace();
        }
        catch (Throwable throwable) {
            if (MicroEnv.log.isTraceOn()) {
                MicroEnv.log.error("MicroEnv: Cannot load image \"" + bOrd + '\"', throwable);
            }
            throwable.printStackTrace();
        }
    }

    public int[] getPixels() {
        if (this.data == null) {
            return new int[0];
        }
        int[] nArray = new int[this.data.length];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        return nArray;
    }

    public void setPixels(int[] nArray) {
        if ((double)nArray.length != this.width * this.height) {
            throw new IllegalStateException("MicroImagePeer: pixels.length != width x height");
        }
        this.data = nArray;
    }

    private final /* synthetic */ void this() {
        this.width = 0.0;
        this.height = 0.0;
        this.data = null;
    }

    private MicroImagePeer() throws Exception {
        this.this();
    }

    public MicroImagePeer(BImage bImage) {
        this.this();
        this.image = bImage;
    }
}

