/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.micro.MicroFont;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Sys;

public class MicroFontReader {
    private static BIFile[] files;
    static HashMap cache;
    static boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MicroFont read(BFont bFont) {
        MicroFont microFont = (MicroFont)cache.get((Object)bFont);
        if (microFont != null) {
            if (!verbose) return microFont;
            System.out.println("Get from cache: " + (Object)((Object)bFont));
            return microFont;
        }
        FilterInputStream filterInputStream = null;
        try {
            try {
                String string = (int)bFont.getSize() + "pt " + bFont.getName();
                int n = (int)bFont.getSize();
                int n2 = bFont.getStyle();
                microFont = new MicroFont(bFont.getName(), n2, n);
                if (bFont.isItalic()) {
                    string = "italic " + string;
                }
                if (bFont.isBold()) {
                    string = "bold " + string;
                }
                if (verbose) {
                    System.out.println("Reading [" + string + ".font]");
                }
                BOrd bOrd = BOrd.make((String)("module://fonts/" + string + ".font"));
                if (verbose) {
                    System.out.println("  - ord: " + bOrd);
                }
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                filterInputStream = new InStream(new BufferedInputStream(new GZIPInputStream(bIFile.getInputStream())));
                int n3 = ((InStream)filterInputStream).u2();
                int n4 = ((InStream)filterInputStream).u1();
                if (n4 != 1) {
                    throw new Exception("MicroFont version not supported: " + n4);
                }
                microFont.leading = ((InStream)filterInputStream).u1();
                microFont.height = ((InStream)filterInputStream).u1();
                microFont.ascent = ((InStream)filterInputStream).u1();
                microFont.descent = ((InStream)filterInputStream).u1();
                if (verbose) {
                    System.out.println("  - glyphs:  " + n3);
                    System.out.println("  - version: " + n4);
                    System.out.println("  - leading: " + microFont.leading);
                    System.out.println("  - height:  " + microFont.height);
                    System.out.println("  - ascent:  " + microFont.ascent);
                    System.out.println("  - descent: " + microFont.descent);
                }
                microFont.glyphs = new MicroFont.Glyph[n3];
                int n5 = 0;
                while (true) {
                    if (n5 >= n3) {
                        microFont.psName = ((InStream)filterInputStream).utf();
                        microFont.pdfLeading = ((InStream)filterInputStream).u1();
                        microFont.pdfHeight = ((InStream)filterInputStream).u1();
                        microFont.pdfAscent = ((InStream)filterInputStream).u1();
                        microFont.pdfDescent = ((InStream)filterInputStream).u1();
                        if (verbose) {
                            System.out.println("  - PDF name: " + microFont.psName);
                            System.out.println("  - PDF leading: " + microFont.pdfLeading);
                            System.out.println("  - PDF height:  " + microFont.pdfHeight);
                            System.out.println("  - PDF ascent:  " + microFont.pdfAscent);
                            System.out.println("  - PDF descent: " + microFont.pdfDescent);
                        }
                        break;
                    }
                    int n6 = ((InStream)filterInputStream).u2();
                    byte[] byArray = new byte[n6];
                    int n7 = ((DataInputStream)filterInputStream).read(byArray);
                    if (n7 != n6) {
                        throw new IllegalStateException("Not enough bytes read: " + n7 + '/' + n6);
                    }
                    microFont.glyphs[n5] = new MicroFont.Glyph();
                    microFont.glyphs[n5].width = n6 / microFont.height;
                    microFont.glyphs[n5].buf = byArray;
                    ++n5;
                }
                microFont.pdfWidths = new byte[n3];
                n5 = 0;
                while (true) {
                    block24: {
                        if (n5 < n3) break block24;
                        if (verbose) {
                            System.out.println("Adding to cache: " + (Object)((Object)bFont));
                        }
                        cache.put(bFont, microFont);
                        break;
                    }
                    microFont.pdfWidths[n5] = (byte)((InStream)filterInputStream).u1();
                    ++n5;
                }
            }
            catch (UnresolvedException unresolvedException) {
                MicroFont microFont2 = null;
                Object var4_18 = null;
                try {
                    filterInputStream.close();
                    return microFont2;
                }
                catch (Exception exception) {}
                return microFont2;
            }
            catch (Exception exception) {
                System.out.println("Failed to read " + (Object)((Object)bFont));
                exception.printStackTrace();
                MicroFont microFont3 = null;
                Object var4_19 = null;
                try {}
                catch (Exception exception2) {}
                filterInputStream.close();
                return microFont3;
            }
        }
        catch (Throwable throwable) {
            Object var4_20 = null;
            try {}
            catch (Exception exception) {}
            filterInputStream.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var4_21 = null;
            try {}
            catch (Exception exception) {
                return microFont;
            }
            filterInputStream.close();
            return microFont;
        }
    }

    public static BFont findRelative(BFont bFont) {
        Object object;
        if (bFont.getName().equals("monospaced") || bFont.getName().equals("Courier")) {
            return MicroFontReader.findRelative(BFont.make("Courier New", bFont.getSize(), bFont.getStyle()));
        }
        if (files == null) {
            BOrd bOrd = BOrd.make((String)"module://fonts/");
            object = (BIDirectory)bOrd.resolve().get();
            files = object.listFiles();
        }
        int n = 0;
        while (n < files.length) {
            object = files[n].getFileName();
            if (((String)object).indexOf(bFont.getName()) != -1) {
                boolean bl;
                boolean bl2 = false;
                if (((String)object).indexOf("bold") != -1) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                if (((String)object).indexOf("italic") != -1) {
                    bl4 = bl = true;
                }
                if (!(bFont.isBold() && !bl3 || !bFont.isBold() && bl3 || bFont.isItalic() && !bl || !bFont.isItalic() && bl)) {
                    return BFont.make(((String)object).substring(0, ((String)object).length() - ".font".length()));
                }
            }
            ++n;
        }
        if (bFont.isBold() || bFont.isItalic()) {
            return MicroFontReader.findRelative(BFont.make(bFont.getName(), bFont.getSize(), 0));
        }
        return MicroFontReader.findRelative(BFont.make("Arial", bFont.getSize(), bFont.getStyle()));
    }

    public static void main(String[] stringArray) {
        Sys.getRegistry().getModules();
        BFont[] bFontArray = new BFont[]{BFont.make("Arial", 16.0, 0), BFont.make("Courier New", 12.0, 0), BFont.make("Tahoma", 11.0, 0), BFont.make("Arial Unicode MS", 12.0, 0), BFont.make("NSimSun", 12.0, 0), BFont.make("MS Mincho", 12.0, 0), BFont.make("GulimChe", 12.0, 0), BFont.make("Gulim", 12.0, 0)};
        if (stringArray.length > 0) {
            verbose = true;
        }
        int n = 0;
        while (n < bFontArray.length) {
            MicroFontReader.read(bFontArray[n]);
            ++n;
        }
    }

    static {
        cache = new HashMap();
        verbose = false;
    }

    static class InStream
    extends DataInputStream {
        public int u1() throws IOException {
            return 0xFF & this.read();
        }

        public int u2() throws IOException {
            return (0xFF & this.read()) << 8 | 0xFF & this.read();
        }

        public String utf() throws IOException {
            return this.readUTF();
        }

        public InStream(InputStream inputStream) {
            super(inputStream);
        }
    }
}

