/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.FontPeer;
import com.tridium.gx.micro.MicroFont;

public class MicroFontPeer
implements FontPeer {
    public MicroFont font;
    double targetSize;
    double factor;

    public double getLeading() {
        return this.factor == 0.0 ? (double)this.font.leading : (double)this.font.pdfLeading * this.factor;
    }

    public double getAscent() {
        return this.factor == 0.0 ? (double)this.font.ascent : (double)this.font.pdfAscent * this.factor;
    }

    public double getDescent() {
        return this.factor == 0.0 ? (double)this.font.descent : (double)this.font.pdfDescent * this.factor;
    }

    public double getHeight() {
        return this.factor == 0.0 ? (double)this.font.height : (double)this.font.pdfHeight * this.factor;
    }

    public double getMaxAscent() {
        return this.getAscent();
    }

    public double getMaxDescent() {
        return this.getDescent();
    }

    public double width(int n) {
        if (n < 0 || n > this.font.glyphs.length) {
            n = 87;
        }
        return this.factor == 0.0 ? (double)this.font.glyphs[n].width : (double)this.font.pdfWidths[n] * this.factor;
    }

    public double width(String string) {
        return this.width(string.toCharArray(), 0, string.length());
    }

    public double width(char[] cArray, int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d += this.width(cArray[n3 + n]);
            ++n3;
        }
        return d;
    }

    public String getName() {
        return this.font.name;
    }

    public String getPostScriptName() {
        return this.font.psName;
    }

    public double getSize() {
        return this.factor == 0.0 ? (double)this.font.size : this.targetSize;
    }

    public int getPdfLeading() {
        return this.font.pdfLeading;
    }

    public int getPdfHeight() {
        return this.font.pdfHeight;
    }

    public int getPdfAscent() {
        return this.font.pdfAscent;
    }

    public int getPdfDescent() {
        return this.font.pdfDescent;
    }

    public byte[] getPdfWidths() {
        return this.font.pdfWidths;
    }

    public MicroFontPeer(MicroFont microFont, double d) {
        this.font = microFont;
        this.targetSize = d;
        this.factor = (double)microFont.size == d ? 0.0 : d / 72.0;
    }
}

