/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.se.AwtImagePaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BBrush;

abstract class UntexturedImagePaint
extends AwtImagePaint {
    protected Rectangle2D userBounds;
    protected AffineTransform trans;
    protected Raster bufRaster;
    protected Rectangle bufRect;
    protected int dataW = 0;
    protected int dataH = 0;
    protected WritableRaster dataRaster;
    protected WritableRaster blankRaster;

    UntexturedImagePaint(BBrush.Image image) {
        super(image);
    }

    void finishLoading() {
        this.bufRaster = this.buffer.getRaster();
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        this.trans = affineTransform;
        this.userBounds = rectangle2D;
        if (!this.isLoaded()) {
            this.unloadedContext = AwtEnv.TRANSPARENT.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
        }
        return this;
    }

    protected double halign(double d) {
        switch (this.brush.getHalign()) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return (d - (double)this.bufW) / 2.0;
            }
            case 4: {
                return d - (double)this.bufW;
            }
        }
        throw new IllegalStateException();
    }

    protected double valign(double d) {
        switch (this.brush.getValign()) {
            case 1: {
                return 0.0;
            }
            case 0: {
                return (d - (double)this.bufH) / 2.0;
            }
            case 2: {
                return d - (double)this.bufH;
            }
        }
        throw new IllegalStateException();
    }

    protected void initData(int n, int n2) {
        if (n > this.dataW || n2 > this.dataH) {
            this.dataW = n;
            this.dataH = n2;
            this.blankRaster = this.getColorModel().createCompatibleWritableRaster(this.dataW, this.dataH);
            this.dataRaster = this.getColorModel().createCompatibleWritableRaster(this.dataW, this.dataH);
        }
    }

    protected static void loadPixels(int n, int n2, int n3, int n4, Rectangle rectangle, Raster raster, WritableRaster writableRaster) {
        int[] nArray = new int[4];
        int n5 = n < 0 ? -n : 0;
        int n6 = n3 + n > rectangle.width ? rectangle.width - n : n3;
        for (int i = n5; i < n6; ++i) {
            int n7 = i + n;
            int n8 = n2 < 0 ? -n2 : 0;
            int n9 = n4 + n2 > rectangle.height ? rectangle.height - n2 : n4;
            for (int j = n8; j < n9; ++j) {
                int n10 = j + n2;
                writableRaster.setPixel(i, j, raster.getPixel(n7, n10, nArray));
            }
        }
    }
}

