/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.se.AwtSeEnv;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.IGeom;

public class AwtSeGraphics
extends AwtGraphics {
    Line2D.Double line = new Line2D.Double();
    Rectangle2D.Double rect = new Rectangle2D.Double();
    Ellipse2D.Double ellipse = new Ellipse2D.Double();
    boolean useAA = false;

    public AwtSeGraphics(Graphics2D graphics2D) {
        super(graphics2D);
    }

    public void useAntiAliasing(boolean bl) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            this.g.addRenderingHints(map);
        } else {
            this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        this.setAntiAliasHints();
    }

    public void setBrush(BBrush bBrush) {
        this.brush = bBrush;
        this.g.setPaint(AwtSeEnv.peer(bBrush));
        if (bBrush.getPaint() instanceof BBrush.Inverse) {
            this.g.setXORMode(Color.white);
        } else {
            this.g.setPaintMode();
        }
    }

    public void setPen(BPen bPen) {
        this.pen = bPen;
        this.g.setStroke(AwtSeEnv.peer(bPen));
    }

    public void transform(BTransform bTransform) {
        this.g.transform(AwtSeEnv.peer(bTransform));
    }

    public void translate(double d, double d2) {
        this.g.translate(d, d2);
    }

    public void clip(double d, double d2, double d3, double d4) {
        this.rect.setRect(d, d2, d3, d4);
        this.g.clip(this.rect);
    }

    public void drawString(String string, double d, double d2) {
        this.setFontAntiAliasHints();
        super.drawString(string, d, d2);
        this.setAntiAliasHints();
    }

    public void drawString(char[] cArray, int n, int n2, double d, double d2) {
        this.setFontAntiAliasHints();
        super.drawString(cArray, n, n2, d, d2);
        this.setAntiAliasHints();
    }

    public void stroke(IGeom iGeom) {
        this.g.draw(AwtSeEnv.peer(iGeom).shape());
    }

    public void fill(IGeom iGeom) {
        this.g.fill(AwtSeEnv.peer(iGeom).shape());
    }

    public void strokeLine(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            this.fillRect(d, d2, 1.0, 1.0);
        } else {
            this.line.setLine(d, d2, d3, d4);
            this.g.draw(this.line);
        }
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.rect.setRect(d, d2, d3, d4);
        this.g.fill(this.rect);
    }

    public void strokeRect(double d, double d2, double d3, double d4) {
        this.rect.setRect(d, d2, d3, d4);
        this.g.draw(this.rect);
    }

    private void setFontAntiAliasHints() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.font.isAntiAliased()) {
            this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    private void setAntiAliasHints() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
    }
}

