/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.GeomPeer;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.Hatching;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.se.AwtGeomPeer;
import com.tridium.gx.awt.se.AwtGraphPaper;
import com.tridium.gx.awt.se.AwtHatching;
import com.tridium.gx.awt.se.AwtImagePaint;
import com.tridium.gx.awt.se.AwtLinearGradient;
import com.tridium.gx.awt.se.AwtRadialGradient;
import com.tridium.gx.awt.se.AwtSeGraphics;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.util.Lexicon;

public class AwtSeEnv
extends AwtEnv {
    private GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private String[] fontFamilyNames = this.env.getAvailableFontFamilyNames(Locale.ENGLISH);
    private static final HashMap LOGICAL_FONTS;

    public AwtSeEnv() {
        Arrays.sort(this.fontFamilyNames);
    }

    public Graphics makeGraphics(Graphics2D graphics2D) {
        return new AwtSeGraphics(graphics2D);
    }

    public Image makeBufferedImage(double d, double d2) {
        return new BufferedImage((int)d, (int)d2, 2);
    }

    public boolean isRotationSupported() {
        return true;
    }

    public GeomPeer makeGeomPeer(IGeom iGeom) {
        return AwtSeEnv.peer(iGeom);
    }

    public static Paint peer(BBrush bBrush) {
        Paint paint = (Paint)bBrush.fw(201, null, null, null, null);
        if (paint == null) {
            paint = AwtSeEnv.makePeer(bBrush);
            bBrush.fw(202, paint, null, null, null);
        }
        return paint;
    }

    public static AwtGeomPeer peer(IGeom iGeom) {
        AwtGeomPeer awtGeomPeer = (AwtGeomPeer)iGeom.fw(201, null, null, null, null);
        if (awtGeomPeer == null) {
            awtGeomPeer = (AwtGeomPeer)AwtGeomPeer.make(iGeom);
            iGeom.fw(202, awtGeomPeer, null, null, null);
        }
        return awtGeomPeer;
    }

    public static Stroke peer(BPen bPen) {
        Stroke stroke = (Stroke)bPen.fw(201, null, null, null, null);
        if (stroke == null) {
            stroke = AwtSeEnv.makePeer(bPen);
            bPen.fw(202, stroke, null, null, null);
        }
        return stroke;
    }

    public static AffineTransform peer(BTransform bTransform) {
        AffineTransform affineTransform = (AffineTransform)bTransform.fw(201, null, null, null, null);
        if (affineTransform == null) {
            affineTransform = AwtSeEnv.makePeer(bTransform);
            bTransform.fw(202, affineTransform, null, null, null);
        }
        return affineTransform;
    }

    private static Paint makePeer(BBrush bBrush) {
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.Solid) {
            return AwtSeEnv.peer(((BBrush.Solid)paint).getColor());
        }
        if (paint instanceof BBrush.LinearGradient) {
            return new AwtLinearGradient((BBrush.LinearGradient)paint);
        }
        if (paint instanceof BBrush.RadialGradient) {
            return new AwtRadialGradient((BBrush.RadialGradient)paint);
        }
        if (paint instanceof BBrush.Image) {
            return AwtImagePaint.make((BBrush.Image)paint);
        }
        throw new IllegalStateException("Unsupported BBrush.Paint type");
    }

    private static Stroke makePeer(BPen bPen) {
        int n;
        int n2;
        float f = (float)bPen.getWidth();
        switch (bPen.getCap()) {
            case 103: {
                n2 = 1;
                break;
            }
            case 102: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        switch (bPen.getJoin()) {
            case 203: {
                n = 2;
                break;
            }
            case 202: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        double[] dArray = bPen.getDash();
        if (dArray.length == 0) {
            return new BasicStroke(f, n2, n);
        }
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f * (float)dArray[i];
        }
        return new BasicStroke(f, n2, n, 10.0f, fArray, 0.0f);
    }

    private static AffineTransform makePeer(BTransform bTransform) {
        AffineTransform affineTransform = new AffineTransform();
        BTransform.Transform[] transformArray = bTransform.getTransforms();
        block7: for (int i = 0; i < transformArray.length; ++i) {
            BTransform.Transform transform = transformArray[i];
            switch (transform.getTransformCase()) {
                case 1: {
                    BTransform.Translate translate = (BTransform.Translate)transform;
                    affineTransform.translate(translate.getX(), translate.getY());
                    continue block7;
                }
                case 2: {
                    BTransform.Scale scale = (BTransform.Scale)transform;
                    affineTransform.scale(scale.getX(), scale.getY());
                    continue block7;
                }
                case 3: {
                    BTransform.Rotate rotate = (BTransform.Rotate)transform;
                    affineTransform.rotate(AwtSeEnv.toRadians(rotate.getAngle()));
                    continue block7;
                }
                case 4: {
                    BTransform.SkewX skewX = (BTransform.SkewX)transform;
                    affineTransform.shear(Math.tan(AwtSeEnv.toRadians(skewX.getAngle())), 0.0);
                    continue block7;
                }
                case 5: {
                    BTransform.SkewY skewY = (BTransform.SkewY)transform;
                    affineTransform.shear(0.0, Math.tan(AwtSeEnv.toRadians(skewY.getAngle())));
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return affineTransform;
    }

    static double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public GraphPaper makeGraphPaper() {
        return new AwtGraphPaper();
    }

    public Hatching makeHatching() {
        return new AwtHatching();
    }

    public void loadFont(InputStream inputStream) {
        try {
            Font font = Font.createFont(0, inputStream);
            this.env.registerFont(font);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValidFontName(String string) {
        String string2 = this.getFirstExistingFont(string);
        if (string2 != null && LOGICAL_FONTS.containsKey(string2.toLowerCase())) {
            String string3 = Lexicon.make((String)"bajaui").get("font." + string2.toLowerCase(), (String)LOGICAL_FONTS.get(string2.toLowerCase()));
            string2 = this.getFirstExistingFont(string3 + "," + string2);
        }
        if (string2 == null) {
            string2 = "Open Sans";
        }
        return string2;
    }

    private String getFirstExistingFont(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.startsWith("'")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.endsWith("'")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (this.hasFont(string2)) {
                return string2;
            }
            if (!LOGICAL_FONTS.containsKey(string2.toLowerCase())) continue;
            return string2.toLowerCase();
        }
        return null;
    }

    public void overrideFontFamily(String string, String string2) {
        if (string == null) {
            throw new InvalidParameterException("Font family name required");
        }
        if (!LOGICAL_FONTS.containsKey(string.toLowerCase())) {
            throw new InvalidParameterException("Not a valid font family: " + string);
        }
        String string3 = this.getValidFontName(string2 + "," + string);
        LOGICAL_FONTS.put(string.toLowerCase(), string3);
    }

    public boolean hasFont(String string) {
        int n = Arrays.binarySearch(this.fontFamilyNames, string);
        return n >= 0;
    }

    static {
        String string;
        try {
            string = "module://gx/fonts";
            BOrd bOrd = BOrd.make((String)string);
            BIDirectory bIDirectory = (BIDirectory)bOrd.get();
            BIFile[] bIFileArray = bIDirectory.listFiles();
            for (int i = 0; i < bIFileArray.length; ++i) {
                BIFile bIFile = bIFileArray[i];
                if (!bIFile.getExtension().equalsIgnoreCase("ttf")) continue;
                ((AwtEnv)AwtEnv.get()).loadFont(bIFile.getInputStream());
            }
        }
        catch (Throwable throwable) {
            Log.getLog((String)"gx").warning("Could not load fonts from gx module. ");
        }
        LOGICAL_FONTS = new HashMap();
        string = Lexicon.make((String)"bajaui");
        LOGICAL_FONTS.put("Serif".toLowerCase(), string.get("font.serif", "PT Serif"));
        LOGICAL_FONTS.put("SansSerif".toLowerCase(), string.get("font.sansserif", "Open Sans"));
        LOGICAL_FONTS.put("Monospaced".toLowerCase(), string.get("font.monospaced", "Droid Sans Mono"));
        LOGICAL_FONTS.put("Dialog".toLowerCase(), string.get("font.dialog", "Open Sans"));
        LOGICAL_FONTS.put("DialogInput".toLowerCase(), string.get("font.dialoginput", "Open Sans"));
    }
}

