/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import javax.baja.gx.BBrush;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class AwtRadialGradient
implements Paint,
PaintContext {
    private BBrush.RadialGradient gradient;
    private float[] frac;
    private Color[] cols;
    private double cx;
    private double cy;
    private double radius;
    private double fx;
    private double fy;
    private PaintContext context;

    public AwtRadialGradient(BBrush.RadialGradient radialGradient) {
        this.gradient = radialGradient;
        BBrush.Stop[] stopArray = radialGradient.getStops();
        this.frac = new float[stopArray.length];
        this.cols = new Color[stopArray.length];
        for (int i = 0; i < stopArray.length; ++i) {
            this.frac[i] = (float)stopArray[i].getOffset() / 100.0f;
            this.cols[i] = AwtEnv.peer(stopArray[i].getColor());
        }
        this.cx = radialGradient.getCenter().x / 100.0;
        this.cy = radialGradient.getCenter().y / 100.0;
        this.radius = radialGradient.getRadius() / 100.0;
        this.fx = radialGradient.getFocal().x / 100.0;
        this.fy = radialGradient.getFocal().y / 100.0;
    }

    public int getTransparency() {
        return 2;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        float f = (float)(rectangle2D.getX() + rectangle2D.getWidth() * this.cx);
        float f2 = (float)(rectangle2D.getY() + rectangle2D.getHeight() * this.cy);
        float f3 = (float)(rectangle2D.getX() + rectangle2D.getWidth() * this.fx);
        float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() * this.fy);
        float f5 = (float)(Math.max(rectangle2D.getWidth(), rectangle2D.getHeight()) * this.radius);
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(f, f2, f5, f3, f4, this.frac, this.cols);
        this.context = radialGradientPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
        return this;
    }

    public void dispose() {
        this.context.dispose();
    }

    public ColorModel getColorModel() {
        return this.context.getColorModel();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        return this.context.getRaster(n, n2, n3, n4);
    }
}

