/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import javax.baja.gx.BBrush;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class AwtLinearGradient
implements Paint,
PaintContext {
    private BBrush.LinearGradient gradient;
    private float[] frac;
    private Color[] cols;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private PaintContext context;

    public AwtLinearGradient(BBrush.LinearGradient linearGradient) {
        this.gradient = linearGradient;
        BBrush.Stop[] stopArray = linearGradient.getStops();
        this.frac = new float[stopArray.length];
        this.cols = new Color[stopArray.length];
        for (int i = 0; i < stopArray.length; ++i) {
            this.frac[i] = (float)stopArray[i].getOffset() / 100.0f;
            this.cols[i] = AwtEnv.peer(stopArray[i].getColor());
        }
        double d = linearGradient.getAngle();
        double d2 = d / 180.0 * Math.PI + Math.PI;
        d2 = -d2;
        double d3 = Math.cos(d2) * 0.5;
        double d4 = Math.sin(d2) * 0.5;
        this.x1 = Math.abs(d3);
        this.y1 = Math.abs(d4);
        if (this.x1 > this.y1) {
            this.y1 = this.y1 * 0.5 / this.x1;
            this.x1 = 0.5;
        } else {
            this.x1 = this.x1 * 0.5 / this.y1;
            this.y1 = 0.5;
        }
        if (d3 < 0.0) {
            this.x1 = -this.x1;
        }
        if (d4 < 0.0) {
            this.y1 = -this.y1;
        }
        this.x1 += 0.5;
        this.y1 += 0.5;
        this.x2 = 1.0 - this.x1;
        this.y2 = 1.0 - this.y1;
    }

    public int getTransparency() {
        return 2;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        float f = (float)(rectangle2D.getX() + rectangle2D.getWidth() * this.x1);
        float f2 = (float)(rectangle2D.getY() + rectangle2D.getHeight() * this.y1);
        float f3 = (float)(rectangle2D.getX() + rectangle2D.getWidth() * this.x2);
        float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() * this.y2);
        if (f == f3 && f2 == f4) {
            f4 = (float)((double)f4 + 0.1);
        }
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(f, f2, f3, f4, this.frac, this.cols);
        this.context = linearGradientPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
        return this;
    }

    public void dispose() {
        this.context.dispose();
    }

    public ColorModel getColorModel() {
        return this.context.getColorModel();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        return this.context.getRaster(n, n2, n3, n4);
    }
}

