/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.ImageData;
import com.tridium.gx.awt.se.TexturedImagePaint;
import com.tridium.gx.awt.se.UntiledImagePaint;
import com.tridium.gx.awt.se.XTiledImagePaint;
import com.tridium.gx.awt.se.YTiledImagePaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;

abstract class AwtImagePaint
implements Paint,
PaintContext {
    protected BBrush.Image brush;
    protected boolean loaded;
    protected PaintContext unloadedContext;
    protected BufferedImage buffer;
    protected int bufW;
    protected int bufH;

    static AwtImagePaint make(BBrush.Image image) {
        try {
            AwtEnv.peer((BImage)image.getImage()).data.repaintOnLoad = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (image.getTile()) {
            case 0: {
                return new UntiledImagePaint(image);
            }
            case 2: {
                return new XTiledImagePaint(image);
            }
            case 3: {
                return new YTiledImagePaint(image);
            }
            case 1: {
                return new TexturedImagePaint(image);
            }
        }
        throw new IllegalStateException();
    }

    protected AwtImagePaint(BBrush.Image image) {
        this.brush = image;
        this.loaded = false;
    }

    boolean isLoaded() {
        if (this.loaded) {
            return true;
        }
        BImage bImage = this.brush.getImage();
        AwtImagePeer awtImagePeer = AwtEnv.peer(bImage);
        if (awtImagePeer.isLoaded()) {
            ImageData imageData = awtImagePeer.data;
            Image image = imageData.getImage();
            if (image == null) {
                return false;
            }
            this.bufW = image.getWidth(null);
            this.bufH = image.getHeight(null);
            if (image instanceof BufferedImage) {
                this.buffer = (BufferedImage)image;
            } else {
                this.buffer = new BufferedImage(this.bufW, this.bufH, 2);
                this.buffer.getGraphics().drawImage(image, 0, 0, null);
            }
            this.finishLoading();
            this.loaded = true;
            return true;
        }
        return false;
    }

    abstract void finishLoading();

    public int getTransparency() {
        if (this.isLoaded()) {
            return this.buffer.getColorModel().getTransparency();
        }
        return AwtEnv.TRANSPARENT.getTransparency();
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        if (this.isLoaded()) {
            return this.buffer.getColorModel();
        }
        return ColorModel.getRGBdefault();
    }
}

