/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.Hatching;
import com.tridium.gx.awt.AwtGraphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;

public class AwtHatching
implements Hatching,
Paint,
PaintContext {
    private static final ColorModel COLOR_MODEL = ColorModel.getRGBdefault();
    private static final int size = 5;
    private int[] pixel = new int[4];
    private double dx;
    private double dy;
    private int width = 0;
    private int height = 0;
    private WritableRaster raster;
    private Raster blank;

    public void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        Graphics2D graphics2D = ((AwtGraphics)graphics).getAwtGraphics();
        graphics2D.setPaint(this);
        graphics2D.fillRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void setColor(BColor bColor) {
        this.pixel[0] = bColor.getRed();
        this.pixel[1] = bColor.getGreen();
        this.pixel[2] = bColor.getBlue();
        this.pixel[3] = bColor.getAlpha();
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        this.dx = affineTransform.getTranslateX();
        this.dy = affineTransform.getTranslateY();
        return this;
    }

    public int getTransparency() {
        return 3;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return COLOR_MODEL;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (n3 > this.width || n4 > this.height) {
            this.width = n3;
            this.height = n4;
            this.raster = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
            this.blank = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
        } else {
            this.raster.setDataElements(0, 0, this.blank);
        }
        int n5 = (int)Math.round((double)n - this.dx);
        int n6 = (int)Math.round((double)n2 - this.dy);
        int n7 = n5 + n3;
        int n8 = n6 + n4;
        int n9 = n5 + n6;
        while (n9 % 5 != 4) {
            ++n9;
        }
        int n10 = n6 + Math.max(n3, n4) * 2;
        for (int i = n9 -= n5; i < n10; i += 5) {
            int n11 = n5;
            for (int j = i; n11 < n7 && j >= n6; ++n11, --j) {
                if (n11 < n5 || j >= n8) continue;
                this.raster.setPixel(n11 - n5, j - n6, this.pixel);
            }
        }
        return this.raster;
    }
}

