/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.GraphPaper;
import com.tridium.gx.awt.AwtGraphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;

public class AwtGraphPaper
implements GraphPaper,
Paint,
PaintContext {
    private static final ColorModel COLOR_MODEL = ColorModel.getRGBdefault();
    private int size;
    private int[] pixel = new int[4];
    private AffineTransform xform;
    private int width = 0;
    private int height = 0;
    private WritableRaster raster;
    private Raster blank;

    public void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        Graphics2D graphics2D = ((AwtGraphics)graphics).getAwtGraphics();
        graphics2D.setPaint(this);
        graphics2D.fillRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setColor(BColor bColor) {
        this.pixel[0] = bColor.getRed();
        this.pixel[1] = bColor.getGreen();
        this.pixel[2] = bColor.getBlue();
        this.pixel[3] = bColor.getAlpha();
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        this.xform = affineTransform;
        return this;
    }

    public int getTransparency() {
        return 3;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return COLOR_MODEL;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (n3 > this.width || n4 > this.height) {
            this.width = n3;
            this.height = n4;
            this.raster = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
            this.blank = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
        } else {
            this.raster.setDataElements(0, 0, this.blank);
        }
        double d = (double)this.size * this.xform.getScaleX();
        double d2 = ((double)n - this.xform.getTranslateX()) % d;
        if (d2 == 0.0) {
            d2 = d;
        }
        for (double d3 = d - d2; d3 < (double)n3; d3 += d) {
            for (int i = 0; i < n4; ++i) {
                this.raster.setPixel((int)d3, i, this.pixel);
            }
        }
        double d4 = (double)this.size * this.xform.getScaleY();
        d2 = ((double)n2 - this.xform.getTranslateY()) % d4;
        if (d2 == 0.0) {
            d2 = d4;
        }
        for (double d5 = d4 - d2; d5 < (double)n4; d5 += d4) {
            for (int i = 0; i < n3; ++i) {
                this.raster.setPixel(i, (int)d5, this.pixel);
            }
        }
        return this.raster;
    }
}

