/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.DefaultGeomPeer;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;

public abstract class AwtGeomPeer
extends DefaultGeomPeer {
    public static DefaultGeomPeer make(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)iGeom);
            }
            case 2: {
                return new Rect((IRectGeom)iGeom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)iGeom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)iGeom);
            }
            case 5: {
                return new Path((IPathGeom)iGeom);
            }
        }
        throw new IllegalStateException();
    }

    public abstract Shape shape();

    public boolean contains(double d, double d2) {
        return this.shape().contains(d, d2);
    }

    public boolean contains(IGeom iGeom) {
        IRectGeom iRectGeom = AwtGeomPeer.toRect(iGeom);
        return this.shape().contains(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.shape().contains(d, d2, d3, d4);
    }

    public boolean intersects(IGeom iGeom) {
        IRectGeom iRectGeom = AwtGeomPeer.toRect(iGeom);
        return this.shape().intersects(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.shape().intersects(d, d2, d3, d4);
    }

    public static class Path
    extends PathPeer {
        IPathGeom geom;
        Point controlPoint = new Point();

        Path(IPathGeom iPathGeom) {
            this.geom = iPathGeom;
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            IPathGeom iPathGeom = this.geom;
            IPathGeom.Segment[] segmentArray = iPathGeom.segments();
            int n = segmentArray.length;
            ExtendedGeneralPath extendedGeneralPath = this.shape = new ExtendedGeneralPath(1, n + 4);
            IPathGeom.Segment segment = null;
            Point point = new Point();
            Point point2 = null;
            for (int i = 0; i < n; ++i) {
                IPathGeom.Segment segment2 = segmentArray[i];
                switch (segment2.getCommand()) {
                    case 'M': 
                    case 'm': {
                        this.moveTo((IPathGeom.MoveTo)segment2, point);
                        point2 = null;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        this.lineTo((IPathGeom.LineTo)segment2, point);
                        point2 = null;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        this.hlineTo((IPathGeom.HLineTo)segment2, point);
                        point2 = null;
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        this.vlineTo((IPathGeom.VLineTo)segment2, point);
                        point2 = null;
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        point2 = this.quadTo((IPathGeom.QuadTo)segment2, point);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        point2 = this.smoothQuadTo((IPathGeom.SmoothQuadTo)segment2, point, point2);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        point2 = this.curveTo((IPathGeom.CurveTo)segment2, point);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        point2 = this.smoothCurveTo((IPathGeom.SmoothCurveTo)segment2, point, point2);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        this.arcTo((IPathGeom.ArcTo)segment2, point);
                        point2 = null;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        this.shape.closePath();
                        point2 = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(segment2.toString());
                    }
                }
                segment = segment2;
            }
        }

        void moveTo(IPathGeom.MoveTo moveTo, Point point) {
            double d = moveTo.getX();
            double d2 = moveTo.getY();
            if (moveTo.isRelative()) {
                d += point.x;
                d2 += point.y;
            }
            this.shape.moveTo((float)d, (float)d2);
            point.set(d, d2);
        }

        void lineTo(IPathGeom.LineTo lineTo, Point point) {
            double d = lineTo.getX();
            double d2 = lineTo.getY();
            if (lineTo.isRelative()) {
                d += point.x;
                d2 += point.y;
            }
            this.shape.lineTo((float)d, (float)d2);
            point.set(d, d2);
        }

        void hlineTo(IPathGeom.HLineTo hLineTo, Point point) {
            double d = hLineTo.getX();
            double d2 = point.y;
            if (hLineTo.isRelative()) {
                d += point.x;
            }
            this.shape.lineTo((float)d, (float)d2);
            point.set(d, d2);
        }

        void vlineTo(IPathGeom.VLineTo vLineTo, Point point) {
            double d = point.x;
            double d2 = vLineTo.getY();
            if (vLineTo.isRelative()) {
                d2 += point.y;
            }
            this.shape.lineTo((float)d, (float)d2);
            point.set(d, d2);
        }

        Point quadTo(IPathGeom.QuadTo quadTo, Point point) {
            double d = quadTo.getX();
            double d2 = quadTo.getY();
            double d3 = quadTo.getX1();
            double d4 = quadTo.getY1();
            if (quadTo.isRelative()) {
                d += point.x;
                d2 += point.y;
                d3 += point.x;
                d4 += point.y;
            }
            this.shape.quadTo((float)d3, (float)d4, (float)d, (float)d2);
            point.set(d, d2);
            this.controlPoint.set(d3, d4);
            return this.controlPoint;
        }

        Point smoothQuadTo(IPathGeom.SmoothQuadTo smoothQuadTo, Point point, Point point2) {
            double d = smoothQuadTo.getX();
            double d2 = smoothQuadTo.getY();
            double d3 = point.x;
            double d4 = point.y;
            if (point2 != null) {
                d3 += point.x - point2.x;
                d4 += point.y - point2.y;
            }
            if (smoothQuadTo.isRelative()) {
                d += point.x;
                d2 += point.y;
            }
            this.shape.quadTo((float)d3, (float)d4, (float)d, (float)d2);
            point.set(d, d2);
            this.controlPoint.set(d3, d4);
            return this.controlPoint;
        }

        Point curveTo(IPathGeom.CurveTo curveTo, Point point) {
            double d = curveTo.getX();
            double d2 = curveTo.getY();
            double d3 = curveTo.getX1();
            double d4 = curveTo.getY1();
            double d5 = curveTo.getX2();
            double d6 = curveTo.getY2();
            if (curveTo.isRelative()) {
                d += point.x;
                d2 += point.y;
                d3 += point.x;
                d4 += point.y;
                d5 += point.x;
                d6 += point.y;
            }
            this.shape.curveTo((float)d3, (float)d4, (float)d5, (float)d6, (float)d, (float)d2);
            point.set(d, d2);
            this.controlPoint.set(d5, d6);
            return this.controlPoint;
        }

        Point smoothCurveTo(IPathGeom.SmoothCurveTo smoothCurveTo, Point point, Point point2) {
            double d = smoothCurveTo.getX();
            double d2 = smoothCurveTo.getY();
            double d3 = point.x;
            double d4 = point.y;
            double d5 = smoothCurveTo.getX2();
            double d6 = smoothCurveTo.getY2();
            if (point2 != null) {
                d3 += point.x - point2.x;
                d4 += point.y - point2.y;
            }
            if (smoothCurveTo.isRelative()) {
                d += point.x;
                d2 += point.y;
                d5 += point.x;
                d6 += point.y;
            }
            this.shape.curveTo((float)d3, (float)d4, (float)d5, (float)d6, (float)d, (float)d2);
            point.set(d, d2);
            this.controlPoint.set(d5, d6);
            return this.controlPoint;
        }

        void arcTo(IPathGeom.ArcTo arcTo, Point point) {
            double d = arcTo.getRadiusX();
            double d2 = arcTo.getRadiusY();
            double d3 = arcTo.getXAxisRotation();
            boolean bl = arcTo.getLargeArcFlag();
            boolean bl2 = arcTo.getSweepFlag();
            double d4 = arcTo.getX();
            double d5 = arcTo.getY();
            if (arcTo.isRelative()) {
                d4 += point.x;
                d5 += point.y;
            }
            this.shape.arcTo(d, d2, d3, bl, bl2, d4, d5);
            point.set(d4, d5);
        }
    }

    public static class Polygon
    extends PathPeer {
        IPolygonGeom geom;

        Polygon(IPolygonGeom iPolygonGeom) {
            this.geom = iPolygonGeom;
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            IPolygonGeom iPolygonGeom = this.geom;
            int n = this.geom.size();
            ExtendedGeneralPath extendedGeneralPath = this.shape = new ExtendedGeneralPath(1, n + 4);
            if (n == 0) {
                return;
            }
            extendedGeneralPath.moveTo((float)iPolygonGeom.x(0), (float)iPolygonGeom.y(0));
            for (int i = 1; i < n; ++i) {
                extendedGeneralPath.lineTo((float)iPolygonGeom.x(i), (float)iPolygonGeom.y(i));
            }
            extendedGeneralPath.closePath();
        }
    }

    public static abstract class PathPeer
    extends AwtGeomPeer {
        ExtendedGeneralPath shape;
        Rectangle2D bounds;

        public final Shape shape() {
            return this.shape;
        }

        public final double x() {
            return this.b().getX();
        }

        public final double y() {
            return this.b().getY();
        }

        public final double width() {
            return this.b().getWidth();
        }

        public final double height() {
            return this.b().getHeight();
        }

        final Rectangle2D b() {
            if (this.bounds == null) {
                this.bounds = this.shape.getBounds2D();
            }
            return this.bounds;
        }
    }

    public static class Ellipse
    extends AwtGeomPeer {
        IEllipseGeom geom;
        Ellipse2D.Double shape = new Ellipse2D.Double();

        Ellipse(IEllipseGeom iEllipseGeom) {
            this.geom = iEllipseGeom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setFrame(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Rect
    extends AwtGeomPeer {
        IRectGeom geom;
        Rectangle2D.Double shape = new Rectangle2D.Double();

        Rect(IRectGeom iRectGeom) {
            this.geom = iRectGeom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setRect(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Line
    extends AwtGeomPeer {
        ILineGeom geom;
        Line2D.Double shape = new Line2D.Double();

        Line(ILineGeom iLineGeom) {
            this.geom = iLineGeom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setLine(this.geom.x1(), this.geom.y1(), this.geom.x2(), this.geom.y2());
            return this.shape;
        }

        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }
    }
}

