/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.me;

import com.tridium.gx.DefaultGeomPeer;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;

public abstract class AwtMeGeomPeer
extends DefaultGeomPeer {
    public static DefaultGeomPeer make(IGeom iGeom) {
        if (iGeom.getGeomCase() == 5) {
            return new Path((IPathGeom)iGeom);
        }
        return DefaultGeomPeer.make(iGeom);
    }

    public static class Path
    extends AwtMeGeomPeer {
        IPathGeom geom;
        Rectangle bounds;
        Polygon polygon;
        int[] x;
        int[] y;
        int size;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.bounds.x;
        }

        public final double y() {
            return this.bounds.y;
        }

        public final double width() {
            return this.bounds.width;
        }

        public final double height() {
            return this.bounds.height;
        }

        void draw() {
            IPathGeom iPathGeom = this.geom;
            IPathGeom.Segment[] segmentArray = iPathGeom.segments();
            this.size = segmentArray.length;
            if (segmentArray[segmentArray.length - 1] instanceof IPathGeom.ClosePath) {
                --this.size;
            }
            this.x = new int[this.size];
            this.y = new int[this.size];
            int n = 0;
            while (n < segmentArray.length) {
                IPathGeom.Segment segment = segmentArray[n];
                switch (segment.getCommand()) {
                    case 'M': {
                        IPathGeom.MoveTo moveTo = (IPathGeom.MoveTo)segment;
                        this.x[0] = (int)moveTo.getX();
                        this.y[0] = (int)moveTo.getY();
                        break;
                    }
                    case 'L': {
                        IPathGeom.LineTo lineTo = (IPathGeom.LineTo)segment;
                        this.x[n] = (int)lineTo.getX();
                        this.y[n] = (int)lineTo.getY();
                        break;
                    }
                    case 'l': {
                        IPathGeom.LineTo lineTo = (IPathGeom.LineTo)segment;
                        this.x[n] = (int)lineTo.getX() + this.x[n - 1];
                        this.y[n] = (int)lineTo.getY() + this.y[n - 1];
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        this.polygon = new Polygon(this.x, this.y, this.size);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(segment.toString());
                    }
                }
                ++n;
            }
            this.bounds = new Polygon(this.x, this.y, this.size).getBounds();
        }

        Path(IPathGeom iPathGeom) {
            this.geom = iPathGeom;
            this.draw();
        }
    }
}

