/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.BImageDecoder;
import com.tridium.gx.awt.GifDecoder;
import com.tridium.gx.awt.ImageData;
import com.tridium.sys.Nre;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class ImageManager {
    static final int TRIM_SIZE = 10240;
    static final long TRIM_AGE = 900000L;
    private static Log log = Log.getLog((String)"gx.image");
    private static HashMap cache = new HashMap();
    private static Queue queue = new Queue();
    private static final Thread thread;
    private static String activeTheme;
    private static MediaTracker tracker;

    public static synchronized ImageData fetchImageData(BImage bImage) {
        return ImageManager.fetchImageData(bImage, null);
    }

    public static synchronized ImageData fetchImageData(BImage bImage, BTransform.Scale scale) {
        ImageData imageData;
        BOrdList bOrdList = bImage.getAbsoluteOrdList();
        String string = bOrdList.encodeToString();
        if (scale != null) {
            string = string + '{' + scale.getX() + ',' + scale.getY() + '}';
        }
        if ((imageData = (ImageData)cache.get(string)) != null) {
            if (imageData.hasFileBeenModified()) {
                if (log.isTraceOn()) {
                    log.trace("out of date: " + string);
                }
                cache.remove(string);
            } else {
                imageData.lastUsedTicks = Clock.ticks();
                return imageData;
            }
        }
        imageData = new ImageData(null);
        imageData.ordList = bOrdList;
        imageData.cacheKey = string;
        imageData.lastUsedTicks = Clock.ticks();
        imageData.scale = scale;
        if (log.isTraceOn()) {
            log.trace("caching: " + string);
        }
        cache.put(string, imageData);
        if (string.startsWith("module://") || string.startsWith("local:|module://")) {
            if (log.isTraceOn()) {
                log.trace("load sync: " + string);
            }
            ImageManager.load(imageData);
        } else {
            if (log.isTraceOn()) {
                log.trace("load async: " + string);
            }
            queue.enqueue((Object)imageData);
        }
        return imageData;
    }

    public static void trimAll() {
        log.warning("Entire cache cleared");
        cache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image sync(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            try {
                tracker.addImage(image, 0);
                tracker.waitForID(0, 0L);
                tracker.removeImage(image, 0);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException.toString());
            }
            return image;
        }
    }

    public static void setActiveTheme(String string) {
        activeTheme = string;
        IconManager.updateModuleBase();
    }

    public static Image rescaleImage(Image image, BTransform.Scale scale) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == 0 || n2 == 0) {
            return image;
        }
        AwtEnv awtEnv = (AwtEnv)AwtEnv.get();
        Image image2 = awtEnv.makeBufferedImage((double)n * scale.getX(), (double)n2 * scale.getY());
        Graphics graphics = awtEnv.makeGraphics((Graphics2D)image2.getGraphics());
        graphics.transform(BTransform.make(scale));
        Graphics2D graphics2D = ((AwtGraphics)graphics).getAwtGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return image2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void load(ImageData imageData) {
        block9: {
            block8: {
                try {
                    BOrdList bOrdList = imageData.ordList;
                    if (bOrdList.size() == 0) {
                        Object var2_2 = null;
                        imageData.loaded();
                        return;
                    }
                    ImageManager.loadFile(imageData, bOrdList.get(0));
                    if (bOrdList.size() == 1) {
                        break block8;
                    }
                    double d = imageData.getWidth();
                    double d2 = imageData.getHeight();
                    if (imageData.scale != null) {
                        d *= imageData.scale.getX();
                        d2 *= imageData.scale.getY();
                    }
                    Image image = ((AwtEnv)AwtEnv.get()).makeBufferedImage(d, d2);
                    image.getGraphics().drawImage(imageData.image, 0, 0, null);
                    int n = 1;
                    while (true) {
                        if (n >= bOrdList.size()) {
                            imageData.image = image;
                            break block9;
                        }
                        ImageManager.loadFile(imageData, bOrdList.get(n));
                        image.getGraphics().drawImage(imageData.image, 0, 0, null);
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    imageData.loaded();
                    throw throwable;
                }
            }
            Object var2_3 = null;
            imageData.loaded();
            return;
        }
        Object var2_5 = null;
        imageData.loaded();
    }

    private static final void loadFile(ImageData imageData, BOrd bOrd) {
        if (bOrd.isNull()) {
            return;
        }
        try {
            bOrd = IconManager.getExistingOrd(bOrd.toString());
            BIFile bIFile = (BIFile)bOrd.resolve((BObject)BLocalHost.INSTANCE).get();
            byte[] byArray = bIFile.read();
            imageData.setFile(bIFile, byArray.length);
            AgentList agentList = ((BObject)bIFile).getAgents().filter(AgentFilter.is((Type)BImageDecoder.TYPE));
            if (agentList.size() > 0) {
                BImageDecoder bImageDecoder = (BImageDecoder)agentList.getDefault().getInstance();
                bImageDecoder.decode(bOrd, byArray, imageData.scale);
                imageData.image = bImageDecoder.getImage();
                imageData.animator = bImageDecoder.getAnimator();
            } else {
                ImageManager.decode(imageData, byArray);
            }
        }
        catch (UnresolvedException unresolvedException) {
            log.error("Cannot resolve image \"" + bOrd + '\"');
        }
        catch (Throwable throwable) {
            log.error("Cannot load image \"" + bOrd + '\"', throwable);
        }
    }

    private static final void decode(ImageData imageData, byte[] byArray) throws Exception {
        if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
            GifDecoder gifDecoder = new GifDecoder();
            gifDecoder.decode(byArray, imageData.scale);
            imageData.image = gifDecoder.getImage();
            imageData.animator = gifDecoder.getAnimator();
        } else {
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            ImageManager.sync(image);
            imageData.image = imageData.scale == null ? image : ImageManager.rescaleImage(image, imageData.scale);
        }
    }

    static synchronized void trim() {
        log.trace("trim");
        long l = Clock.ticks();
        ImageData[] imageDataArray = cache.values().toArray(new ImageData[cache.size()]);
        int n = 0;
        while (n < imageDataArray.length) {
            ImageData imageData = imageDataArray[n];
            if (imageData.trim(l)) {
                log.trace("  trim: " + imageData.cacheKey);
                cache.remove(imageData.cacheKey);
            }
            ++n;
        }
    }

    static /* synthetic */ Queue access$0() {
        return queue;
    }

    static /* synthetic */ Log access$1() {
        return log;
    }

    static final /* synthetic */ void access$2(ImageData imageData) {
        ImageManager.load(imageData);
    }

    static {
        activeTheme = "";
        tracker = new MediaTracker(new Component(){});
        thread = new ImageManagerThread();
        thread.start();
        Spy.ROOT.add("imageManager", (Spy)new ImageManagerSpy());
    }

    private static class IconManager {
        private static String moduleBase;
        private static final String DEFAULT_MODULE_BASE = "module://";
        private static Log logger;

        private static final void updateModuleBase() {
            String string = activeTheme;
            moduleBase = DEFAULT_MODULE_BASE;
            if (string != null && string.trim().length() > 0) {
                try {
                    Sys.loadModule((String)string);
                    moduleBase = DEFAULT_MODULE_BASE + string + "/imageOverrides/";
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    logger.error("bajaui.activeTheme '" + string + "' could not be loaded");
                }
            }
        }

        public static BOrd getExistingOrd(String string) {
            if (string.startsWith(DEFAULT_MODULE_BASE)) {
                String string2 = moduleBase + string.substring(9);
                BOrd bOrd = IconManager.makeOrd(string2);
                if (bOrd != null) {
                    return bOrd;
                }
                bOrd = IconManager.makeOrd(string);
                if (bOrd == null) {
                    logger.error("icon '" + string + "' could not be found either in active theme module or in icons module.");
                    return BOrd.make((String)"module://icons/x16/error.png");
                }
                return bOrd;
            }
            return BOrd.make((String)string);
        }

        private static final BOrd makeOrd(String string) {
            try {
                BOrd bOrd = BOrd.make((String)string);
                bOrd.get();
                return bOrd;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private IconManager() {
        }

        static {
            logger = Log.getLog((String)"com.tridium.gx.awt");
            IconManager.updateModuleBase();
        }
    }

    static class ImageManagerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = Clock.ticks();
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        block9: {
                            block10: {
                                block8: {
                                    if ((var3_2 = (ImageData)ImageManager.access$0().dequeue()) != null) break block8;
                                    if (Clock.ticks() - var1_1 <= 60000L) break block9;
                                    break block10;
                                }
                                if (ImageManager.access$1().isTraceOn()) {
                                    ImageManager.access$1().trace("  loading: " + var3_2.cacheKey);
                                }
                                ImageManager.access$2(var3_2);
                                if (!ImageManager.access$1().isTraceOn()) continue;
                                ImageManager.access$1().trace("       ok: " + var3_2.cacheKey + " -> " + var3_2.getWidth() + ',' + var3_2.getHeight());
                                continue;
                            }
                            var1_1 = Clock.ticks();
                            ImageManager.trim();
                        }
                        var3_2 = ImageManager.access$0();
                        synchronized (var3_2) {
                            ImageManager.access$0().wait(10000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var3_3) {
                    var3_3.printStackTrace();
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }

        ImageManagerThread() {
            super(Nre.mainThreadGroup, "Ui:ImageManager");
            this.setDaemon(true);
        }
    }

    static class ImageManagerSpy
    extends SpyByKey {
        ImageManagerSpy() {
            this.add("bySize", (Spy)new SpyBySize());
            this.add("byLastUsed", (Spy)new SpyByLastUsed());
        }
    }

    static class SpyByLastUsed
    extends AbstractSpy {
        public int compare(Object object, Object object2) {
            long l = ((ImageData)object).lastUsedTicks;
            long l2 = ((ImageData)object2).lastUsedTicks;
            if (l < l2) {
                return -1;
            }
            return 1;
        }

        SpyByLastUsed() {
        }
    }

    static class SpyBySize
    extends AbstractSpy {
        public int compare(Object object, Object object2) {
            int n = ((ImageData)object).fileSize;
            int n2 = ((ImageData)object2).fileSize;
            if (n < n2) {
                return 1;
            }
            if (n == n2) {
                return 0;
            }
            return -1;
        }

        SpyBySize() {
        }
    }

    static class SpyByKey
    extends AbstractSpy {
        public int compare(Object object, Object object2) {
            return SortUtil.compare((Object)((ImageData)object).cacheKey, (Object)((ImageData)object2).cacheKey);
        }

        SpyByKey() {
        }
    }

    static abstract class AbstractSpy
    extends SpyDir
    implements Comparator {
        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = cache.values().toArray(new ImageData[cache.size()]);
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)this);
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Image Cache [" + objectArray.length + ']'), 3);
            spyWriter.w((Object)"<tr>").th((Object)"<b><a href='/imageManager'>Image</a></b>").th((Object)"<b><a href='/imageManager/bySize'>Size</a></b>").th((Object)"<b><a href='/imageManager/byLastUsed'>Last Used</a></b>").w((Object)"</tr>\n");
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = ((ImageData)object).fileSize / 1024 + "kb";
                String string2 = BRelTime.toString((long)(Clock.ticks() - ((ImageData)object).lastUsedTicks));
                spyWriter.tr((Object)((ImageData)object).cacheKey, (Object)string, (Object)string2);
                ++n;
            }
            spyWriter.endTable();
        }

        AbstractSpy() {
        }
    }
}

