/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageAnimator;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.baja.file.BIFile;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;

public class ImageData {
    Image image;
    ImageAnimator animator;
    BOrdList ordList;
    String cacheKey;
    long lastUsedTicks;
    BIFile file;
    BAbsTime fileTime;
    int fileSize;
    boolean loaded;
    public boolean repaintOnLoad;
    BTransform.Scale scale;

    public Image getImage() {
        return this.image;
    }

    public Graphics getGraphics() {
        return ((AwtEnv)AwtEnv.get()).makeGraphics((Graphics2D)this.image.getGraphics());
    }

    public double getWidth() {
        int n = 0;
        if (this.image != null) {
            n = this.image.getWidth(null);
        }
        return n;
    }

    public double getHeight() {
        int n = 0;
        if (this.image != null) {
            n = this.image.getHeight(null);
        }
        return n;
    }

    public void dispose() {
        if (this.cacheKey != null) {
            return;
        }
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    void setFile(BIFile bIFile, int n) {
        if (this.file == null) {
            this.file = bIFile;
            this.fileTime = bIFile.getLastModified();
        }
        this.fileSize += n;
    }

    boolean hasFileBeenModified() {
        if (this.file == null) {
            return false;
        }
        return this.file.getLastModified().equals((Object)this.fileTime) ^ true;
    }

    synchronized void loaded() {
        this.loaded = true;
        this.notifyAll();
        if (this.repaintOnLoad) {
            this.repaintOnLoad = false;
            GxEnv.get().repaintAll();
        }
    }

    boolean trim(long l) {
        boolean bl = false;
        if (this.fileSize > 10240 && l - this.lastUsedTicks > 900000L) {
            bl = true;
        }
        return bl;
    }

    Image getAnimatedImage() {
        if (this.animator == null) {
            return this.image;
        }
        return this.animator.getAnimatedImage();
    }

    boolean animate() {
        if (this.animator == null) {
            return false;
        }
        return this.animator.animate();
    }

    ImageData(Image image) {
        this.image = image;
        boolean bl = false;
        if (image != null) {
            bl = true;
        }
        this.loaded = bl;
    }
}

