/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.GifAnimator;
import com.tridium.gx.awt.ImageAnimator;
import com.tridium.gx.awt.ImageManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.gx.BTransform;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GifDecoder {
    private static final boolean DEBUG = true;
    private static final int STACK_SIZE = 4096;
    private Image image;
    private GifAnimator animator;
    private byte[] data;
    private int dataSize;
    private int pos;
    private int width;
    private int height;
    private int bgIndex;
    private ColorTable gct;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private boolean interlace;
    private int delay;
    private int transIndex;
    private int dispose;
    private int lastDispose;
    private int blockSize;
    private byte[] block;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private byte[] lastDest;
    private byte[] lastLastDest;

    public void decode(byte[] byArray, BTransform.Scale scale) throws Exception {
        int n;
        this.data = byArray;
        this.dataSize = byArray.length;
        this.pos = 0;
        this.readHeader();
        ArrayList<GifAnimator.Frame> arrayList = new ArrayList<GifAnimator.Frame>();
        boolean bl = false;
        while (!bl) {
            int n2 = this.u1();
            switch (n2) {
                case 44: {
                    arrayList.add(this.readImage());
                    break;
                }
                case 33: {
                    this.readExt();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.err();
                }
            }
        }
        GifAnimator.Frame[] frameArray = arrayList.toArray(new GifAnimator.Frame[arrayList.size()]);
        if (scale != null) {
            n = 0;
            while (n < frameArray.length) {
                frameArray[n].image = ImageManager.rescaleImage(frameArray[n].image, scale);
                ++n;
            }
        }
        this.animator.frames = frameArray;
        this.image = this.animator.frames[0].image;
        this.animator.duration = 0.0;
        n = 0;
        while (n < this.animator.frames.length) {
            this.animator.duration += (double)this.animator.frames[n].delay;
            ++n;
        }
    }

    private final void readHeader() throws Exception {
        if (this.data[0] != 71 || this.data[1] != 73 || this.data[2] != 70) {
            throw this.err();
        }
        this.pos = 6;
        this.width = this.u2();
        this.height = this.u2();
        int n = this.u1();
        this.bgIndex = this.u1();
        int n2 = this.u1();
        boolean bl = false;
        if ((n >> 7 & 1) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        int n3 = n & 7;
        if (bl2) {
            this.gct = this.readColorTable(n3);
        }
    }

    private final ColorTable readColorTable(int n) throws Exception {
        ColorTable colorTable = new ColorTable();
        int n2 = colorTable.length = 1 << n + 1;
        colorTable.r = new byte[n2];
        byte[] byArray = colorTable.r;
        colorTable.g = new byte[n2];
        byte[] byArray2 = colorTable.g;
        colorTable.b = new byte[n2];
        byte[] byArray3 = colorTable.b;
        if (this.pos + n2 * 3 >= this.dataSize) {
            throw new EOFException();
        }
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.data[this.pos++];
            byArray2[n3] = this.data[this.pos++];
            byArray3[n3] = this.data[this.pos++];
            ++n3;
        }
        return colorTable;
    }

    private final GifAnimator.Frame readImage() throws Exception {
        GifAnimator.Frame frame = new GifAnimator.Frame();
        frame.delay = this.delay;
        this.ix = this.u2();
        this.iy = this.u2();
        this.iw = this.u2();
        this.ih = this.u2();
        int n = this.u1();
        boolean bl = false;
        if ((n >> 7 & 1) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if ((n >> 6 & 1) != 0) {
            bl3 = true;
        }
        this.interlace = bl3;
        int n2 = n & 7;
        ColorTable colorTable = this.gct;
        if (bl2) {
            colorTable = this.readColorTable(n2);
        }
        this.readImageData();
        frame.image = ImageManager.sync(this.render(colorTable));
        this.skip();
        this.transIndex = -1;
        this.delay = -1;
        this.lastDispose = this.dispose;
        this.dispose = 1;
        return frame;
    }

    private final void readImageData() throws Exception {
        int n = -1;
        int n2 = this.iw * this.ih;
        this.pixels = new byte[n2];
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n3 = this.u1();
        int n4 = 1 << n3;
        int n5 = n4 + 1;
        int n6 = n4 + 2;
        int n7 = n;
        int n8 = n3 + 1;
        int n9 = (1 << n8) - 1;
        int n10 = 0;
        while (n10 < n4) {
            this.prefix[n10] = 0;
            this.suffix[n10] = (byte)n10;
            ++n10;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        while (n18 < n2) {
            if (n13 == 0) {
                if (n16 < n8) {
                    if (n15 == 0) {
                        n15 = this.readBlock();
                        if (n15 <= 0) break;
                        n11 = 0;
                    }
                    n17 += (this.block[n11] & 0xFF) << n16;
                    n16 += 8;
                    ++n11;
                    --n15;
                    continue;
                }
                n10 = n17 & n9;
                n17 >>= n8;
                n16 -= n8;
                if (n10 > n6 || n10 == n5) break;
                if (n10 == n4) {
                    n8 = n3 + 1;
                    n9 = (1 << n8) - 1;
                    n6 = n4 + 2;
                    n7 = n;
                    continue;
                }
                if (n7 == n) {
                    this.pixelStack[n13++] = this.suffix[n10];
                    n7 = n10;
                    n14 = n10;
                    continue;
                }
                int n19 = n10;
                if (n10 == n6) {
                    this.pixelStack[n13++] = (byte)n14;
                    n10 = n7;
                }
                while (n10 > n4) {
                    this.pixelStack[n13++] = this.suffix[n10];
                    n10 = this.prefix[n10];
                }
                n14 = this.suffix[n10] & 0xFF;
                if (n6 >= 4096) break;
                this.pixelStack[n13++] = (byte)n14;
                this.prefix[n6] = (short)n7;
                this.suffix[n6] = (byte)n14;
                if ((++n6 & n9) == 0 && n6 < 4096) {
                    ++n8;
                    n9 += n6;
                }
                n7 = n19;
            }
            this.pixels[n12++] = this.pixelStack[--n13];
            ++n18;
        }
        n18 = n12;
        while (n18 < n2) {
            this.pixels[n18] = (byte)this.bgIndex;
            ++n18;
        }
    }

    private final Image render(ColorTable colorTable) {
        int n;
        byte[] byArray = new byte[this.width * this.height];
        if (this.lastDispose == 0 || this.lastDispose == 2) {
            n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)this.transIndex;
                ++n;
            }
        } else {
            if (this.lastDispose == 3) {
                this.lastDest = this.lastLastDest;
            }
            if (this.lastDest != null) {
                System.arraycopy(this.lastDest, 0, byArray, 0, byArray.length);
            }
        }
        n = 1;
        int n2 = 8;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.ih) {
            int n5 = n4;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 2;
                        }
                    }
                }
                n5 = n3;
                n3 += n2;
            }
            if ((n5 += this.iy) < this.height) {
                int n6 = n5 * this.width;
                int n7 = n6 + this.ix;
                int n8 = n7 + this.iw;
                if (n6 + this.width < n8) {
                    n8 = n6 + this.width;
                }
                int n9 = n4 * this.iw;
                while (n7 < n8) {
                    int n10 = this.pixels[n9] & 0xFF;
                    if (n10 != this.transIndex) {
                        byArray[n7] = this.pixels[n9];
                    }
                    ++n9;
                    ++n7;
                }
            }
            ++n4;
        }
        this.lastLastDest = this.lastDest;
        this.lastDest = byArray;
        IndexColorModel indexColorModel = new IndexColorModel(8, colorTable.length, colorTable.r, colorTable.g, colorTable.b, this.transIndex);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)indexColorModel, byArray, 0, this.width));
    }

    private final void readExt() throws Exception {
        int n = this.u1();
        switch (n) {
            case 249: {
                this.readGraphicControlExt();
                break;
            }
            case 255: {
                this.readBlock();
                String string = "";
                int n2 = 0;
                while (n2 < 11) {
                    string = string + (char)this.block[n2];
                    ++n2;
                }
                if (string.equals("NETSCAPE2.0")) {
                    this.readNetscapeExt();
                    break;
                }
                this.skip();
                break;
            }
            default: {
                this.skip();
            }
        }
    }

    private final void readGraphicControlExt() throws Exception {
        boolean bl;
        int n = this.u1();
        int n2 = this.u1();
        this.delay = this.u2() * 10;
        int n3 = this.u1();
        int n4 = this.u1();
        this.dispose = n2 >> 2 & 3;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.delay = Math.max(100, this.delay);
        boolean bl2 = false;
        if ((n2 & 1) != 0) {
            bl2 = true;
        }
        if (bl = bl2) {
            this.transIndex = n3;
        }
    }

    private final void readNetscapeExt() throws Exception {
        int n;
        this.readBlock();
        if (this.blockSize > 0 && this.block[0] == 1) {
            n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.animator.loopCount = n2 << 8 | n;
        }
        n = this.u1();
    }

    private final void skip() throws Exception {
        int n;
        while ((n = this.u1()) != 0) {
            this.pos += n;
        }
    }

    private final int u1() throws Exception {
        if (this.pos >= this.dataSize) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF;
    }

    private final int u2() throws Exception {
        return this.u1() | this.u1() << 8;
    }

    private final int rgb() throws Exception {
        return (this.u1() << 16) + (this.u1() << 8) + this.u1();
    }

    private final int readBlock() throws Exception {
        this.blockSize = this.u1();
        int n = this.blockSize;
        if (n + this.pos >= this.dataSize) {
            throw new EOFException();
        }
        System.arraycopy(this.data, this.pos, this.block, 0, n);
        this.pos += n;
        return n;
    }

    private final IOException err() {
        return new IOException("Invalid GIF format");
    }

    public Image getImage() {
        return this.image;
    }

    public ImageAnimator getAnimator() {
        return this.animator;
    }

    private final /* synthetic */ void this() {
        this.animator = new GifAnimator();
        this.delay = -1;
        this.transIndex = -1;
        this.dispose = 0;
        this.lastDispose = 0;
        this.block = new byte[256];
    }

    public GifDecoder() {
        this.this();
    }

    static class ColorTable {
        byte[] r;
        byte[] g;
        byte[] b;
        int length;

        ColorTable() {
        }
    }
}

