/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class DisabledImageFactory
extends RGBImageFilter {
    static final DisabledImageFactory filter = new DisabledImageFactory();
    static final Component component = new Component(){};
    static final MediaTracker tracker = new MediaTracker(component);
    protected static final int OUTLINE_COLOR = -10066330;
    protected float[] hsb;
    protected int[][] pixels;
    protected int width;
    protected int height;

    public static synchronized Image convert(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), filter);
        Image image2 = component.createImage(filteredImageSource);
        tracker.addImage(image2, 0);
        try {
            tracker.waitForID(0, 0L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("DisabledImageFactory.convert -> interrupted");
        }
        tracker.removeImage(image2, 0);
        return image2;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.pixels = new int[n][n2];
        this.width = n;
        this.height = n2;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        n4 = n4 >> 2 & 0xFF;
        int n5 = n4 << 24 | n3 & 0xFFFFFF;
        this.pixels[n][n2] = n5;
        return n5;
    }

    private DisabledImageFactory() {
        this.canFilterIndexColorModel = false;
    }
}

