/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.ImageData;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.baja.gx.Graphics;

public final class AwtImagePeer
implements ImagePeer {
    public final ImageData data;

    public final Image image() {
        return this.data.getAnimatedImage();
    }

    public final Graphics getGraphics() {
        return this.data.getGraphics();
    }

    public final double getWidth() {
        return this.data.getWidth();
    }

    public final double getHeight() {
        return this.data.getHeight();
    }

    public final int[] getPixels() {
        int n = (int)this.data.getWidth();
        int n2 = (int)this.data.getHeight();
        int[] nArray = new int[n * n2];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(this.data.image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {}
        return nArray;
    }

    public final void setPixels(int[] nArray) {
        if (this.data.image instanceof BufferedImage) {
            int n;
            int n2 = (int)this.data.getWidth();
            if (nArray.length != n2 * (n = (int)this.data.getHeight())) {
                throw new IllegalStateException("AwtImagePeer.setPixels: pixels.length != width x height");
            }
            BufferedImage bufferedImage = (BufferedImage)this.data.image;
            bufferedImage.setRGB(0, 0, n2, n, nArray, 0, n2);
        } else {
            System.out.println("AwtImagePeer.setPixels: Can not set pixels for non-memory images.");
        }
    }

    public final void dispose() {
        this.data.dispose();
    }

    public final boolean isLoaded() {
        return this.data.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sync() {
        if (this.data.loaded) {
            return;
        }
        ImageData imageData = this.data;
        synchronized (imageData) {
            while (!this.data.loaded) {
                try {
                    this.data.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public final boolean animate() {
        return this.data.animate();
    }

    public AwtImagePeer(ImageData imageData) {
        this.data = imageData;
    }

    AwtImagePeer(Image image) {
        this(new ImageData(image));
    }
}

