/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.awt.AwtEnv;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AwtGraphics
implements Graphics {
    protected BFont font;
    protected BBrush brush;
    protected BPen pen;
    protected Graphics2D g;
    Stack stack;

    public final Graphics2D getAwtGraphics() {
        return this.g;
    }

    public final BBrush getBrush() {
        return this.brush;
    }

    public final void setBrush(BColor bColor) {
        this.setBrush(bColor.toBrush());
    }

    public final BPen getPen() {
        return this.pen;
    }

    public final BFont getFont() {
        return this.font;
    }

    public final void setFont(BFont bFont) {
        this.font = bFont;
        this.g.setFont(AwtEnv.peer((BFont)bFont).awtFont);
    }

    public final IGeom getClip() {
        return this.getClipBounds();
    }

    public final IRectGeom getClipBounds() {
        Rectangle rectangle = this.g.getClipRect();
        return new RectGeom(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void clip(IGeom iGeom) {
        IRectGeom iRectGeom = DefaultGeomPeer.toRect(iGeom);
        this.clip(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public void drawString(String string, double d, double d2) {
        if (string == null) {
            return;
        }
        this.g.drawString(string, (int)d, (int)d2);
        if (this.font.isUnderline()) {
            this.drawUnderline(string, d, d2);
        }
    }

    public void drawString(char[] cArray, int n, int n2, double d, double d2) {
        this.g.drawChars(cArray, n, n2, (int)d, (int)d2);
        if (this.font.isUnderline()) {
            this.drawUnderline(new String(cArray, n, n2), d, d2);
        }
    }

    public final void drawImage(BImage bImage, double d, double d2) {
        Image image = AwtEnv.peer(bImage).image();
        if (image != null) {
            this.g.drawImage(image, (int)d, (int)d2, null);
        }
    }

    private final void drawUnderline(String string, double d, double d2) {
        int n = (int)this.font.width(string);
        this.g.drawLine((int)d, (int)d2 + 2, (int)d + n, (int)d2 + 2);
    }

    public void push() {
        this.stack.push(this.g.create());
    }

    public void pop() {
        if (!this.stack.empty()) {
            this.g.dispose();
            this.g = (Graphics2D)this.stack.pop();
        }
    }

    public final void dispose() {
        this.g.dispose();
        this.g = null;
        while (!this.stack.empty()) {
            this.g = (Graphics2D)this.stack.pop();
            this.g.dispose();
            this.g = null;
        }
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
    }

    public AwtGraphics(Graphics2D graphics2D) {
        this.this();
        this.g = graphics2D;
        this.brush = BBrush.DEFAULT;
        this.font = BFont.DEFAULT;
        this.pen = BPen.DEFAULT;
    }
}

