/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.AwtFontPeer;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.DisabledImageFactory;
import com.tridium.gx.awt.HighlightedImageFactory;
import com.tridium.gx.awt.ImageData;
import com.tridium.gx.awt.ImageManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;

public abstract class AwtEnv
extends GxEnv {
    public static Color TRANSPARENT = new Color(255, 255, 255, 0);

    public static GxEnv get() {
        return (AwtEnv)GxEnv.get();
    }

    public abstract Graphics makeGraphics(Graphics2D var1);

    public abstract Image makeBufferedImage(double var1, double var3);

    public FontPeer makeFontPeer(BFont bFont) {
        return AwtEnv.peer(bFont);
    }

    public ImagePeer makeImagePeer(BImage bImage) {
        return AwtEnv.peer(bImage);
    }

    public BImage makeImage(byte[] byArray) {
        return this.makeImage(Toolkit.getDefaultToolkit().createImage(byArray), true);
    }

    public BImage makeImage(Image image, boolean bl) {
        if (bl) {
            ImageManager.sync(image);
        }
        BImage bImage = BImage.make("new");
        bImage.fw(202, new AwtImagePeer(image), null, null, null);
        return bImage;
    }

    public BImage makeImage(double d, double d2) {
        Image image = ((AwtEnv)AwtEnv.get()).makeBufferedImage(d, d2);
        BImage bImage = BImage.make("new");
        bImage.fw(202, new AwtImagePeer(image), null, null, null);
        return bImage;
    }

    public BImage makeDisabled(BImage bImage) {
        Image image = AwtEnv.peer(bImage).image();
        if (image == null) {
            return bImage;
        }
        BImage bImage2 = BImage.make("new");
        bImage2.fw(202, new AwtImagePeer(DisabledImageFactory.convert(image)), null, null, null);
        return bImage2;
    }

    public BImage makeHighlighted(BImage bImage) {
        Image image = AwtEnv.peer(bImage).image();
        if (image == null) {
            return bImage;
        }
        BImage bImage2 = BImage.make("new");
        bImage2.fw(202, new AwtImagePeer(HighlightedImageFactory.convert(image)), null, null, null);
        return bImage2;
    }

    public static Color peer(BColor bColor) {
        Color color = (Color)bColor.fw(201, null, null, null, null);
        if (color == null) {
            color = AwtEnv.makePeer(bColor);
            bColor.fw(202, color, null, null, null);
        }
        return color;
    }

    public static AwtFontPeer peer(BFont bFont) {
        AwtFontPeer awtFontPeer = (AwtFontPeer)bFont.fw(201, null, null, null, null);
        if (awtFontPeer == null) {
            String string = AwtEnv.get().getValidFontName(bFont.getName());
            if (string == null) {
                string = bFont.getName();
            }
            awtFontPeer = new AwtFontPeer(bFont, string);
            bFont.fw(202, awtFontPeer, null, null, null);
        }
        return awtFontPeer;
    }

    public static AwtImagePeer peer(BImage bImage) {
        AwtImagePeer awtImagePeer = (AwtImagePeer)bImage.fw(201, null, null, null, null);
        if (awtImagePeer == null) {
            ImageData imageData = ImageManager.fetchImageData(bImage);
            awtImagePeer = new AwtImagePeer(imageData);
            bImage.fw(202, awtImagePeer, null, null, null);
        }
        return awtImagePeer;
    }

    private static final Color makePeer(BColor bColor) {
        if (bColor.isNull()) {
            return TRANSPARENT;
        }
        return new Color(bColor.getRGB(), true);
    }
}

