/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.GeomPeer;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BDouble;

public abstract class DefaultGeomPeer
implements GeomPeer,
IRectGeom {
    public static DefaultGeomPeer make(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)iGeom);
            }
            case 2: {
                return new Rect((IRectGeom)iGeom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)iGeom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)iGeom);
            }
            case 5: {
                return new Path((IPathGeom)iGeom);
            }
        }
        throw new UnsupportedOperationException("No GeomPeer support for " + iGeom.getClass().getName());
    }

    public int getGeomCase() {
        return 2;
    }

    public abstract double x();

    public abstract double y();

    public abstract double width();

    public abstract double height();

    public abstract IGeom geom();

    public IRectGeom bounds() {
        return this;
    }

    public boolean contains(double d, double d2) {
        double d3 = this.x();
        double d4 = this.y();
        double d5 = d3 + this.width();
        double d6 = d4 + this.height();
        boolean bl = false;
        if (d3 <= d && d4 <= d2 && d <= d5 && d2 <= d6) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(IGeom iGeom) {
        IRectGeom iRectGeom = DefaultGeomPeer.toRect(iGeom);
        return this.contains(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = this.x();
        double d6 = this.y();
        double d7 = d5 + this.width();
        double d8 = d6 + this.height();
        boolean bl = false;
        if (d5 <= d && d6 <= d2 && d <= d7 && d2 <= d8) {
            bl = true;
        }
        boolean bl2 = bl;
        d += d3;
        d2 += d4;
        boolean bl3 = false;
        if (d5 <= d && d6 <= d2 && d <= d7 && d2 <= d8) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (bl2 && bl4) {
            bl5 = true;
        }
        return bl5;
    }

    public boolean intersects(IGeom iGeom) {
        IRectGeom iRectGeom = DefaultGeomPeer.toRect(iGeom);
        return this.intersects(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.x();
        double d6 = this.y();
        double d7 = d5 + this.width();
        double d8 = d6 + this.height();
        double d9 = d + d3;
        double d10 = d2 + d4;
        if (d5 < d) {
            d5 = d;
        }
        if (d6 < d2) {
            d6 = d2;
        }
        if (d7 > d9) {
            d7 = d9;
        }
        if (d8 > d10) {
            d8 = d10;
        }
        d7 -= d5;
        d8 -= d6;
        boolean bl = false;
        if (d7 > 0.0 && d8 > 0.0) {
            bl = true;
        }
        return bl;
    }

    public IGeom intersection(IGeom iGeom) {
        return this.intersection(DefaultGeomPeer.toRect(iGeom));
    }

    public IGeom intersection(IRectGeom iRectGeom) {
        return RectGeom.intersection(this, iRectGeom, null);
    }

    public IGeom intersection(double d, double d2, double d3, double d4) {
        return RectGeom.intersection(this.x(), this.y(), this.width(), this.height(), d, d2, d3, d4, null);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        return this;
    }

    public String toString() {
        return "GeomPeer[" + BDouble.encode((double)this.x()) + ',' + BDouble.encode((double)this.y()) + ',' + BDouble.encode((double)this.width()) + ',' + BDouble.encode((double)this.height()) + ']';
    }

    public static IRectGeom toRect(IGeom iGeom) {
        if (iGeom instanceof IRectGeom) {
            return (IRectGeom)iGeom;
        }
        return iGeom.bounds();
    }

    public static class Line
    extends DefaultGeomPeer {
        public final ILineGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }

        Line(ILineGeom iLineGeom) {
            this.geom = iLineGeom;
        }
    }

    public static class Rect
    extends DefaultGeomPeer {
        public final IRectGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }

        Rect(IRectGeom iRectGeom) {
            this.geom = iRectGeom;
        }
    }

    public static class Ellipse
    extends DefaultGeomPeer {
        public final IEllipseGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }

        Ellipse(IEllipseGeom iEllipseGeom) {
            this.geom = iEllipseGeom;
        }
    }

    public static class Polygon
    extends DefaultGeomPeer {
        public final IPolygonGeom geom;
        double x;
        double y;
        double w;
        double h;

        public final IGeom geom() {
            return this.geom;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double width() {
            return this.w;
        }

        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            int n = this.geom.size();
            if (n == 0) {
                return;
            }
            this.x = Double.POSITIVE_INFINITY;
            this.y = Double.POSITIVE_INFINITY;
            this.w = Double.NEGATIVE_INFINITY;
            this.h = Double.NEGATIVE_INFINITY;
            int n2 = 0;
            while (n2 < n) {
                double d = this.geom.x(n2);
                double d2 = this.geom.y(n2);
                this.x = Math.min(this.x, d);
                this.y = Math.min(this.y, d2);
                this.w = Math.max(this.w, d);
                this.h = Math.max(this.h, d2);
                ++n2;
            }
            this.w -= this.x;
            this.h -= this.y;
        }

        Polygon(IPolygonGeom iPolygonGeom) {
            this.geom = iPolygonGeom;
            this.computeBounds();
        }
    }

    public static class Path
    extends DefaultGeomPeer {
        IPathGeom geom;
        double x;
        double y;
        double w;
        double h;

        public final IGeom geom() {
            return this.geom;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double width() {
            return this.w;
        }

        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            double d5 = Double.NaN;
            double d6 = Double.NaN;
            int n = 0;
            while (n < this.geom.segments().length) {
                IPathGeom.Segment segment = this.geom.segment(n);
                if (!(segment instanceof IPathGeom.ClosePath)) {
                    IPathGeom.Segment segment2;
                    if (segment instanceof IPathGeom.MoveTo) {
                        segment2 = (IPathGeom.MoveTo)segment;
                        if (segment2.isAbsolute()) {
                            d = ((IPathGeom.MoveTo)segment2).getX();
                            d2 = ((IPathGeom.MoveTo)segment2).getY();
                        } else {
                            d += ((IPathGeom.MoveTo)segment2).getX();
                            d2 += ((IPathGeom.MoveTo)segment2).getY();
                        }
                        d3 = Double.isNaN(d3) ? d : Math.min(d3, d);
                        d4 = Double.isNaN(d4) ? d : Math.max(d4, d);
                        d5 = Double.isNaN(d5) ? d2 : Math.min(d5, d2);
                        d6 = Double.isNaN(d6) ? d2 : Math.max(d6, d2);
                    } else if (segment instanceof IPathGeom.LineTo) {
                        segment2 = (IPathGeom.LineTo)segment;
                        if (segment2.isAbsolute()) {
                            d = ((IPathGeom.LineTo)segment2).getX();
                            d2 = ((IPathGeom.LineTo)segment2).getY();
                        } else {
                            d += ((IPathGeom.LineTo)segment2).getX();
                            d2 += ((IPathGeom.LineTo)segment2).getY();
                        }
                        d3 = Double.isNaN(d3) ? d : Math.min(d3, d);
                        d4 = Double.isNaN(d4) ? d : Math.max(d4, d);
                        d5 = Double.isNaN(d5) ? d2 : Math.min(d5, d2);
                        d6 = Double.isNaN(d6) ? d2 : Math.max(d6, d2);
                    } else if (segment instanceof IPathGeom.HLineTo) {
                        segment2 = (IPathGeom.HLineTo)segment;
                        d = segment2.isAbsolute() ? ((IPathGeom.HLineTo)segment2).getX() : (d += ((IPathGeom.HLineTo)segment2).getX());
                        d3 = Double.isNaN(d3) ? d : Math.min(d3, d);
                        d4 = Double.isNaN(d4) ? d : Math.max(d4, d);
                    } else if (segment instanceof IPathGeom.VLineTo) {
                        segment2 = (IPathGeom.VLineTo)segment;
                        d2 = segment2.isAbsolute() ? ((IPathGeom.VLineTo)segment2).getY() : (d2 += ((IPathGeom.VLineTo)segment2).getY());
                        d5 = Double.isNaN(d5) ? d2 : Math.min(d5, d2);
                        d6 = Double.isNaN(d6) ? d2 : Math.max(d6, d2);
                    } else if (segment instanceof IPathGeom.CurveTo) {
                        segment2 = (IPathGeom.CurveTo)segment;
                        if (segment2.isAbsolute()) {
                            d3 = Double.isNaN(d3) ? ((IPathGeom.CurveTo)segment2).getX1() : Math.min(d3, ((IPathGeom.CurveTo)segment2).getX1());
                            d4 = Double.isNaN(d4) ? ((IPathGeom.CurveTo)segment2).getX1() : Math.max(d4, ((IPathGeom.CurveTo)segment2).getX1());
                            d5 = Double.isNaN(d5) ? ((IPathGeom.CurveTo)segment2).getY1() : Math.min(d5, ((IPathGeom.CurveTo)segment2).getY1());
                            d6 = Double.isNaN(d6) ? ((IPathGeom.CurveTo)segment2).getY1() : Math.max(d6, ((IPathGeom.CurveTo)segment2).getY1());
                            d3 = Double.isNaN(d3) ? ((IPathGeom.CurveTo)segment2).getX2() : Math.min(d3, ((IPathGeom.CurveTo)segment2).getX2());
                            d4 = Double.isNaN(d4) ? ((IPathGeom.CurveTo)segment2).getX2() : Math.max(d4, ((IPathGeom.CurveTo)segment2).getX2());
                            d5 = Double.isNaN(d5) ? ((IPathGeom.CurveTo)segment2).getY2() : Math.min(d5, ((IPathGeom.CurveTo)segment2).getY2());
                            d6 = Double.isNaN(d6) ? ((IPathGeom.CurveTo)segment2).getY2() : Math.max(d6, ((IPathGeom.CurveTo)segment2).getY2());
                        } else {
                            d3 = Double.isNaN(d3) ? d + ((IPathGeom.CurveTo)segment2).getX1() : Math.min(d3, d + ((IPathGeom.CurveTo)segment2).getX1());
                            d4 = Double.isNaN(d4) ? d + ((IPathGeom.CurveTo)segment2).getX1() : Math.max(d4, d + ((IPathGeom.CurveTo)segment2).getX1());
                            d5 = Double.isNaN(d5) ? d2 + ((IPathGeom.CurveTo)segment2).getY1() : Math.min(d5, d2 + ((IPathGeom.CurveTo)segment2).getY1());
                            d6 = Double.isNaN(d6) ? d2 + ((IPathGeom.CurveTo)segment2).getY1() : Math.max(d6, d2 + ((IPathGeom.CurveTo)segment2).getY1());
                            d3 = Double.isNaN(d3) ? d + ((IPathGeom.CurveTo)segment2).getX2() : Math.min(d3, d + ((IPathGeom.CurveTo)segment2).getX2());
                            d4 = Double.isNaN(d4) ? d + ((IPathGeom.CurveTo)segment2).getX2() : Math.max(d4, d + ((IPathGeom.CurveTo)segment2).getX2());
                            d5 = Double.isNaN(d5) ? d2 + ((IPathGeom.CurveTo)segment2).getY2() : Math.min(d5, d2 + ((IPathGeom.CurveTo)segment2).getY2());
                            double d7 = d6 = Double.isNaN(d6) ? d2 + ((IPathGeom.CurveTo)segment2).getY2() : Math.max(d6, d2 + ((IPathGeom.CurveTo)segment2).getY2());
                        }
                        if (segment2.isAbsolute()) {
                            d = ((IPathGeom.CurveTo)segment2).getX();
                            d2 = ((IPathGeom.CurveTo)segment2).getY();
                        } else {
                            d += ((IPathGeom.CurveTo)segment2).getX();
                            d2 += ((IPathGeom.CurveTo)segment2).getY();
                        }
                        d3 = Double.isNaN(d3) ? d : Math.min(d3, d);
                        d4 = Double.isNaN(d4) ? d : Math.max(d4, d);
                        d5 = Double.isNaN(d5) ? d2 : Math.min(d5, d2);
                        d6 = Double.isNaN(d6) ? d2 : Math.max(d6, d2);
                    }
                }
                ++n;
            }
            this.x = d3;
            this.y = d5;
            this.w = d4 - d3;
            this.h = d6 - d5;
        }

        Path(IPathGeom iPathGeom) {
            this.geom = iPathGeom;
            this.computeBounds();
        }
    }
}

