/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxSession;
import com.tridium.sys.Nre;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import com.tridium.videoDriver.videoStream.fox.FoxVideoConnection;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import java.io.IOException;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StationSideVideoSession
implements IVideoDestination,
FoxAsyncCallbacks,
Runnable {
    protected static long ticksLastCpuTrace = 0L;
    protected static final int MAX_CPU_BACKOFF_INTERVAL = 1000;
    protected static final int ONE_HOURS_WORTH_OF_TICKS = 3600000;
    protected static final int TEN_SECONDS_WORTH_OF_TICKS = 10000;
    protected static Log log = Log.getLog((String)"fox.stationVideoSessions");
    protected static Log xferLog = Log.getLog((String)"fox.stationVideoSessions.transfer");
    protected static Log cpulog = Log.getLog((String)"fox.stationVideoSessions.cpu");
    protected long lastChunkToGuiTicks;
    protected IVideoStream driverVideoStream;
    protected String videoClientId;
    protected int videoStreamId;
    protected BPlaybackParams playbackParams;
    protected StationSideVideoCoordinator stationSideVideoCoordinator;
    protected byte[] receiveBuffer;
    protected BFoxVideoSource foxVideoSource;
    protected Object sendToGuiMonitor;
    protected boolean running;
    protected boolean closed;
    protected boolean paused;
    protected boolean closedEarly;
    protected Thread myThread;
    protected int cpuBackoffInterval;
    protected long ticksLastCpuBackoff;

    public String getVideoClientId() {
        return this.videoClientId;
    }

    public int getVideoStreamId() {
        return this.videoStreamId;
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public BFoxVideoSource getFoxVideoSource() {
        return this.foxVideoSource;
    }

    public StationSideVideoCoordinator getStationSideVideoCoordinator() {
        return this.stationSideVideoCoordinator;
    }

    public void receiveVideoStream(IVideoStream iVideoStream) {
        if (log.isTraceOn()) {
            this.trace(log, "Received video stream for underlying video driver. " + this.closed);
        }
        this.driverVideoStream = iVideoStream;
        this.playbackParams = iVideoStream.getPlaybackParams();
        if (this.closed) {
            if (this.stationSideVideoCoordinator.log.isTraceOn()) {
                this.stationSideVideoCoordinator.log.trace("Received stream from driver after the video stream was closed. Video client = " + this.videoClientId + ". Video stream = " + this.videoStreamId);
            }
            try {
                iVideoStream.closeVideoStream();
                this.stationSideVideoCoordinator.closeVideoStream(this.getVideoClientId(), this.getVideoStreamId());
            }
            catch (IOException iOException) {
                if (log.isTraceOn()) {
                    this.trace(log, "Error closing late stream", iOException);
                }
            }
        } else {
            this.startStationSideVideoSession();
        }
    }

    public void videoStreamTimeout() {
        if (log.isTraceOn()) {
            this.trace(log, "Video stream timeout from underlying video driver.");
        }
        if (this.stationSideVideoCoordinator.log.isTraceOn()) {
            this.stationSideVideoCoordinator.log.trace("Driver notified session of video stream timeout. Video client id = " + this.videoClientId + " Video stream = " + this.getVideoStreamId());
        }
        try {
            this.stationSideVideoCoordinator.videoSessionTimeOut(this);
        }
        catch (Exception exception) {
            log.error("Unable to notify client that its video stream timed out:  " + exception);
        }
    }

    public IVideoSession getVideoSession() {
        return null;
    }

    public IVideoDecoder getVideoDecoder() {
        return null;
    }

    public byte[] getReceiveBuffer() {
        return this.receiveBuffer;
    }

    public void startStationSideVideoSession() {
        if (!this.running) {
            if (log.isTraceOn()) {
                this.trace(log, "startStationSideVideoSession()");
            }
            this.running = true;
            this.myThread = new Thread((Runnable)this, "Fox:VideoSession:" + this.getVideoClientId() + '.' + this.getVideoStreamId());
            this.myThread.start();
        }
    }

    public void watchdog(Log log) {
        block5: {
            if (log.isTraceOn()) {
                this.trace(log, "watchdog check. videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId);
            }
            if (Clock.ticks() - this.lastChunkToGuiTicks >= 30000L) {
                if (log.isTraceOn()) {
                    this.trace(log, "Too much time has elapsed. Closing video session videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId);
                }
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    if (!log.isTraceOn()) break block5;
                    this.trace(log, "IOException occurred while closing video session videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId, iOException);
                }
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        block11: {
            if (log.isTraceOn()) {
                this.trace(log, "close", null);
            }
            this.closed = true;
            Object object = this.sendToGuiMonitor;
            synchronized (object) {
                this.sendToGuiMonitor.notifyAll();
            }
            try {
                if (this.driverVideoStream == null) {
                    if (log.isTraceOn()) {
                        this.closedEarly = true;
                        this.trace(log, "Closed before receiving video stream.");
                    }
                    break block11;
                }
                this.driverVideoStream.closeVideoStream();
            }
            catch (IOException iOException) {
                log.error("IO Exception closing driver video stream", (Throwable)iOException);
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                log.error("Runtime Exception closing driver video stream", (Throwable)runtimeException);
                throw runtimeException;
            }
        }
        this.running = false;
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.myThread != null && !this.myThread.isAlive()) {
            this.receiveBuffer = null;
            this.playbackParams = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void asyncMessageSent(FoxSession foxSession, FoxMessage foxMessage) {
        if (xferLog.isTraceOn()) {
            this.trace(xferLog, "[" + Clock.ticks() + "]Chunk was transmitted. Video client id = " + this.videoClientId);
        }
        Object object = this.sendToGuiMonitor;
        synchronized (object) {
            this.sendToGuiMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (log.isTraceOn()) {
                this.trace(log, "Running", null);
            }
            boolean bl = true;
            while (this.running && !this.closed) {
                try {
                    Object var6_4;
                    if (this.paused) {
                        Thread.sleep(100L);
                        continue;
                    }
                    this.stationSideVideoCoordinator.getVideoSessionsWatchdog().startWatchingSession(this);
                    try {
                        this.transferOneChunk(bl);
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        var6_4 = null;
                        this.stationSideVideoCoordinator.getVideoSessionsWatchdog().stopWatchingSession(this);
                        throw throwable;
                    }
                    {
                        var6_4 = null;
                        this.stationSideVideoCoordinator.getVideoSessionsWatchdog().stopWatchingSession(this);
                    }
                    long l = Clock.ticks();
                    int n = Nre.getPlatform().getCpuUsage();
                    if (n > 75) {
                        if (l - this.ticksLastCpuBackoff >= (long)this.cpuBackoffInterval) {
                            if (l - this.ticksLastCpuBackoff >= 3600000L) {
                                cpulog.message("Excessive CPU utilization. Slowing down fox video stream mechanism. cpuBackoffInterval = " + this.cpuBackoffInterval);
                            }
                            this.ticksLastCpuBackoff = l;
                            Thread.sleep(100L);
                            this.cpuBackoffInterval = this.cpuBackoffInterval / 2 + 1;
                        }
                    } else if (l - this.ticksLastCpuBackoff >= (long)this.cpuBackoffInterval) {
                        if (this.cpuBackoffInterval < 1000) {
                            this.cpuBackoffInterval *= 2;
                        }
                        if (this.cpuBackoffInterval > 1000) {
                            this.cpuBackoffInterval = 1000;
                        }
                    }
                    if (!cpulog.isTraceOn() || l - ticksLastCpuTrace <= 10000L) continue;
                    ticksLastCpuTrace = l;
                    this.trace(cpulog, "Streaming video. CPU utilization = " + n + "  cpuBackoffInterval = " + this.cpuBackoffInterval);
                }
                catch (Exception exception) {
                    if (log.isTraceOn()) {
                        this.trace(log, "Exception occurred transferring a chunk of video Video Client Id = " + this.getVideoClientId() + " Video stream Id = " + this.getVideoStreamId(), exception);
                    }
                    this.running = false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            if (log.isTraceOn()) {
                this.trace(log, "finished running", null);
            }
            try {
                this.close();
                this.receiveBuffer = null;
                this.playbackParams = null;
                throw throwable;
            }
            catch (IOException iOException) {
                log.error("Error closing/de-allocating driver video stream", (Throwable)iOException);
            }
            throw throwable;
        }
        {
            Object var2_9 = null;
        }
        if (log.isTraceOn()) {
            this.trace(log, "finished running", null);
        }
        try {}
        catch (IOException iOException) {
            log.error("Error closing/de-allocating driver video stream", (Throwable)iOException);
            return;
        }
        this.close();
        this.receiveBuffer = null;
        this.playbackParams = null;
    }

    protected void trace(Log log, String string) {
        log.trace(this.videoClientId + "{vsId:" + this.videoStreamId + '}' + string);
    }

    protected void trace(Log log, String string, Exception exception) {
        log.trace(this.videoClientId + "{vsId:" + this.videoStreamId + '}' + string, (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void transferOneChunk(boolean bl) throws Exception {
        FoxVideoConnection foxVideoConnection = this.stationSideVideoCoordinator.connectionToClient;
        if (foxVideoConnection == null) {
            throw new IllegalStateException("Fox video connection is null.");
        }
        int n = 0;
        if (xferLog.isTraceOn()) {
            this.trace(xferLog, "[" + Clock.ticks() + "]Reading 4K chunk from driver stream. Video stream id = " + this.getVideoStreamId() + " Video client id = " + this.getVideoClientId());
        }
        try {
            n = this.driverVideoStream.getInputStream().read(this.getReceiveBuffer());
        }
        catch (Exception exception) {
            if (xferLog.isTraceOn()) {
                this.trace(xferLog, "Exception while reading chunk of video from driver: ", exception);
            }
            n = -1;
        }
        if (this.closed) {
            return;
        }
        if (n > 0) {
            if (xferLog.isTraceOn()) {
                this.trace(xferLog, "[" + Clock.ticks() + "]Sending chunk to Gui client. Size=" + n + " Video stream id = " + this.getVideoStreamId() + " Video client id = " + foxVideoConnection.getVideoClientId());
            }
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("msgType", "videoFrameData");
            foxMessage.add("videoStreamId", this.getVideoStreamId());
            if (bl) {
                foxMessage.add("playbackParams", ValueDocEncoder.marshal((BValue)this.playbackParams));
            }
            foxMessage.add("videoFrameChunk", this.getReceiveBuffer(), n);
            Object object = this.sendToGuiMonitor;
            synchronized (object) {
                foxVideoConnection.writeChunkToCircuit(this, foxMessage, this.getVideoStreamId());
                this.sendToGuiMonitor.wait(10000L);
                this.lastChunkToGuiTicks = Clock.ticks();
                return;
            }
        }
        if (n != 0) {
            this.stationSideVideoCoordinator.closeVideoStream(foxVideoConnection.getVideoClientId(), this.getVideoStreamId());
            throw new IOException("Stream closed closed while reading block of video for Workbench client. Video stream id = " + this.getVideoStreamId() + " Video client id = " + foxVideoConnection.getVideoClientId());
        }
        if (xferLog.isTraceOn()) {
            this.trace(xferLog, "Call to read from underlying video stream returned with zero bytes. Video stream id = " + this.getVideoStreamId() + " Video client id = " + foxVideoConnection.getVideoClientId());
        }
        Thread.sleep(100L);
    }

    private final /* synthetic */ void this() {
        this.lastChunkToGuiTicks = Clock.ticks();
        this.receiveBuffer = new byte[4096];
        this.sendToGuiMonitor = new Object();
        this.running = false;
        this.closed = false;
        this.paused = false;
        this.closedEarly = false;
        this.cpuBackoffInterval = 1000;
        this.ticksLastCpuBackoff = 0L;
    }

    protected StationSideVideoSession(StationSideVideoCoordinator stationSideVideoCoordinator, BFoxVideoSource bFoxVideoSource, BPlaybackParams bPlaybackParams, String string, int n) {
        this.this();
        this.stationSideVideoCoordinator = stationSideVideoCoordinator;
        this.foxVideoSource = bFoxVideoSource;
        this.playbackParams = bPlaybackParams;
        this.videoClientId = string;
        this.videoStreamId = n;
    }

    protected StationSideVideoSession() {
        this.this();
    }
}

