/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.MessageWriter;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoSession;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.OutputStream;
import javax.baja.log.Log;

public class FoxVideoConnection {
    protected static Log log = Log.getLog((String)"fox.clientVideoConnections");
    protected String videoClientId;
    protected StationSideVideoCoordinator videoCoordinator;
    protected FoxCircuit circuit;

    protected void connectionClosed() {
    }

    public FoxCircuit getCircuit() {
        return this.circuit;
    }

    public void sendTimeout(StationSideVideoSession stationSideVideoSession) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("videoStreamId", stationSideVideoSession.getVideoStreamId());
        foxMessage.add("msgType", "timeout");
        foxMessage.add("videoStreamTimeout", true);
        this.circuit.writeMessage(foxMessage);
    }

    protected void writeChunkToCircuit(StationSideVideoSession stationSideVideoSession, FoxMessage foxMessage, int n) throws Exception {
        if (this.circuit.session().isClosed()) {
            this.videoCoordinator.closeVideoStream(this.videoClientId, n);
            throw new EOFException("Circuit to client closed in the middle of sending video frames. Video stream id = " + n + " Video client id = " + this.videoClientId);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageWriter messageWriter = new MessageWriter((OutputStream)byteArrayOutputStream);
        foxMessage.writeValue(messageWriter);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (log.isTraceOn()) {
            log.trace("Sending chunk to workbench. Video stream id = " + n + " Video client id = " + this.videoClientId);
        }
        this.circuit.write(byArray, 0, byArray.length, (FoxAsyncCallbacks)stationSideVideoSession);
        if (log.isTraceOn()) {
            log.trace("Video session now busy...waiting for chunk to be transmitted. Video stream id = " + n + " Video client id = " + this.videoClientId);
        }
    }

    public String getVideoClientId() {
        return this.videoClientId;
    }

    protected FoxVideoConnection(StationSideVideoCoordinator stationSideVideoCoordinator, FoxCircuit foxCircuit, String string) {
        this.videoCoordinator = stationSideVideoCoordinator;
        this.circuit = foxCircuit;
        this.videoClientId = string;
    }

    protected FoxVideoConnection() {
    }
}

