/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import com.tridium.videoDriver.videoStream.fox.ClientVideoInputStream;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BInteger;

public class ClientSideVideoReceiver
extends Thread {
    protected static Log log = Log.getLog((String)"fox.clientVideoReceivers");
    public static final long _256KB = 262144L;
    protected boolean running;
    protected boolean done;
    protected BFoxVideoChannel foxVideoChannel;
    protected String videoClientId;
    protected FoxCircuit foxCircuit;
    protected IntHashMap videoPlayerStreams;

    public String getVideoClientId() {
        return this.videoClientId;
    }

    public ClientVideoInputStream getInputStream(int n, IVideoDestination iVideoDestination, FoxVideoStream foxVideoStream) {
        ClientVideoInputStream clientVideoInputStream = (ClientVideoInputStream)this.videoPlayerStreams.get(n);
        if (clientVideoInputStream == null) {
            clientVideoInputStream = new ClientVideoInputStream(this, n, iVideoDestination, foxVideoStream);
            this.videoPlayerStreams.put(n, (Object)clientVideoInputStream);
        } else {
            clientVideoInputStream.reopen();
        }
        return clientVideoInputStream;
    }

    public boolean isDone() {
        return this.done;
    }

    public void startVideoReceiver() {
        this.running = true;
        super.start();
    }

    public void stopVideoReceiver() {
        this.running = false;
        this.interrupt();
    }

    protected FoxMessage readVideoFrameMessage() {
        try {
            if (log.isTraceOn()) {
                log.trace("ClientSideVideoReceiver.readVideoFrameMessage : reading message");
            }
            return this.foxCircuit.readMessage();
        }
        catch (Exception exception) {
            log.error("ClientSideVideoReceiver.readVideoFrameMessage : caught Exception: " + exception);
            this.running = false;
            return null;
        }
    }

    final int getVideoStreamId(FoxMessage foxMessage) {
        return foxMessage.getInt("videoStreamId", -1);
    }

    final byte[] getVideoFrameBytes(FoxMessage foxMessage) {
        return foxMessage.getBlob("videoFrameChunk", null);
    }

    protected void dispatchTimeout(FoxMessage foxMessage) {
        int n;
        if (log.isTraceOn()) {
            log.trace("Timeout!");
        }
        if ((n = this.getVideoStreamId(foxMessage)) < 0) {
            return;
        }
        ClientVideoInputStream clientVideoInputStream = this.getInputStream(n, null, null);
        if (clientVideoInputStream == null) {
            return;
        }
        try {
            clientVideoInputStream.close();
        }
        catch (IOException iOException) {
            log.error("Unable to close ClientVideoInputStream: " + iOException.getLocalizedMessage());
        }
    }

    protected void dispatchVideoFrameChunk(FoxMessage foxMessage) {
        Object object;
        int n;
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver.dispatchVideoFrameChunk");
        }
        if ((n = this.getVideoStreamId(foxMessage)) < 0) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver.dispatchVideoFrameChunk videoStreamId = " + n);
        }
        if (n < 0) {
            return;
        }
        ClientVideoInputStream clientVideoInputStream = (ClientVideoInputStream)this.videoPlayerStreams.get(n);
        if (clientVideoInputStream == null) {
            if (log.isTraceOn()) {
                log.trace("Received a video frame chunk for a closed or non-existant video stream id videoStreamId " + n + " Video client id = " + this.videoClientId);
            }
            try {
                this.foxVideoChannel.closeVideoStream(this.videoClientId, n);
            }
            catch (Exception exception) {
                log.error("Unable to close fox video stream. Video stream id = " + n + " Video client id = " + this.videoClientId, (Throwable)exception);
            }
            return;
        }
        BPlaybackParams bPlaybackParams = null;
        if (!clientVideoInputStream.hasReceivedAnyBytes) {
            object = foxMessage.getString("playbackParams", null);
            try {
                if (object != null) {
                    bPlaybackParams = (BPlaybackParams)ValueDocDecoder.unmarshal((String)object);
                }
            }
            catch (Exception exception) {}
        }
        if ((object = this.getVideoFrameBytes(foxMessage)) == null) {
            return;
        }
        try {
            if (!clientVideoInputStream.isPaused() && clientVideoInputStream.isBackingUp()) {
                this.getFoxVideoChannel().pauseVideoStream(this.videoClientId, n);
                clientVideoInputStream.streamPaused();
            }
        }
        catch (Exception exception) {
            log.error("Caught exception while trying to pause video stream. Video stream id = " + n, (Throwable)exception);
        }
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver.dispatchVideoFrameChunk chunk size = " + ((byte[])object).length);
        }
        try {
            clientVideoInputStream.receiveFromStation((byte[])object, bPlaybackParams);
        }
        catch (Exception exception) {
            log.error("Caught exception while processing fox video stream bytes.", (Throwable)exception);
        }
    }

    protected void dispatch(FoxMessage foxMessage) {
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver.dispatch");
        }
        String string = "";
        try {
            string = foxMessage.getString("msgType").intern();
        }
        catch (IOException iOException) {
            log.error("ClientSideVideoReceiver: no 'msgType' in the FoxMessage that was received.");
        }
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver.dispatch msgType =" + string);
        }
        if (string == "videoStreamTimeout") {
            this.dispatchTimeout(foxMessage);
        } else if (string == "videoFrameData") {
            this.dispatchVideoFrameChunk(foxMessage);
        } else {
            log.error("ClientSideVideoReceiver.dispatch unrecognized msgType: " + string);
        }
    }

    public void clientVideoInputStreamClosed(ClientVideoInputStream clientVideoInputStream) throws Exception {
        try {
            if (log.isTraceOn()) {
                log.trace("Client side video input stream closed. Video stream id = " + clientVideoInputStream.getVideoStreamId() + " Video client id = " + this.getVideoClientId());
            }
            this.videoPlayerStreams.remove(clientVideoInputStream.getVideoStreamId());
            this.foxVideoChannel.closeVideoStream(this.getVideoClientId(), clientVideoInputStream.getVideoStreamId());
        }
        catch (Exception exception) {
            log.error("Error closing video input stream", (Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.running) {
                if (log.isTraceOn()) {
                    log.trace("ClientSideVideoReceiver.run call readVideoFrameMessage");
                }
                FoxMessage foxMessage = this.readVideoFrameMessage();
                if (!this.running) continue;
                if (log.isTraceOn()) {
                    log.trace("ClientSideVideoReceiver.run call dispatch");
                }
                this.dispatch(foxMessage);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.done = true;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.done = true;
            return;
        }
    }

    public BFoxVideoChannel getFoxVideoChannel() {
        return this.foxVideoChannel;
    }

    protected ClientSideVideoReceiver(BFoxVideoChannel bFoxVideoChannel, String string, BInteger bInteger) throws Exception {
        super("ClientSideVideoReceiver:" + string);
        FoxMessage foxMessage;
        String string2;
        this.foxVideoChannel = bFoxVideoChannel;
        this.videoClientId = bInteger != null ? string + ':' + bInteger : string;
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver: Opening video circuit with station.");
        }
        this.foxCircuit = bFoxVideoChannel.openCircuit("FoxVideoCircuit");
        if (log.isTraceOn()) {
            log.trace("ClientSideVideoReceiver: Reading hello from station station.");
        }
        if ((string2 = (foxMessage = this.foxCircuit.readMessage()).getString("msgType").intern()) == "hello") {
            if (log.isTraceOn()) {
                log.trace("ClientSideVideoReceiver: Sending hello to station station.");
            }
            if (bInteger != null) {
                foxMessage.add("clientId", bInteger.getInt());
            }
            foxMessage.add("client", string);
            this.foxCircuit.writeMessage(foxMessage);
            this.videoPlayerStreams = new IntHashMap();
            if (log.isTraceOn()) {
                log.trace("ClientSideVideoReceiver: Successfully finished initializing ClientSideVideoReceiver");
            }
        } else {
            log.error("Did not receive hello from station: " + foxMessage);
            throw new IOException("Unsuccessful handshake to station: " + foxMessage);
        }
    }

    protected ClientSideVideoReceiver() throws Exception {
    }
}

