/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import com.tridium.util.EscUtil;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.util.CoalesceQueue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class VideoDecoder
implements IVideoDecoder,
Runnable {
    static int decodeId = 0;
    protected static int nextThreadId = 0;
    public static final BImage DISCONNECTED_IMAGE = BImage.make((String)"module://videoDriver/images/VideoStreamDisconnected.png");
    public static final String MULTIPART_START_PATTERN = "multipart";
    public static final String CONTENT_TYPE_KEY = EscUtil.slot.escape("content-type");
    public static final String SINGLE_IMAGE_PATTERN = "image";
    protected static final Log log = Log.getLog((String)"videoDriver.videoDecoder");
    protected static final Log keepAliveLog = Log.getLog((String)"videoDriver.videoDecoder.keepAlive");
    int myId;
    protected BIVideoSource videoSource;
    protected Array waitForStopMonitors;
    protected IVideoStream videoStream;
    protected IVideoSession videoSession;
    protected InputStream videoIn;
    protected BRelTime stopDecodingTimeout;
    protected BAbsTime timeIndex;
    protected String httpContentType;
    protected String httpPushBoundary;
    protected BIVideoPlayer videoPlayer;
    protected long subscriptionTicks;
    protected boolean requestToStop;
    boolean singleImage;
    protected Thread decodeThread;
    protected IVideoMultistreamDecoder multistreamDecoder;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$WaitForStopDecoding;

    public IVideoMultistreamDecoder getMultistreamDecoder() {
        return this.multistreamDecoder;
    }

    public void setMultistreamDecoder(IVideoMultistreamDecoder iVideoMultistreamDecoder) {
        this.multistreamDecoder = iVideoMultistreamDecoder;
    }

    public void init(BIVideoSource bIVideoSource, BIVideoPlayer bIVideoPlayer, BRelTime bRelTime, IVideoSession iVideoSession) {
        if (log.isTraceOn()) {
            this.trace("init:" + this.getClass().getName());
        }
        this.videoSource = bIVideoSource;
        this.videoPlayer = bIVideoPlayer;
        this.stopDecodingTimeout = bRelTime;
        this.httpContentType = null;
        this.httpPushBoundary = null;
        this.timeIndex = BAbsTime.NULL;
        this.videoIn = null;
        this.videoStream = null;
        this.videoSession = iVideoSession;
    }

    public boolean isFinished() {
        boolean bl = false;
        if (this.decodeThread != null && !this.decodeThread.isAlive()) {
            bl = true;
        }
        return bl;
    }

    public void stopDecoding(WaitForStopDecoding waitForStopDecoding) {
        if (log.isTraceOn()) {
            this.trace("### Somebody called 'stopDecoding'. Thread name=" + Thread.currentThread().getName());
        }
        if (waitForStopDecoding != null) {
            this.waitForStopMonitors.add((Object)waitForStopDecoding);
        }
        this.videoPlayer = null;
        this.requestToStop = true;
        if (this.decodeThread == null || !this.decodeThread.isAlive()) {
            this.notifyStopMonitors();
        }
    }

    public void keepAlive() {
    }

    protected InputStream makeInputStreamForDecoder(IVideoStream iVideoStream) {
        return iVideoStream.getInputStream();
    }

    public void receiveVideoStream(IVideoStream iVideoStream) {
        if (log.isTraceOn()) {
            this.trace("receiveVideoStream");
        }
        this.videoStream = iVideoStream;
        this.subscriptionTicks = Clock.ticks();
        if (this.videoPlayer != null) {
            this.videoPlayer.setVideoDecoder(this);
        }
        if (iVideoStream == null) {
            if (log.isTraceOn()) {
                log.trace("Cannot receive video stream, videoStream is null");
            }
            return;
        }
        this.videoIn = this.makeInputStreamForDecoder(iVideoStream);
        if (!(this.videoPlayer == null || this.decodeThread != null && this.decodeThread.isAlive())) {
            this.decodeThread = new Thread((Runnable)this, "videoDriver.decode." + ++nextThreadId);
            this.decodeThread.start();
        }
    }

    public void videoStreamTimeout() {
        this.stopDecoding(null);
    }

    public IVideoSession getVideoSession() {
        return this.videoSession;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public String getHttpContentType() {
        if (this.httpContentType == null && this.videoStream != null) {
            BFacets bFacets = this.videoStream.getPlaybackParams().getHttpRspHeader();
            this.httpContentType = bFacets.gets(CONTENT_TYPE_KEY, null);
            if (this.httpContentType != null) {
                this.httpContentType = EscUtil.slot.unescape(this.httpContentType);
            }
        }
        return this.httpContentType;
    }

    public boolean isSingleImage() {
        boolean bl = false;
        if (this.videoStream.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.pause) {
            bl = true;
        }
        return bl;
    }

    public String getHttpPushBoundary() {
        int n;
        String string;
        if (this.httpPushBoundary == null && (string = this.getHttpContentType()) != null && (n = string.indexOf("boundary=")) >= 0) {
            int n2 = n + 9;
            this.httpPushBoundary = this.getImpliedBoundaryPrefix() + string.substring(n2) + this.getImpliedBoundarySuffix();
        }
        return this.httpPushBoundary;
    }

    public boolean isMultiPartMime() {
        String string = this.getHttpContentType();
        boolean bl = false;
        if (string != null && string.startsWith(MULTIPART_START_PATTERN)) {
            bl = true;
        }
        return bl;
    }

    protected String getImpliedBoundaryPrefix() {
        return "\n--";
    }

    protected String getImpliedBoundarySuffix() {
        return "\n";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ReadFrame readFrame;
        block34: {
            BIVideoPlayer bIVideoPlayer;
            boolean bl = log.isTraceOn();
            if (bl) {
                this.trace(">> Entering run. Thread = " + Thread.currentThread().getName());
            }
            if ((bIVideoPlayer = this.getVideoPlayer()) != null) {
                bIVideoPlayer.setMessage(BVideoPlayback.LEX.getText(""));
            }
            if (bl) {
                this.trace(">> Calling initVideoStream()");
            }
            this.initVideoStream();
            this.singleImage = this.isSingleImage();
            if (bl) {
                this.trace(">> Start ReadFrame");
            }
            readFrame = new ReadFrame();
            Thread thread = new Thread((Runnable)readFrame, Thread.currentThread().getName() + "-ReadFrame");
            thread.setPriority(10);
            thread.start();
            try {
                try {
                    boolean bl2 = true;
                    long l = this.videoSource.getInterframeTimeout().getMillis();
                    while (true) {
                        if (this.requestToStop || !this.isStillBeingViewed()) {
                            if (bl) {
                                this.trace(">> Calling gracefulEndOfStream");
                            }
                            this.gracefulEndOfVideoStream();
                        }
                        bl = log.isTraceOn();
                        VidFrame vidFrame = null;
                        if (bl2) {
                            if (bl) {
                                this.trace(">> Waiting for first image from the stream");
                            }
                            vidFrame = this.readFirstFrame(readFrame);
                            bl2 = false;
                        } else {
                            if (bl) {
                                this.trace(">> Waiting for video frame.");
                            }
                            vidFrame = readFrame.getFrame((int)l);
                        }
                        if (bl) {
                            this.trace(">> Calling processImageFromStream()");
                        }
                        this.processImageFromStream(vidFrame);
                        if (this.videoSource instanceof BDevice && ((BDevice)this.videoSource).isDisabled()) {
                            if (bl) {
                                this.trace(">> VideoSource is disabled - requestToStop");
                            }
                            this.requestToStop = true;
                        }
                        if (!this.singleImage) continue;
                        this.requestToStop = true;
                    }
                }
                catch (Throwable throwable) {
                    if (!this.requestToStop && this.isStillBeingViewed()) {
                        BPlaybackParams bPlaybackParams = bIVideoPlayer.getPlaybackParams();
                        if (throwable instanceof EOFException && bPlaybackParams.getPlaybackType().isPlayForward()) {
                            if (bl) {
                                this.trace(">> EOFException occurred while ffwd, sfwd, or play. Switching to live playback...");
                            }
                            bPlaybackParams = (BPlaybackParams)bPlaybackParams.newCopy();
                            bPlaybackParams.setPlaybackType(BPlaybackTypeEnum.live);
                        } else {
                            String string = BVideoPlayback.LEX.getText("VideoDecoder.ProblemWithStream", new Object[]{throwable.getMessage(), ((BComplex)this.videoSource).getDisplayName(null)});
                            if (bl) {
                                this.trace(string);
                            }
                        }
                        if (bl) {
                            this.trace(">> Calling videoSession.changePlayback( videoPlayer.getPlaybackParams() )");
                        }
                        this.videoSession.changePlayback(bIVideoPlayer.getPlaybackParams());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (bl) {
                    this.trace(">> Shutdown readFrame");
                }
                try {
                    readFrame.close();
                }
                catch (Throwable throwable2) {}
                try {
                    this.closeStream();
                }
                catch (Throwable throwable3) {}
                this.notifyStopMonitors();
                throw throwable;
            }
            {
                Object var6_13 = null;
                if (!bl) break block34;
                this.trace(">> Shutdown readFrame");
            }
        }
        try {}
        catch (Throwable throwable) {}
        readFrame.close();
        try {}
        catch (Throwable throwable) {}
        this.closeStream();
        this.notifyStopMonitors();
    }

    private final VidFrame readFirstFrame(ReadFrame readFrame) throws Throwable {
        int n = 0;
        VidFrame vidFrame = null;
        while (vidFrame == null && n < 10) {
            String string = VideoPlaybackSession.ESTABLISH_STREAM_MESSAGE + VideoPlaybackSession.DOTS[n++ % 5];
            this.getVideoPlayer().setMessage(string);
            try {
                vidFrame = readFrame.getFrame(1000);
            }
            catch (Throwable throwable) {}
        }
        this.getVideoPlayer().setMessage("");
        return vidFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void notifyStopMonitors() {
        if (log.isTraceOn()) {
            this.trace(">> notifyStopMonitors");
        }
        if (this.waitForStopMonitors.size() <= 0) {
            return;
        }
        WaitForStopDecoding[] waitForStopDecodingArray = (WaitForStopDecoding[])this.waitForStopMonitors.trim();
        int n = 0;
        while (n < waitForStopDecodingArray.length) {
            WaitForStopDecoding waitForStopDecoding = waitForStopDecodingArray[n];
            // MONITORENTER : waitForStopDecoding
            {
                waitForStopDecodingArray[n].setStopped();
                // MONITOREXIT : waitForStopDecoding
                ++n;
            }
        }
    }

    protected void gracefulEndOfVideoStream() {
        this.trace("gracefulEndOfVideoStream");
    }

    protected void initVideoStream() {
    }

    protected VidFrame updateImageFromStream() throws IOException, InterruptedIOException {
        VidFrame vidFrame = this.initVidFrame();
        try {
            this.readFrameData(vidFrame);
            this.decodeFrame(vidFrame);
        }
        catch (Exception exception) {
            if (this.requestToStop) {
                return null;
            }
            throw new BajaRuntimeException("Unable to parse video frame", (Throwable)exception);
        }
        return vidFrame;
    }

    protected VidFrame initVidFrame() {
        return new VidFrame();
    }

    public abstract void readFrameData(VidFrame var1) throws Exception;

    public abstract void decodeFrame(VidFrame var1) throws Exception;

    protected void processImageFromStream(VidFrame vidFrame) {
        if (vidFrame != null && vidFrame.image != null && this.videoPlayer != null) {
            this.videoPlayer.updateVideoFrame(vidFrame);
        }
    }

    protected void frameStarting() throws IOException {
    }

    protected void frameFinished() throws IOException {
    }

    protected void closeStream() {
        if (log.isTraceOn()) {
            this.trace(">> Calling closeStream()");
        }
        if (this.videoStream != null) {
            block5: {
                try {
                    this.videoStream.closeVideoStream();
                }
                catch (IOException iOException) {
                    if (!log.isTraceOn()) break block5;
                    this.trace(">> Caught IOException while calling closeStream(): " + iOException);
                }
            }
            this.videoStream = null;
        }
        if (this.videoPlayer != null && !this.singleImage) {
            this.videoPlayer.setMessage(BVideoPlayback.LEX.getText("StreamClosed"));
        }
    }

    public boolean isStillBeingViewed() {
        boolean bl;
        boolean bl2 = false;
        if (this.videoPlayer != null && this.videoPlayer.isRunning()) {
            bl2 = bl = true;
        }
        if (keepAliveLog.isTraceOn()) {
            keepAliveLog.trace("isStillBeingViewed = " + bl);
        }
        return bl;
    }

    public IVideoStream getVideoStream() {
        return this.videoStream;
    }

    public IVideoDecoder getVideoDecoder() {
        return this;
    }

    public BRelTime getStopDecodingTimeout() {
        return this.stopDecodingTimeout;
    }

    public BIVideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    protected void trace(String string) {
        log.trace("[" + this.myId + "] " + string);
    }

    protected void trace(String string, Throwable throwable) {
        log.trace("[" + this.myId + "] " + string, throwable);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.myId = decodeId++;
        Class clazz = class$com$tridium$videoDriver$videoStream$WaitForStopDecoding;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$videoStream$WaitForStopDecoding = VideoDecoder.class("[Lcom.tridium.videoDriver.videoStream.WaitForStopDecoding;", false);
        }
        this.waitForStopMonitors = new Array(clazz);
        this.videoIn = null;
        this.timeIndex = BAbsTime.NULL;
        this.httpContentType = null;
        this.httpPushBoundary = null;
        this.subscriptionTicks = 0L;
    }

    public VideoDecoder() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ReadFrame
    implements Runnable {
        boolean done;
        CoalesceQueue q;

        public void run() {
            while (!this.done && !VideoDecoder.this.requestToStop) {
                VidFrame vidFrame;
                boolean bl = log.isTraceOn();
                try {
                    VideoDecoder.this.frameStarting();
                    if (bl) {
                        VideoDecoder.this.trace(">>>> Calling updateImageFromStream()");
                    }
                    vidFrame = VideoDecoder.this.updateImageFromStream();
                    if (bl) {
                        if (vidFrame != null) {
                            VideoDecoder.this.trace(">>>> updateImageFromStream success.");
                        } else {
                            VideoDecoder.this.trace(">>>> updateImageFromStream returned null.");
                        }
                    }
                    VideoDecoder.this.frameFinished();
                }
                catch (Throwable throwable) {
                    if (this.done || VideoDecoder.this.requestToStop) {
                        return;
                    }
                    if (bl) {
                        VideoDecoder.this.trace(">>>> updateImageFromStream threw :" + throwable, throwable);
                    }
                    vidFrame = VideoDecoder.this.initVidFrame();
                    vidFrame.imageThrowable = throwable;
                    this.done = true;
                }
                if (vidFrame != null) {
                    this.q.enqueue((Object)vidFrame);
                }
                if (!VideoDecoder.this.singleImage) continue;
                this.done = true;
            }
            this.q.clear();
            if (log.isTraceOn()) {
                VideoDecoder.this.trace(">>>> Exit ReadFrame");
            }
        }

        VidFrame getFrame(int n) throws Throwable {
            VidFrame vidFrame = (VidFrame)this.q.dequeue(n);
            if (vidFrame == null) {
                throw new IOException("Timeout waiting for video frame from " + VideoDecoder.this.videoSource.getSlotPathOrd());
            }
            if (vidFrame.imageThrowable != null) {
                throw vidFrame.imageThrowable;
            }
            if (log.isTraceOn()) {
                VideoDecoder.this.trace(">>>> return image ");
            }
            return vidFrame;
        }

        void close() {
            if (log.isTraceOn()) {
                VideoDecoder.this.trace(">>>> close ");
            }
            this.done = true;
            this.notify();
        }

        private final /* synthetic */ void this() {
            this.done = false;
            this.q = new CoalesceQueue();
        }

        private ReadFrame() {
            this.this();
        }
    }
}

